/*____________________________________________________________________________
	Copyright (C) 1999 Pretty Good Privacy, Inc.
	All rights reserved.
	

	$Id: RevealNoteHandle.h,v 1.11.12.4 2000/08/09 01:23:09 build Exp $
____________________________________________________________________________*/

#ifndef Included_RevealNoteHandle_h	/* [ */
#define Included_RevealNoteHandle_h


#include <stdlib.h>
#include <string.h>
#include <crtdbg.h>

// Notes API includes
#include <global.h>
#include <nsfdb.h>
#include <nsfnote.h>
#include <nsferr.h>
#include <extmgr.h>
#include <misc.h>		//for TIMEDATE stuff
#include <miscerr.h>	//for ERR_NOT_FOUND
#include <ostime.h>		//for OSCurrentTIMEDATE()
#include <osmem.h>		//for OSLockObject(), etc.
#include <oserr.h>		//for ERR_MEMORY
#include <osmisc.h>		//for OSLoadString()


extern const STATUS  eus_SUCCESS;
extern const int  ei_SAME;

extern CRITICAL_SECTION  ecs;


typedef struct { 
	TIMEDATE  td_testStamp; 
	UNID * punid; 
	NOTEHANDLE  h_note;
	TIMEDATE  td_inserted;
}  NoteInfo;

typedef struct _NoteInfoNode { 
	NoteInfo  t_NoteInfo;
	struct _NoteInfoNode * pt_next;
}  NoteInfoNode;


static STATUS LNPUBLIC us_PostNoteOpen( DBHOOKVEC *, char *, LIST *, 
									DBHANDLE, NOTEID, NOTEHANDLE, const WORD);
static void RemoveOldListNodes( NoteInfoNode * *const, CRITICAL_SECTION);
static STATUS us_AddNoteInfoNode( const NoteInfo *const, 
									NoteInfoNode * *const, CRITICAL_SECTION);
static void FreeNoteInfoNode( NoteInfoNode * *const);
static BOOL f_aToHexUl( const char *const, unsigned long *const);
static BOOL f_ConstructUnidFromStr( const char[], UNID *const, BOOL *const);
static __inline TIMEDATE * ptd_PreserveHundredthTicks( TIMEDATE *const);

#endif /* ] Included_RevealNoteHandle_h */
