/*____________________________________________________________________________
	Copyright (C) 2000 Pretty Good Privacy, Inc.
	All rights reserved.


	$Id: nPGPNts.h,v 1.15.12.9 2000/08/09 01:23:14 build Exp $
____________________________________________________________________________*/

#ifndef Included_nPGPNts_h	/* [ */
#define Included_nPGPNts_h


//system includes
#include <windows.h>	//for MessageBox(), string.h, etc.
#include <stdlib.h>		//for malloc(), free(), etc.
#include <stdio.h>		//for sprintf()
#include <crtdbg.h>		//for debug macros like _ASSERTE()

#include "NotesApiGlobals.h"
//Notes API includes
#include <nsfnote.h>
#include <nsferr.h>		//for ERR_NOTE_BADATTSIGN, etc.
#include <textlist.h>	//for ListGetNumEntries()
#include <osmem.h>		//for OSLock(), etc.
#include <lookup.h>		//for NAMELookup(), etc.
#include <osmisc.h>		//for OSLoadString()
#include <dbdrverr.h>	//for ERR_DBD_INVALID_ARGUMENT

#include "LibRichText.h"
#include "LibItem.h"
#include "LibObject.h"
#include "LibNab.h"
#include "LibFileSystem.h"
#include "VbCallable.h"


#define i_LEN_OPAQUE_PGP_ENCODE_CONTEXT  52 + 4
typedef struct	{
	BOOL  f_Sign;
	BOOL  f_Encrypt;
	BYTE  opaque[ i_LEN_OPAQUE_PGP_ENCODE_CONTEXT];
}  PgpEncodeContext;

typedef struct	{
	NameFoundInfo  t;
	char * pc_parent;
}  NameFoundInfoEx;

typedef struct	{
	HANDLE  h_content;					//handle to memory buffer holding the 
						//	rich-text field content
	DWORD  ul_len;						//length of content in buffer
	NOTEHANDLE  h_note;					//handle to the Notes document upon 
						//	which any reset will occur
}	ResettableRtfInfo;


extern const int  ei_USER_ABORT;
extern char  epc_APPNM[], epc_ITEMNM_STANDARD_ATTACH[];

extern HWND  eh_mainWnd;


STATUS eus_ExtMgrClear( void);
int ei_InitializePgpContext( void);
void e_ReleasePgpContext( void);
int ei_TestForPgpAscii( const char *const, BOOL *const);
int ei_PgpDecodeBuffer( const char *const, const BOOL, char * *const, 
																DWORD *const);
void e_FreePgpMem( BYTE *const);
int ei_PgpEncodeBuffer( char *const, const DWORD, PgpEncodeContext *const, 
									const BOOL, long *const, char * *const);
int ef_FreePgpEncodeContext( PgpEncodeContext *const);
int ei_SetUpPgpEncodeContext( const BOOL, const BOOL, 
										PgpEncodeContext *const, BOOL *const);
int ei_ResolveEncryptionKeys( char * *const, const UINT, const BOOL, 
													PgpEncodeContext *const);
int ei_FindAndDecodePgpBlock( char * *const, const DWORD, char * *const, 
									DWORD *const, char * *const, int *const);
int ei_PgpEncodeFile( PgpEncodeContext *const, char *const, char *const);
int ei_PgpLookupEmailLocal( PgpEncodeContext *const, NameFoundNode *);
int ei_PgpLookupEmailViaServers( PgpEncodeContext *const, NameFoundNode *);
STATUS xs_PgpSecureMessage( NOTEHANDLE, BOOL, BOOL, char[], const BOOL, 
												char[], const int, char[], 
												ResettableRtfInfo *const);
void e_ClearRevealNoteHandleContext( CRITICAL_SECTION);

static STATUS us_ReplacePgpAsciiRichText( const char *const, 
											const char *const, const DWORD, 
											const char *const, RtfCursor, 
											RtfContext *const);
static int i_PgpAdjustNotesNames( const BOOL, const UINT, char *const *const, 
													PgpEncodeContext *const);
static int i_PgpDecodeUsingAsciiText( NOTEHANDLE, char[], const RtfCursor, 
											RtfContext *const, BOOL *const);
static int i_PgpDecodeUsingRichTextObj( const DWORD, const DWORD, 
										const BLOCKID, NOTEHANDLE, char[], 
										RtfContext *const, int *const);
static int i_PgpEncodeAttachments( PgpEncodeContext *const, NOTEHANDLE, 
												RtfCursor, RtfContext *const);
static __inline int i_PgpEncodeRtfText( PgpEncodeContext *const, 
											RtfContext *const, char * *const);
static STATUS us_CreateRecipientsArray( char[], const BOOL, char[], 
													char * * *const, 
													UINT *const, BOOL *const);
static __inline void FreeAllocatedStringArray( char * * *const, const DWORD);
static int i_PgpEncodeRtfAsAttachment( PgpEncodeContext *const, NOTEHANDLE, 
										const RtfContext *const, 
										RtfContext *const, BLOCKID *const);
static BOOL f_TestForPgpRtfAttachment( RtfCursor, const RtfContext, 
																BOOL *const);
static STATUS us_LocatePgpRtfAttachment( RtfCursor, const RtfContext *const, 
												NOTEHANDLE, DWORD *const, 
												DWORD *const, BLOCKID *const);
static STATUS us_SetupRtfAttachParagraph( NOTEHANDLE, RtfContext *const, 
																char *const);


#endif /* ] Included_nPGPNts_h */
