/*____________________________________________________________________________
	Copyright (C) 1999 Pretty Good Privacy, Inc.
	All rights reserved.
	

	$Id: nPGPext.c,v 1.4.8.1.2.4 2000/08/09 01:23:14 build Exp $
____________________________________________________________________________*/

/*::: MODULE OVERVIEW :::::::::::::
DOC!!

--- revision history --------
12/30/98 Version 1.0: Paul Ryan
::::::::::::::::::::::::::::::::::::*/

#include "nPGPext.h"


static const STATUS  mus_SUCCESS = NOERROR;
static BOOL  mf_hooksRegistered;
static HEMREGISTRATION  mul_hEmPostNoteCreate;


/**	xus_ExtMgrInit( ***
Purpose is to initialize this DLL as a Notes API Extension Manager DLL. This 
function must possess export ordinal 1 for this DLL, so Notes will know how 
to call it. It's probably best to explicitly specify it with @1 in the DLL's 
*.DEF file.

--- return -------------
RETURN: mus_SUCCESS if no error occurred, the error code otherwise

--- revision history ---
12/30/98 PR: created	*/
STATUS LNPUBLIC xus_ExtMgrInit()	{
	WORD  us_recursionID;
	STATUS  us_err;

	//When run on a server the DLL is called multiple times. Short-circuit 
	//	here if the callback hooks have already been registerd.
	if (mf_hooksRegistered)
		return mus_SUCCESS;

	//Even though they haven't yet, say now that hooks have been registered 
	//	so that the registration functions won't be called again and again 
	//	when something's wrong.
	mf_hooksRegistered = TRUE; 

	//It's good default practice to prevent recursion, so get an ID that 
	//	Notes will use internally to stop Extension Manager from being 
	//	called recursively within a particular thread.
	if (us_err = EMCreateRecursionID( &us_recursionID))
		return us_err;

	//register callbacks to be fired after note creation and note open
	return EMRegister( EM_NSFNOTECREATE, EM_REG_AFTER, us_PostNoteCreate, 
									us_recursionID, &mul_hEmPostNoteCreate);
} //xus_ExtMgrInit(


/** DllMain( ***
Win32 entry point for loading and unloading this DLL.  We use the unload 
event to release all Extension Manager hooks and for freeing allocated memory.

--- parameters & return ---
h_DllInstance: the overall handle to this DLL's runtime information, settings
ul_reason: parameter tells why the function was called
pv_reserved: just that, reserved

--- revision history ------
12/30/98 PR: created		*/
BOOL WINAPI DllMain( HINSTANCE  h_DllInstance, 
						DWORD  ul_reason, 
						LPVOID  pv_reserved)	{
	STATUS  us_err;

	switch (ul_reason)	{
		case DLL_PROCESS_ATTACH:
			//Set up debugging aids and the memory-leak detector in 
			//	particular.  Lines are preprocessed out in Release builds.
			_CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_DEBUG | 
														_CRTDBG_MODE_WNDW);
			_CrtSetDbgFlag( _CRTDBG_LEAK_CHECK_DF | 
										_CrtSetDbgFlag( _CRTDBG_REPORT_FLAG));

			break;

		case DLL_PROCESS_DETACH:
			mf_hooksRegistered = FALSE;

			//deregister Extension Manager routines
			us_err = EMDeregister( mul_hEmPostNoteCreate);
	} //switch (ul_reason)

	return TRUE;
} //DllMain(


/** us_PostNoteCreate( ***
Purpose is to trap the NSFNoteCreate call made by the Notes core when it 
creates a new document.  This allows us an opportunity to store the 
note's handle in a manner whereby LotusScript can obtain it for later Notes 
API work using the current document "session."  Here we use the note's 
accessed date as a comparison point for LotusScript to query once the handle 
is needed.

--- parameter & return ---
pt_ExRecord: Structure containing context information about the current 
	Extension Manager call.  Most important, a pointer to the parameter 
	list passed to the just-completed (but not returned) NSFNoteCreate call.
RETURN: ERR_EM_CONTINUE if function is successful, a Notes API error code 
	otherwise

--- revision history -----
12/31/98 PR: created		*/
static STATUS LNCALLBACK us_PostNoteCreate( EMRECORD * pt_ExRecord)	{
    VARARG_PTR  pv;
	NOTEHANDLE  h_note;
    STATUS us_err;

	_ASSERTE( pt_ExRecord->EId == EM_NSFNOTECREATE);

	//if the NSFNoteCreate call didn't succeed, ignore this call
	if (pt_ExRecord->Status != mus_SUCCESS)
		return ERR_EM_CONTINUE;

	//if the first argument isn't a real database handle, short-circuit with 
	//	success
    pv = pt_ExRecord->Ap;
	if (!VARARG_GET( pv, DBHANDLE))
		return ERR_EM_CONTINUE;

	//get the note's handle
	h_note = *(NOTEHANDLE *) VARARG_GET( pv, NOTEHANDLE *);

	if (us_err = xus_PostNoteCreate( h_note))
		return us_err;

	return ERR_EM_CONTINUE;
} //us_PostNoteCreate(


