/*____________________________________________________________________________
	Copyright (C) 1999 Pretty Good Privacy, Inc.
	All rights reserved.
	

	$Id: ndbPGP.c,v 1.9.8.1.2.7 2000/08/09 01:23:15 build Exp $
____________________________________________________________________________*/

/*::: MODULE OVERVIEW :::::::::::::
Interface to the Lotus Notes "database-driver" API interface -- the only 
means by which an @Formula may call a custom DLL procedure.

--- revision history ---------
8/27/99 Version 1.1: Paul Ryan
+ pre-mail send logic adjustment

1/10/99 Version 1.0: Paul Ryan
::::::::::::::::::::::::::::::::::::*/

#include "ndbPGP.h"


const STATUS  eus_SUCCESS = NOERROR;


static HINSTANCE  mpl_hInstance;


/** xus_MailSendHookInitialize( ***


--- parameter & return ----

RETURN: eus_SUCCESS if no error occured; the Notes API error code otherwise

--- revision history ------
12/10/98 PR: created			*/
//DOC!!
STATUS LNPUBLIC xus_MailSendHookInitialize( DBVEC * pt_drv)	{
    //fill in the subroutine vectors
    pt_drv->Init = xus_MailSendHookInitialize;
    pt_drv->Term = us_dmyTerminate;
    pt_drv->Open = us_dmyOpen;
    pt_drv->Close = us_dmyClose;
	pt_drv->Function = s_PreMailSend;

	return eus_SUCCESS;
} //DBDInit


static STATUS LNPUBLIC us_dmyTerminate( DBVEC * pt_drv) {
    return eus_SUCCESS;
} //us_dmyTerminate(


static STATUS LNPUBLIC us_dmyOpen( DBVEC * pt_drv, 
									HDBDSESSION * ppv_dmySession)	{
    *ppv_dmySession = NULL;
    return eus_SUCCESS;
} //us_dmyOpen(


static STATUS LNPUBLIC us_dmyClose( DBVEC * pt_drv, 
									HDBDSESSION  pv_dmy)	{
    return eus_SUCCESS;
} //us_dmyClose(


/** s_PreMailSend( ***


--- parameters & return ----

RETURN: eus_SUCCESS if no error occured; the Notes API error code otherwise

--- revision history -------
8/27/99 PR: logic adjustments to support enhancement of better emulation of 
	Lotus Notes' name-lookup behavior, including removal of recipient-count 
	parameter

12/10/98 PR: created		*/
//DOC!!
static short LNPUBLIC s_PreMailSend( DBVEC * pt_drv, 
										HDBDSESSION  pv_dmy,
										WORD  us_function,
										WORD  us_argc, 
										DWORD * pul_argl, 
										void * *const  ppv_argv,
										HANDLE * ph_result, 
										DWORD * pul_lenResult)	{
	const WORD  us_EXPECTED_DBCOMMAND_ARGS = 7;

	//if any of the important parameters are obviously invalid, return 
	//	general failure
	if (!( us_function == DB_DBEXT && us_argc == 
									us_EXPECTED_DBCOMMAND_ARGS && pul_argl && 
									ppv_argv && ph_result && pul_lenResult))
		return !eus_SUCCESS;

	return xs_PreMailSend( ppv_argv);
} //s_PreMailSend(


/** DllMain( ***
Win32 entry point for loading and unloading this DLL.

--- parameters & return ---
h_DllInstance: the overall handle to this DLL's runtime information, settings
ul_reason: parameter tells why the function was called
pv_reserved: just that, reserved

--- revision history ------
11/18/98 PR: created		*/
BOOL WINAPI DllMain( HINSTANCE  h_DllInstance, 
						DWORD  ul_reason, 
						LPVOID  pv_reserved)	{
	switch (ul_reason)	{
		case DLL_PROCESS_ATTACH:
			//Set up debugging aids and the memory-leak detector in 
			//	particular.  Lines are preprocessed out in Release builds.
			_CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_DEBUG | 
														_CRTDBG_MODE_WNDW);
			_CrtSetDbgFlag( _CRTDBG_LEAK_CHECK_DF | 
										_CrtSetDbgFlag( _CRTDBG_REPORT_FLAG));
	} //switch (ul_reason)

	return TRUE;
} //DllMain(


