/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: UnknownWndProc.cpp,v 1.12.10.1 1999/08/06 18:04:04 dgal Exp $
____________________________________________________________________________*/

#include <windows.h>
#include <commctrl.h>
#include "PluginInfo.h"
#include "HookProcs.h"
#include "UIutils.h"
#include "TextIO.h"
#include "Prefs.h"
#include "resource.h"

void CreateMessageWindowGUI(HWND hDlg, PluginInfo *plugin, WNDPROC lpOldProc);

static LRESULT CALLBACK ToolbarWndProc(HWND hDlg, 
									   UINT msg,
									   WPARAM wParam, 
									   LPARAM lParam);


LRESULT CALLBACK UnknownWndProc(HWND hDlg, 
								UINT msg,
								WPARAM wParam, 
								LPARAM lParam)
{
	WNDPROC lpOldProc;
	PluginInfo *plugin;

	lpOldProc = (WNDPROC)GetProp( hDlg, "oldproc" );
	plugin = GetPluginInfo(hDlg);

	switch(msg)
	{
	case WM_PARENTNOTIFY:
		if (LOWORD(wParam) == WM_CREATE)
		{
			CreateMessageWindowGUI(hDlg, plugin, lpOldProc);
			break;
		}

	case WM_DESTROY:
		{
			FreePluginInfo(plugin);
			break;
		}
	}

	return CallWindowProc(lpOldProc, hDlg, msg, wParam, lParam);
}


void CreateMessageWindowGUI(HWND hDlg, PluginInfo *plugin, WNDPROC lpOldProc)
{
	HWND hSizableRebar;
	HWND hReBar;
	HINSTANCE hInst;
	char szText[255];
	MENUITEMINFO menuInfo;
	BOOL bSend = FALSE;
	int nCount;

	hSizableRebar = FindWindowEx(hDlg, NULL, "SizableRebar", NULL);
	if (hSizableRebar != NULL)
		plugin->bOE5 = TRUE;

	plugin->hStatusBar = FindWindowEx(hDlg, NULL, "msctls_statusbar32", NULL);

	if (plugin->bOE5)
	{
		hReBar = FindWindowEx(hSizableRebar, NULL, "ReBarWindow32", NULL);
		plugin->hToolbar = FindWindowEx(hReBar, NULL, "ToolbarWindow32", 
							NULL);
		plugin->hMenuToolbar = FindWindowEx(hReBar, plugin->hToolbar, 
									"ToolbarWindow32", NULL);

		if (!plugin->hMenuToolbar || !plugin->hToolbar || !plugin->hStatusBar)
			return;
	}
	else
	{
		hReBar = FindWindowEx(hDlg, NULL, "ReBarWindow32", NULL);
		plugin->hToolbar = FindWindowEx(hReBar, NULL, "ToolbarWindow32", 
							NULL);
		plugin->hMainMenu = GetMenu(hDlg);
		
		if (!plugin->hMainMenu || !plugin->hToolbar || !plugin->hStatusBar)
			return;
	}
	
	plugin->hEdit = NULL;
	plugin->szReplyText = NULL;
	hInst = UIGetInstance();
	
	// Subclass the Window
	if (plugin->bOE5)
		nCount = SendMessage(plugin->hMenuToolbar, TB_BUTTONCOUNT, 0, 0);
	else
		nCount = GetMenuItemCount(plugin->hMainMenu);

	if (nCount == 8)
	{
		SetProp(plugin->hToolbar, TOOLBAR_TYPE_PROP, (HANDLE) 1);
		SetWindowLong(hDlg, GWL_WNDPROC, (DWORD)SendMsgWndProc);
		plugin->nPGPPosition = 5;
		bSend = TRUE;
	}
	else if (nCount == 6)
	{
		SetProp(plugin->hToolbar, TOOLBAR_TYPE_PROP, (HANDLE) 0);
		SetWindowLong(hDlg, GWL_WNDPROC, (DWORD)ReadMsgWndProc);
		plugin->nPGPPosition = 4;
	}
	else
	{
		SetWindowLong(hDlg, GWL_WNDPROC, (DWORD)lpOldProc);
		FreePluginInfo(plugin);
		return;
	}
	
	if (plugin->bOE5)
	{
		if (plugin->hPGPMenu != NULL)
			DestroyMenu(plugin->hPGPMenu);
		
		plugin->hPGPMenu = CreatePopupMenu();
		plugin->nPGPPosition = -1;
	}
	else
	{
		menuInfo.cbSize = sizeof(MENUITEMINFO);
		menuInfo.fMask = MIIM_SUBMENU;
		GetMenuItemInfo(plugin->hMainMenu, plugin->nPGPPosition, TRUE, 
			&menuInfo);
		plugin->hToolsMenu = menuInfo.hSubMenu;
		
		plugin->hPGPMenu = CreatePopupMenu();
		InsertMenu(plugin->hMainMenu, plugin->nPGPPosition, 
			MF_BYPOSITION | MF_STRING | MF_POPUP, 
			(UINT) plugin->hPGPMenu, "&PGP");
	}

	if (bSend)
	{
		if (!(plugin->bOE5))
		{
			GetMenuString(plugin->hToolsMenu, ENCRYPT_SMIME_POS, szText, 254, 
				MF_BYPOSITION);
			
			if (!strcmp(szText, "&Encrypt"))
			{
				UIGetString(szText, 254, IDS_MENU_PGP_ENCRYPT);
				InsertMenu(plugin->hToolsMenu, ENCRYPT_PGP_POS, 
					MF_BYPOSITION | MF_STRING, IDC_ENCRYPT_PGP, szText);
				
				UIGetString(szText, 254, IDS_MENU_PGP_SIGN);
				InsertMenu(plugin->hToolsMenu, SIGN_PGP_POS, 
					MF_BYPOSITION | MF_STRING, IDC_SIGN_PGP, szText);
				
				menuInfo.cbSize = sizeof(MENUITEMINFO);
				menuInfo.fMask = MIIM_TYPE;
				menuInfo.fType = MFT_STRING;
				menuInfo.dwTypeData = szText;
				
				UIGetString(szText, 254, IDS_MENU_SMIME_ENCRYPT);
				SetMenuItemInfo(plugin->hToolsMenu, ENCRYPT_SMIME_POS, TRUE, 
					&menuInfo);
				
				UIGetString(szText, 254, IDS_MENU_SMIME_SIGN);
				SetMenuItemInfo(plugin->hToolsMenu, SIGN_SMIME_POS, TRUE, 
					&menuInfo);
			}
			else
			{
				UIGetString(szText, 254, IDS_MENU_PGP_ENCRYPT);
				AppendMenu(plugin->hToolsMenu, MF_STRING, IDC_ENCRYPT_PGP, 
					szText);
				
				UIGetString(szText, 254, IDS_MENU_PGP_SIGN);
				AppendMenu(plugin->hToolsMenu, MF_STRING, IDC_SIGN_PGP, 
					szText);
			}
		}

		AddSendToolbarButtons(plugin);
		plugin->bEncrypt = ByDefaultEncrypt(plugin->memoryMgr);
		plugin->bSign = ByDefaultSign(plugin->memoryMgr);
		
		SetTimer(hDlg, PASTE_REPLY_TIMER, 250, 0);
	}
	else
	{
		if (!(plugin->bOE5))
		{
			UIGetString(szText, 254, IDS_MENU_DECRYPT);
			AppendMenu(plugin->hPGPMenu, MF_STRING, IDC_DECRYPT, szText);
		
			AppendMenu(plugin->hPGPMenu, MF_SEPARATOR, NULL, NULL);
		}

		AddReadToolbarButtons(plugin);

		if (AutoDecrypt(plugin->memoryMgr))
			SetTimer(hDlg, AUTO_DECRYPT_TIMER, 500, 0);
	}
	
	UIGetString(szText, 254, IDS_MENU_PREFS);
	AppendMenu(plugin->hPGPMenu, MF_STRING, IDC_PREFS, szText);
	
	UIGetString(szText, 254, IDS_MENU_PGPKEYS);
	AppendMenu(plugin->hPGPMenu, MF_STRING, IDC_PGPKEYS, szText);
	
	if (plugin->bOE5)
	{
		if (GetProp(plugin->hToolbar, "oldproc") == NULL)
		{
			// Save away toolbar parent window proc
			SetProp(plugin->hToolbar, "oldproc", 
				(HANDLE) GetWindowLong(plugin->hToolbar, GWL_WNDPROC)); 

			// Save plugin pointer
			SetProp(plugin->hToolbar, PLUGIN_INFO_PROP, (HANDLE) plugin);

			// Subclass toolbar window
			SetWindowLong(plugin->hToolbar, GWL_WNDPROC, 
				(DWORD) ToolbarWndProc);
		}

		if (GetProp(hReBar, "oldproc") == NULL)
		{
			// Save away toolbar parent window proc
			SetProp(hReBar, "oldproc", 
				(HANDLE) GetWindowLong(hReBar, GWL_WNDPROC)); 

			// Save plugin pointer
			SetProp(hReBar, PLUGIN_INFO_PROP, (HANDLE) plugin);

			// Subclass toolbar parent window
			if (bSend)
				SetWindowLong(hReBar, GWL_WNDPROC, 
					(DWORD) SendToolbarParentWndProc);
			else
				SetWindowLong(hReBar, GWL_WNDPROC, 
					(DWORD) ReadToolbarParentWndProc);
		}
	}
	else	
		DrawMenuBar(hDlg);
	
	if (bSend && !(plugin->bOE5))
		SetTimer(hDlg, CORRECT_TOOLBAR_TIMER, 250, 0);

	return;
}


static LRESULT CALLBACK ToolbarWndProc(HWND hDlg, 
									   UINT msg,
									   WPARAM wParam, 
									   LPARAM lParam)
{
	WNDPROC lpOldProc;
	PluginInfo *plugin;
	UINT nState;
	UINT nOldState;
	LRESULT lResult;
	BOOL bSend;

	lpOldProc = (WNDPROC)GetProp( hDlg, "oldproc" );
	plugin = GetPluginInfo(hDlg);
	bSend = (BOOL) GetProp(hDlg, TOOLBAR_TYPE_PROP);

	if ((msg == WM_USER+59) && (lParam == 0x00460000) && 
		(plugin->nButtonSizeX > 0) && (plugin->nButtonSizeY > 0))
	{
		DWORD dwSize;
		INT nX;
		INT nY;
		
		dwSize = SendMessage(hDlg, TB_GETBUTTONSIZE, 0, 0);
		nX = LOWORD(dwSize);
		nY = HIWORD(dwSize);
		
		if (!dwSize)
			return CallWindowProc(lpOldProc, hDlg, msg, wParam, lParam);

		if ((nX != plugin->nButtonSizeX) || 
			(nY != plugin->nButtonSizeY))
		{
			lResult = CallWindowProc(lpOldProc, hDlg, msg, wParam, lParam);

			SendMessage(hDlg, TB_SETBUTTONSIZE, 0, 
				MAKELONG(plugin->nButtonSizeX, plugin->nButtonSizeY));

			return lResult;
		}
	}

	lResult = CallWindowProc(lpOldProc, hDlg, msg, wParam, lParam);

	nState = CallWindowProc(lpOldProc, hDlg, TB_GETSTATE, IDC_PGPKEYS, 0);
	if (!(nState & TBSTATE_ENABLED))
	{
		nState |= TBSTATE_ENABLED;
		CallWindowProc(lpOldProc, hDlg, TB_SETSTATE, IDC_PGPKEYS,
			MAKELONG(nState, 0));
	}

	if (bSend)
	{
		nState = CallWindowProc(lpOldProc, hDlg, TB_GETSTATE, IDC_SIGN_PGP, 
					0);
		nOldState = nState;

		if (!(nState & TBSTATE_ENABLED))
			nState |= TBSTATE_ENABLED;

		if (plugin->bSign)
		{
			if (!(nState & TBSTATE_CHECKED))
				nState |= TBSTATE_CHECKED;
		}
		else
		{
			if (nState & TBSTATE_CHECKED)
				nState ^= TBSTATE_CHECKED;
		}

		if (nState != nOldState)
		{
			CallWindowProc(lpOldProc, hDlg, TB_SETSTATE, IDC_SIGN_PGP,
				MAKELONG(nState, 0));
		}

		nState = CallWindowProc(lpOldProc, hDlg, TB_GETSTATE, IDC_ENCRYPT_PGP, 
					0);
		nOldState = nState;

		if (!(nState & TBSTATE_ENABLED))
			nState |= TBSTATE_ENABLED;

		if (plugin->bEncrypt)
		{
			if (!(nState & TBSTATE_CHECKED))
				nState |= TBSTATE_CHECKED;
		}
		else
		{
			if (nState & TBSTATE_CHECKED)
				nState ^= TBSTATE_CHECKED;
		}

		if (nState != nOldState)
		{
			CallWindowProc(lpOldProc, hDlg, TB_SETSTATE, IDC_ENCRYPT_PGP,
				MAKELONG(nState, 0));
		}
	}
	else
	{
		TBBUTTON tb;

		nState = CallWindowProc(lpOldProc, hDlg, TB_GETSTATE, IDC_DECRYPT, 0);
		if (!(nState & TBSTATE_ENABLED))
		{
			nState |= TBSTATE_ENABLED;
			CallWindowProc(lpOldProc, hDlg, TB_SETSTATE, IDC_DECRYPT,
				MAKELONG(nState, 0));
		}

		nState = CallWindowProc(lpOldProc, hDlg, TB_COMMANDTOINDEX,
					IDC_DECRYPT, 0);

		CallWindowProc(lpOldProc, hDlg, TB_GETBUTTON, nState - 2, 
			(LPARAM) &tb);

		if (tb.fsStyle & TBSTYLE_SEP)
			CallWindowProc(lpOldProc, hDlg, TB_DELETEBUTTON, nState - 2, 0);
	}

	return lResult;
}


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
