#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <System/FileStream.h>
#include <libopgp.h>
#include "opgptst.h"

extern keyid_t keys[];

static FileHand file;

#define MAXRECS 64
static VoidHand abhand[MAXRECS];
static char *abemail[MAXRECS], *pgpk[MAXRECS];
static UInt recnum[MAXRECS];
static struct {
  ULong opts;
  ULong flags;
  unsigned char dummy;
  char fields[1];
} *arecptr;

static void ScanAddrDB()
{
  LocalID Addrid;
  VoidHand hand1;
  UInt dbrec;
  char *emptr = NULL, *pkptr;
  ULong locf;
  int i, nemails = 0;
  FileHand ofile;
  FormPtr renf;
  unsigned char *bp;
  ListPtr keylist;
  DmOpenRef AddrDB;

  if (!(renf = FrmInitForm(fsetkey)))
    return;
  Addrid = DmFindDatabase(0, "AddressDB");
  AddrDB = DmOpenDatabase(0, Addrid, dmModeReadOnly | dmModeShowSecret);
  if (!AddrDB)
    ErrDisplay("No Addr DB");

  WinDrawChars("Address Book        ", 20, 0, 20);
  nemails = 0;
  for (dbrec = 1; dbrec < DmNumRecords(AddrDB); dbrec++) {

    if (!(hand1 = DmGetRecord(AddrDB, dbrec))
        || !(arecptr = MemHandleLock(hand1)))
      break;

    WinDrawChars(arecptr->fields, StrLen(arecptr->fields) > 12 ? 12 : StrLen(arecptr->fields), 0, 32);

    pkptr = 0;
    locf = arecptr->flags;

    if (locf & 0x40080) {       /* email and note */
      emptr = arecptr->fields;
      for (i = 0; i < 7; i++, locf >>= 1)
        if (locf & 1)
          emptr += StrLen(emptr) + 1;
      locf >>= 1;
      pkptr = emptr;
      pkptr += StrLen(pkptr) + 1;

      for (i = 0; i < 10; i++, locf >>= 1)
        if (locf & 1)
          pkptr += StrLen(pkptr) + 1;
      pkptr = StrStr(pkptr, "-----BEGIN PGP PUBLIC");
    }
    if (pkptr) {
      abhand[nemails] = hand1;
      recnum[nemails] = dbrec;
      abemail[nemails] = emptr;
      pgpk[nemails] = pkptr;
      nemails++;
    } else {
      MemHandleUnlock(hand1);
      DmReleaseRecord(AddrDB, dbrec, 0);
    }

    WinDrawChars("                        ", 24, 0, 32);

    if (nemails == MAXRECS)
      break;
  }

  keylist = FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, pkeyid));
  LstSetListChoices(keylist, abemail, nemails);
  LstSetSelection(keylist, 0);
  CtlSetLabel(FrmGetObjectPtr(renf, FrmGetObjectIndex(renf, tkeyid)), abemail[0]);

  FrmDoDialog(renf);
  FrmDeleteForm(renf);

  i = LstGetSelection(keylist);
  bp = pgpk[i];

  file = FileOpen(0, "temp.pkr", 'OPKR', 'OPGP', TEMPF, NULL);
  ofile = FileOpen(0, "RingTemp", 'DATA', 'OPGP', TEMPF, NULL);
  FileWrite(ofile, bp, 1, StrLen(bp), NULL);
  FileRewind(ofile);
  PGP_dearmor(ofile, file);
  FileClose(ofile);
  FileRewind(file);
  for (i = 0; i < nemails; i++) {
    MemHandleUnlock(abhand[i]);
    DmReleaseRecord(AddrDB, recnum[i], 0);  /* dirty only if signed */
  }
  nemails = 0;
  DmCloseDatabase(AddrDB);
}

void makepkr()
{
  LocalID Addrid;
  VoidHand hand1;
  UInt dbrec;
  char *pkptr;
  ULong locf;
  int i;
  FileHand ofile;
  DmOpenRef AddrDB;

  Addrid = DmFindDatabase(0, "AddressDB");
  AddrDB = DmOpenDatabase(0, Addrid, dmModeReadOnly | dmModeShowSecret);
  if (!AddrDB)
    ErrDisplay("No Addr DB");
  file = FileOpen(0, "pubring.pkr", 'OPKR', 'OPGP', NORMF, NULL);
  WinDrawChars("Building Pubring    ", 20, 0, 20);
  for (dbrec = 1; dbrec < DmNumRecords(AddrDB); dbrec++) {

    if (!(hand1 = DmGetRecord(AddrDB, dbrec))
        || !(arecptr = MemHandleLock(hand1)))
      break;

    WinDrawChars(arecptr->fields, StrLen(arecptr->fields) > 12 ? 12 : StrLen(arecptr->fields), 0, 32);
    locf = arecptr->flags;

    if (locf & 0x40080) {       /* email and note */
      pkptr = arecptr->fields;
      for (i = 0; i < 18; i++, locf >>= 1)
        if (locf & 1)
          pkptr += StrLen(pkptr) + 1;
      pkptr = StrStr(pkptr, "-----BEGIN PGP PUBLIC");
      if (pkptr) {
	ofile = FileOpen(0, "RingTemp", 'DATA', 'OPGP', TEMPF, NULL);
	FileWrite(ofile, pkptr, 1, StrLen(pkptr), NULL);
	FileRewind(ofile);
	PGP_dearmor(ofile, file);
	FileClose(ofile);
      }
    }

    MemHandleUnlock(hand1);
    DmReleaseRecord(AddrDB, dbrec, 0);
    WinDrawChars("                        ", 24, 0, 32);
  }

  FileClose(file);
  DmCloseDatabase(AddrDB);
  WinDrawChars("DONE                    ", 24, 0, 32);
}

int getkey()
{
  unsigned int i;
  unsigned char *buf = NULL, *bp, t;
  unsigned long ll;
  keyid_t dhkid = 0;

  ScanAddrDB();

  dhkid = 0;
  while (!dhkid) {
    if (buf)
      MemPtrFree(buf);
    t = fgetc(file);
    if (!(bp = PGP_gtpkt(file, t, &ll)))
      break;
    buf = bp;
    t = (t & 0x7c) >> 2;

/*** for t=13 (UID), echo first (minimally) to screen */

    if (t == 6 || t == 14) {    /* sec or pub key */
      if (*bp++ != 4)
        bp += 2;                /* old valid days */
      bp += 4;

      switch (*bp++) {
      case 16:
      case 20:
        i = *bp++ * 256, i += *bp++, i = (i + 7) / 8, bp += i;
        i = *bp++ * 256, i += *bp++, i = (i + 7) / 8, bp += i;
        i = *bp++ * 256, i += *bp++, i = (i + 7) / 8, bp += i;
        dhkid = PGP_gkid(buf, bp - buf);
        break;
      case 1:
      case 2:
      case 3:
        i = *bp++ * 256, i += *bp++, i = (i + 7) / 8, bp += i - 8;
        t = 8;
        while (t--)
          dhkid = (dhkid << 8) + *bp++;
        break;
      }
    }
  }
  FileClose(file);
  keys[0] = dhkid;
  return 0;
}

#define HALG 2
int signkey()
{
  unsigned int uf = 0, salg = 17;
  unsigned char *buf = NULL, *bp, t, x[4], sigbuf[768], *outbufp;
  unsigned long ll;
  FileHand ofile;
  void *hctx = NULL, *signkey;
  keyid_t key = 0;
  VoidHand outhand;

  ScanAddrDB();

  /* output file to add signature */
  ofile = FileOpen(0, "temp2.pkr", 'DATA', 'OPGP', TEMPF, NULL);

  for (;;) {
    if (buf)
      MemPtrFree(buf);

    t = fgetc(file);
    if (!(bp = PGP_gtpkt(file, t, &ll)))
      break;

    FileWrite(ofile, &t, 1, 1, NULL);
    x[3] = ll, x[2] = ll >> 8, x[1] = ll >> 16, x[0] = ll >> 24;
    FileWrite(ofile, &x[3 - (t & 3)], 1, 1 + (t & 3), NULL);
    FileWrite(ofile, bp, 1, ll, NULL);
    buf = bp;
    t = (t & 0x7c) >> 2;

    if (!uf && (t == 6 || t == 14)) {  /* pub key */
      uf++;
      hctx = PGP_hini(HALG);
      x[0] = 0x99, x[1] = ll >> 8, x[2] = ll;
      PGP_hblk(hctx, x, 3);
      PGP_hblk(hctx, buf, ll);
    } else if (t == 13 && uf == 1) {  /* user id */
      uf++;
      PGP_hblk(hctx, buf, ll);
      if (0 >= (salg = PGP_gtkey(&signkey, "", &key))) {

        /* clean up !!!!!!!!! */

        return -1;
      }
      ll = PGP_sigmk(signkey, hctx, sigbuf, key, 0x10, HALG, salg, NULL);
      FileWrite(ofile, sigbuf, 1, ll, NULL);
      break;
    }
  }
  FileClose(file);

  FileRewind(ofile);
  FileControl(fileOpDestructiveReadMode, ofile, NULL, NULL);
  file = FileOpen(0, "temp.asc", 'OPKR', 'OPGP', TEMPF, NULL);
  PGP_armor(ofile, file, "PUBLIC KEY BLOCK", NULL);
  FileClose(ofile);

  ll = FileTell(file, NULL, NULL) - 1;
  FileRewind(file);

  if (!(outhand = MemHandleNew(ll)))
    return -1;
  outbufp = MemHandleLock(outhand);

  FileControl(fileOpDestructiveReadMode, file, NULL, NULL);
  FileRead(file, outbufp, 1, ll, NULL);
  FileClose(file);

  ClipboardAddItem(clipboardText, outbufp, ll);
  MemHandleFree(outhand);

  return 0;
}
