#include <System/SysAll.h>
#include <UI/UIAll.h>
#include "stdio2.h"

#define getenv(x) "."

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>
#define memmove memcpy

typedef unsigned char u8_t;
typedef unsigned long u32_t;
typedef unsigned long long keyid_t;
#define ANY_KEY 0ULL
#define NEXT_KEY 0xffffffffffffffffULL

/* armor */
extern const u32_t PGP_crc24t[256];
int PGP_armor(FILE *, FILE *, char *, char *);
int PGP_dearmor(FILE *, FILE *);
void PGP_ctln(char *s);
long PGP_um2b(FILE * ifd, char *ofd);
/* top decrypt/encrypt */
int PGP_encry(FILE *, FILE *, int e, int c, keyid_t k[], int ca, char **pp);
int PGP_decry(FILE * inf, FILE * outf, u8_t * keybuf);
/* public key and symmetric encrypt/decrypt */
int PGP_pkenc(keyid_t, u8_t *, u8_t *, int);
int PGP_pkdec(u8_t *, u8_t *);
void PGP_cenc(FILE * inf, FILE * outf, void *);
int PGP_cdec(FILE * inf, FILE * outf, void *x[], int);
/* (de)compression */
int PGP_unzip(FILE * inf, FILE * outf);
extern int PGP_zlvl;
int PGP_zip(FILE * inf, FILE * outf, int v2flg);
/* top literal and signature */
int PGP_delcs(FILE * inf, FILE * outf, int *, u8_t *);
int PGP_elsgm(FILE *, FILE *, char *n, int s, int t, int h, keyid_t, char *pp);
/* signature */
extern u8_t *PGP_sigk;
int PGP_sigmk(void *, void *, char *, keyid_t, u8_t, u8_t, u8_t, u8_t *);
int PGP_sigck(u8_t * sigp, void *hctx);
/* keyring/keypacket suport */
extern FILE *PGP_pkr, *PGP_skr;
void *PGP_mpiBN(u8_t ** buf);
keyid_t PGP_gkid(u8_t *, int);
FILE *PGP_kring(char *file, int secflg);
int PGP_gtkey(void **, u8_t *, keyid_t *);
int PGP_wrkey(u8_t * buf, void *key, int pri, int alg, u8_t * pp, char *uid);
/* passphrase to cfbsym context */
int PGP_gts2k(u8_t ** bp, u8_t * passph, void **);
int PGP_wrs2k(u8_t *, const u8_t *, void **);
void PGP_khash(u8_t, u32_t, u32_t, u32_t, u8_t *, u8_t *);
/* hashing */
extern const u32_t PGP_hctxsiz[];
extern u8_t PGP_hlen[];
extern const char PGP_hbnr[][24];
void *PGP_hini(int halg);
void PGP_hblk(u8_t * ctx, u8_t *, u32_t);
void PGP_hfin(u8_t * buf, u8_t * ctx);
int PGP_hder(u8_t halg, u8_t *);
/* symcfb support */
int PGP_cksz(int cipher);
void *PGP_cini(u8_t * key, u8_t * iv0, u8_t cip, u8_t enc);
void PGP_cblk(u8_t * buf, u32_t len, void *);
void PGP_cres(u8_t *, void *);
/* packet support */
u32_t PGP_nxpkt(u32_t * neof, FILE * inf);
void *PGP_gtpkt(FILE *, u8_t ctb, u32_t * gazouta);
void PGP_xctb(FILE * inf, FILE * outf);
int PGP_gtblk(u8_t * buf, u32_t get, u32_t * len, u32_t * neof, FILE *);
