#include "libopgp.h"

u32_t PGP_nxpkt(u32_t * neof, FILE * inf)
{
  unsigned int k, ll;

  *neof = 0;
  if ((ll = fgetc(inf)) >= 0xc0) {
    if (ll == 0xff)
      for (k = 0, ll = 0; k < 4; k++)
        ll = (ll << 8) + fgetc(inf);
    else if (ll >= 0xe0)
      ll = 1 << (ll & 31), *neof = 1;
    else
      ll = ((ll & 31) << 8) + 192 + fgetc(inf);
  }
  return ll;
}
