#define IGNORE_STDIO_STUBS

#define SEEK_SET fileOriginBeginning

#include <System/FileStream.h>

typedef void FILE;

#define fread(bufP, objSize, numObj, stream) \
  FileRead((stream), bufP, (objSize), (numObj), NULL)

#define fwrite(dataP, objSize, numObj, stream) \
  FileWrite((stream), (dataP), (objSize), (numObj), NULL)

#define fseek(stream,offset,origin) \
  FileSeek((stream), (offset), (origin))

#define feof(__stream__)    \
 (FileControl(fileOpGetEOFStatus, (__stream__), NULL, NULL) == fileErrEOF)

#define ftell(stream) \
  FileTell((stream), NULL, NULL)

#define fputs(c,fp) FileWrite((fp), (c), 1, strlen(c), NULL)

#define fclose(stream) FileClose(stream)

     /* from stdio2.c */

FILE *fopen(char *, char *);

int fgetc(FILE *);
int fgets(char *, int, FILE *);
int ungetc(int, FILE *);

int fputc(int, FILE *);

/**************** UNTESTED */
#define SEEK_CUR fileOriginCurrent
#define SEEK_END fileOriginEnd

#define clearerr(x) FileClearerr(x)
#define ferror(x) FileError(x)
#define fflush(x) FileFlush(x)
#define ftruncate(x,y) FileTruncate((x),(y))
#define remove(x) FileDelete(0,(x))
#define rewind(x) FileRewind(x)
#define unlink(x) FileDelete(0,(x))

#define rename(x,y) DmSetDatabaseInfo(0,(x),(y),NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)

/*

   tmpfile - fopen with ModeTemporary
   pipe - fopen with write/append/temp/destructive-read

   **************** */

#undef fprintf
#define fprintf(a,b) ErrDisplay(b)

#define exit return

#define time(x) (TimGetSeconds() - 2082844800UL)

#if 0
#define strncmp StrNCompare
#endif
