//
//  GPGKeySelectionPanel.m
//  GPGAppKit
//
//  Created by Simon Stapleton on Thu Feb 21 2002.
//
//  Copyright (C) 2001-2002 Mac GPG Project.
//
//  This code is free software; you can redistribute it and/or modify it under
//  the terms of the GNU General Public License as published by the Free
//  Software Foundation; either version 2 of the License, or any later version.
//
//  This code is distributed in the hope that it will be useful, but WITHOUT ANY
//  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
//  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
//  details.
//
//  For a copy of the GNU General Public License, visit <http://www.gnu.org/> or
//  write to the Free Software Foundation, Inc., 59 Temple Place--Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  More info at <http://macgpg.sourceforge.net/> or <macgpg@rbisland.cx>
//

#import "GPGKeySelectionPanel.h"


@implementation GPGKeySelectionPanel

- (id) initWithContentRect: (NSRect) aRect
                 styleMask: (unsigned int) mask
                   backing: (NSBackingStoreType) backing
                     defer: (BOOL) defer
{
  if (self = [super initWithContentRect: aRect
                              styleMask: mask
                                backing: backing
                                  defer: defer])
  {
    keys = [[NSMutableArray alloc] init];
  }
  return self;
}

- (void) dealloc {
  [keys release];
  [super dealloc];
}

- (void) setMinimumKeyValidity: (GPGValidity) aValidity {
  minimumKeyValidity = aValidity;
}
- (void) setListsSecretKeys: (BOOL) yesNo {
  listsSecretKeys = yesNo;
}
- (void) setListsAllNames: (BOOL) yesNo {
  listsAllNames = yesNo;
}

- (void) beginSheetForKeyWildcard: (NSString *) wildcard
                     usingContext: (GPGContext *) context
                   modalForWindow: (NSWindow *) window
                    modalDelegate: (id) delegate
                   didEndSelector: (SEL) endSelector
                      contextInfo: (id) info
{
  [self resetKeyListForWildcard: wildcard
                   usingContext: context];

  [NSApp beginSheet:self
     modalForWindow:window
      modalDelegate:delegate
     didEndSelector:endSelector
        contextInfo:info];
}



- (BOOL) runModalForKeyWildcard: (NSString *) wildcard
                   usingContext: (GPGContext *) context
{
  [self resetKeyListForWildcard: wildcard
                   usingContext: context];

  [NSApp runModalForWindow:self];

  if (okPressed)
    return NSOKButton;
  else
    return NSCancelButton;
}

//deprecated fucntion, use at own risk
//I needed it, but you should try to not use it.
- (BOOL) runModalForKeyWildcard: (NSString *) wildcard
                   usingContext: (GPGContext *) context
               relativeToWindow: (NSWindow *) window
{
    [self resetKeyListForWildcard: wildcard
                     usingContext: context];
    
    [NSApp runModalForWindow: (NSWindow *)self relativeToWindow: window];

    if (okPressed)
        return NSOKButton;
    else
        return NSCancelButton;
}

- (void) cancel: (id) sender {
  if ([self isSheet]) {
    [NSApp endSheet:self];
  } else {
    [NSApp stopModal];
  }

  okPressed = NO;
  [self orderOut:nil];
}

- (void) ok: (id) sender {
  if ([self isSheet]) {
    [NSApp endSheet:self];
  } else {
    [NSApp stopModal];
  }

  okPressed = YES;
  [self orderOut:nil];
}

- (void) resetKeyListForWildcard: (NSString *) wildcard
                    usingContext: (GPGContext *) context
{
  GPGContext * theContext = context;
  NSString * theWildcard = wildcard;
  NSEnumerator * keyEnumerator;
  id object;

  // Allocate autoreleased context and wildcard if not passed in
  if (!theContext) theContext = [[[GPGContext alloc] init] autorelease];
  if (!theWildcard) theWildcard = @"";

  [keys removeAllObjects];

  keyEnumerator = [theContext keyEnumeratorForSearchPattern:theWildcard
                                             secretKeysOnly:listsSecretKeys];

  while (object = [keyEnumerator nextObject]) {
    if ([object validity] >= minimumKeyValidity) {
      if (listsAllNames) {
        NSEnumerator * nameEnumerator = [[object userIDs] objectEnumerator];
        id name;
        while (name = [nameEnumerator nextObject]) {
          [keys addObject:object];
          [self addObjectToSelectorTitled:name];
        }
      } else {
        [keys addObject:object];
        [self addObjectToSelectorTitled:[object userID]];
      }
    }
  }
}

- (void) addObjectToSelectorTitled:(NSString *)title {
}


- (NSArray *) keys {
  return keys;
}

- (GPGValidity) minimumKeyValidity {
  return minimumKeyValidity;
}

- (BOOL) listsAllNames {
  return listsAllNames;
}

- (BOOL) listsSecretKeys {
  return listsSecretKeys;
}
- (BOOL) okPressed {
  return okPressed;
}
- (void) setOkPressed: (BOOL) yesNo {
  okPressed = yesNo;
}

@end
