//
//  GPGMultiKeySelectionPanel.m
//  GPGAppKit
//
//  Created by Simon Stapleton on Thu Feb 21 2002.
//
//  Copyright (C) 2001-2002 Mac GPG Project.
//
//  This code is free software; you can redistribute it and/or modify it under
//  the terms of the GNU General Public License as published by the Free
//  Software Foundation; either version 2 of the License, or any later version.
//
//  This code is distributed in the hope that it will be useful, but WITHOUT ANY
//  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
//  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
//  details.
//
//  For a copy of the GNU General Public License, visit <http://www.gnu.org/> or
//  write to the Free Software Foundation, Inc., 59 Temple Place--Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  More info at <http://macgpg.sourceforge.net/> or <macgpg@rbisland.cx>
//

#import "GPGKeySelectionPanel.h"
#import "GPGMultiKeySelectionPanel.h"
#import "GPGDummyPanelOwner.h"

static GPGMultiKeySelectionPanel * sharedGPGMultiKeySelectionPanel = nil;

@interface GPGMultiKeySelectionPanel (Private)
- (void)doubleClick:(id)sender;
@end

@implementation GPGMultiKeySelectionPanel

+ (id) panel {
    if (sharedGPGMultiKeySelectionPanel == nil)
        [[GPGDummyPanelOwner alloc] initWithNibNamed:@"GPGMultiKeySelectionPanel"];
    return sharedGPGMultiKeySelectionPanel;
}

- (void)awakeFromNib
{
    sharedGPGMultiKeySelectionPanel = self;
    keyTitles = [[NSMutableArray alloc] init];

    [keySelector setTarget:self];
    [keySelector setDoubleAction:@selector(doubleClick:)];

    [self resetToDefaults];
}

- (void)doubleClick:(id)sender
{
    if ([keySelector numberOfSelectedRows] > 0)
        [self ok:sender];
}

- (void) resetToDefaults {
    [self setListsSecretKeys:NO];
    [self setListsAllNames:YES];
    [self setMinimumKeyValidity:GPGValidityMarginal];
    [self setOkPressed:NO];
    [keySelector deselectAll:nil];
}

- (void) resetKeyListForWildcard: (NSString *) wildcard
                    usingContext: (GPGContext *) context
{
    [keyTitles removeAllObjects];
    [super resetKeyListForWildcard: wildcard
                      usingContext: context];
    [keySelector reloadData];
    [keySelector setNeedsDisplay:YES];
}

- (void) addObjectToSelectorTitled:(NSString*)title {
    [keyTitles addObject:title];
}

- (int)numberOfRowsInTableView: (NSTableView *) aTableView {
    return [keyTitles count];
}
- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex {
    return [keyTitles objectAtIndex:rowIndex];
}

- (NSArray *) selectedKeys {
    if ([self okPressed] && [keySelector numberOfSelectedRows]) {
        NSMutableArray * selectedKeys = [NSMutableArray array];
        NSEnumerator * enumerator = [keySelector selectedRowEnumerator];
        id object;
        while (object = [enumerator nextObject]) {
            [selectedKeys addObject:[[self keys] objectAtIndex:[object intValue]]];
        }
        return selectedKeys;
    }
    else
        return nil;
}

@end
