/*
 * Decompiled with CFR 0.152.
 */
package com.tomsci.Gpg;

import com.tomsci.Gpg.Key;
import com.tomsci.Gpg.KeyRing;
import com.tomsci.Gpg.ShellProc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Gpg {
    public static final int PASS_NEEDED = 1;
    public static final int DETACHED_SIG_FILE = 2;
    public static final int ENCRYPTED = 4;
    public static final int DECRYPT_SUCCEEDED = 8;
    public static final int SIGNED = 16;
    public static final int VERIFY_SUCCEEDED = 32;
    public static final int NO_DATA = 64;
    public static final int NO_PRIVATE_KEY = 128;
    public static final int NO_PUBLIC_KEY = 256;
    public static final int MISSING_ALGORITHM = 512;
    public static final int NO_PASSPHRASE_NEEDED = 1024;
    public static final int ENCRYPTED_CONVENTIONALLY = 2048;
    public static final int CONVENTIONAL_PASS_NEEDED = 4096;
    public static DateFormat GPG_DATE = new SimpleDateFormat("yyyy-MM-dd");
    String gpgPath;
    String gpgHome;
    String gpgHomeDefault = System.getProperty("user.home") + "/.gnupg";
    Key defaultKey;
    Vector encryptTos;
    Boolean hasCommentField;
    int version;
    PrintStream log = System.out;
    private String streamEncType = "utf-8";
    private String gpgEncType = "utf8";
    long pubRingDate;
    long secRingDate;
    public KeyRing kr = new KeyRing();

    public static void main(String[] args) {
        Gpg g = new Gpg();
        g.getGPGHome(null);
        g.getGPG(null);
        g.getPublicKeys();
        g.getPrivateKeys();
        Run run = g.verifyDetachedSigFromData(new byte[]{97, 10}, new File("/Users/tomsci/Desktop/sig.sig"));
        run.continueSigned();
        System.out.println(run.status);
        System.out.println(run.signKey);
    }

    public Gpg(PrintStream p) {
        this.log = p;
    }

    public Gpg() {
    }

    private void checkInited() {
        if (this.gpgHome == null || this.gpgPath == null) {
            throw new RuntimeException("GPG directories not initialised");
        }
    }

    public void getPublicKeys() {
        File f = new File(this.gpgHome + "/pubring.gpg");
        boolean x = f.exists();
        this.pubRingDate = f.lastModified();
        this.getKeys(false);
    }

    public void getPrivateKeys() {
        this.secRingDate = new File(this.gpgHome + "/secring.gpg").lastModified();
        this.getKeys(true);
    }

    /*
     * Unable to fully structure code
     */
    private void getKeys(boolean secret) {
        block19: {
            this.checkInited();
            v = new Vector<String>();
            this.initArgs(v);
            v.add("--list-" + (secret != false ? "secret" : "public") + "-keys");
            v.add("--with-colons");
            if (this.version() >= 1070) {
                v.add("--no-show-photos");
            }
            ss = new String[v.size()];
            v.toArray(ss);
            p = new ShellProc(ss, this.log);
            p.exec();
            r = p.getAllOutput();
            v.remove("--with-colons");
            ss = new String[v.size()];
            v.toArray(ss);
            q = new ShellProc(ss, this.log);
            q.setStreamFormat(this.streamEncType);
            q.exec();
            rr = q.getAllOutput(true);
            do {
                ssize = rr.size();
                rr.remove("");
            } while (ssize > rr.size());
            primaryIsRevoked = false;
            i = r.iterator();
            while (i.hasNext()) {
                s = (String)i.next();
                if (s.startsWith("pub:r:") || s.startsWith("sec:r:")) {
                    primaryIsRevoked = true;
                } else if (s.startsWith("pub:") || s.startsWith("sec:")) {
                    primaryIsRevoked = false;
                }
                if (!s.startsWith("uid:r:") || primaryIsRevoked) continue;
                i.remove();
            }
            if (r.size() != rr.size()) {
                throw new RuntimeException("Unmatched key listing lengths");
            }
            if (r.size() <= 2) break block19;
            i = 0;
            block4: while (true) {
                block20: {
                    block18: {
                        if (i < r.size() && (!((String)r.get(i)).startsWith("pub") && !((String)r.get(i)).startsWith("sec") || ((String)r.get(i)).startsWith("pub:TrustDB: "))) {
                            ++i;
                            continue;
                        }
                        if (i >= r.size() || (pubLine = (String)r.get(i)) == null) break;
                        uids = new Vector<String>();
                        keyIDs = new Vector<String>();
                        trusted = false;
                        revoked = false;
                        expiryDate = null;
                        pubTokens = this.tokenize(pubLine, ":");
                        name = ((String)rr.get(i)).substring(31);
                        trust = (String)pubTokens.get(1);
                        if (trust.equals("r")) {
                            revoked = true;
                        }
                        if (!name.startsWith((aarg = "[") + "image of size")) {
                            hexID = (String)pubTokens.get(4);
                            keyIDs.add(hexID);
                            uids.add(name);
                            if (!secret && (trust.equals("f") || trust.equals("u"))) {
                                trusted = true;
                            }
                        }
                        ex = (String)pubTokens.get(6);
                        expired = false;
                        try {
                            creationDate = Gpg.GPG_DATE.parse((String)pubTokens.get(5));
                            if (ex.length() > 0 && !(expiryDate = Gpg.GPG_DATE.parse(ex)).after(new Date())) {
                                expired = true;
                            }
                        }
                        catch (ParseException e) {
                            e.printStackTrace(this.log);
                            return;
                        }
                        while (++i < r.size() && (uidTokens = this.tokenize((String)r.get(i), ":")).get(0).equals("uid")) {
                            n = ((String)rr.get(i)).substring(31);
                            if (((String)uidTokens.get(9)).startsWith(aarg + "image of size") || revoked) continue;
                            uids.add(n);
                        }
                        break block18;
lbl87:
                        // 1 sources

                        while ((subTokens = this.tokenize((String)r.get(i), ":")).get(0).equals("sub") || subTokens.get(0).equals("ssb")) {
                            keyIDs.add((String)subTokens.get(4));
                            ++i;
                            break block18;
                        }
                        break block20;
                    }
                    if (i < r.size()) ** GOTO lbl87
                }
                ii = uids.iterator();
                while (true) {
                    if (ii.hasNext()) ** break;
                    continue block4;
                    k = new Key((String)ii.next(), keyIDs, expiryDate, creationDate, trusted, secret, revoked);
                    this.kr.addKey(k);
                }
                break;
            }
        }
    }

    public void updateKeyInfo() {
        this.checkInited();
        if (new File(this.gpgHome + "/pubring.gpg").lastModified() > this.pubRingDate || new File(this.gpgHome + "/secring.gpg").lastModified() > this.secRingDate) {
            this.kr.clear();
            this.getPublicKeys();
            this.getPrivateKeys();
        }
    }

    public String getGPG(String current) {
        String[] paths = new String[]{"/usr/local/bin/gpg", "/sw/usr/bin/gpg", "/sw/bin/gpg"};
        String toTest = current == null || !current.endsWith("gpg") ? paths[0] : current;
        File gpg = new File(toTest);
        if (!gpg.exists()) {
            int i = 0;
            while (i < paths.length) {
                toTest = paths[i];
                gpg = new File(toTest);
                if (gpg.exists()) break;
                ++i;
            }
        }
        if (gpg.exists()) {
            this.gpgPath = toTest;
            return this.gpgPath;
        }
        return null;
    }

    public String getGPGHome(String h) {
        String toTest = h != null ? h : this.gpgHomeDefault;
        File f = new File(toTest + "/pubring.gpg");
        File g = new File(toTest + "/options");
        if (!f.exists() && !g.exists()) {
            toTest = this.gpgHomeDefault;
            f = new File(toTest + "/pubring.gpg");
            g = new File(toTest + "/options");
        }
        if (f.exists() || g.exists()) {
            this.gpgHome = toTest;
            return this.gpgHome;
        }
        return null;
    }

    public Run signBinaryData(byte[] src, Key signKey, String passphrase) {
        return this.encode(src, "byte[]", null, signKey, passphrase, null);
    }

    public Run encode(String src, Vector recipients, Key signKey, String passphrase) {
        return this.encode(src, "String", recipients, signKey, passphrase, null);
    }

    public Run encode(File src, File dest, Vector recipients, Key signKey, String passphrase) {
        return this.encode(src, dest, recipients, signKey, passphrase, null);
    }

    public Run encodeConventional(String src, String encodePassphrase, Key signKey, String signPassphrase) {
        return this.encode(src, "String", null, signKey, signPassphrase, encodePassphrase);
    }

    public Run encodeConventional(File src, File dest, String encryptPassphrase, Key signKey, String passphrase) {
        return this.encode(src, dest, null, signKey, passphrase, encryptPassphrase);
    }

    Run encode(Object src, Object dest, Vector recipients, Key signKey, String passphrase, String conventionalPass) {
        ShellProc p;
        this.checkInited();
        Run run = new Run();
        if (recipients != null && conventionalPass != null) {
            throw new IllegalStateException("Cannot encrypt with public key and symmetric cipher at once");
        }
        if (conventionalPass != null && conventionalPass.equals("")) {
            throw new IllegalStateException("Cannot use a blank password for symmetric encrypt");
        }
        run.setInputAndSrc(src);
        if (dest instanceof File) {
            run.setDest((File)dest);
        } else {
            run.setDest((String)dest);
        }
        run.signKey = signKey;
        run.recipients = recipients;
        Vector<String> v = new Vector<String>();
        this.initArgs(v);
        v.add("--always-trust");
        v.add("--command-fd");
        v.add("0");
        v.add("--status-fd");
        v.add("2");
        v.add("--no-tty");
        if (run.isDestString) {
            v.add("--armor");
            if (!this.hasCommentField()) {
                v.add("--comment");
                v.add("Generated by Gpg Tools - http://www.tomsci.com/gpgtools");
            }
        }
        if (run.isDestFile) {
            v.add("--output");
            v.add(((File)dest).getAbsolutePath());
        }
        if (signKey != null) {
            v.add("--default-key");
            v.add("=" + signKey);
        }
        if (recipients == null && conventionalPass == null && run.isDestString) {
            v.add("--clearsign");
        } else if (recipients == null && conventionalPass == null && run.isDestBytes) {
            v.add("--detach-sign");
        } else if (recipients == null && conventionalPass == null && run.isDestFile) {
            v.add("--detach-sign");
        } else if (recipients != null) {
            v.add("--no-encrypt-to");
            Iterator i = ((AbstractList)recipients).iterator();
            while (i.hasNext()) {
                v.add("--recipient");
                v.add("=" + i.next());
            }
            v.add("--encrypt");
            if (signKey != null) {
                v.add("--sign");
            }
        } else {
            v.add("--symmetric");
            if (signKey != null) {
                v.add("--sign");
            }
        }
        if (run.isSrcFile) {
            v.add(((File)src).getAbsolutePath());
        }
        String[] ss = new String[v.size()];
        v.toArray(ss);
        run.p = p = new ShellProc(ss, this.log);
        p.exec();
        String r = this.readLine(p);
        if (r.startsWith("[GNUPG:] USERID_HINT")) {
            this.readLine(p);
            this.readLine(p);
            p.writeLine(passphrase);
            this.readLine(p);
            r = this.readLine(p);
            if (r.startsWith("[GNUPG:] BAD_PASSPHRASE") || r.startsWith("[GNUPG:] MISSING_PASSPHRASE")) {
                run.addFlag(1);
                p.destroy();
                return run;
            }
        }
        if (conventionalPass != null && signKey != null && !(r = this.readLine(p)).startsWith("[GNUPG:] NEED_PASSPHRASE_SYM")) {
            this.log.println("Expected NEED_PASSPHRASE_SYM");
        }
        if (r.startsWith("[GNUPG:] NEED_PASSPHRASE_SYM")) {
            this.readLine(p);
            p.writeLine(conventionalPass);
            this.readLine(p);
            r = this.readLine(p);
            run.addFlag(2048);
        }
        if (r == null || !r.startsWith("[GNUPG:] GOOD_PASSPHRASE") && !r.startsWith("[GNUPG:] BEGIN_ENCRYPTION")) {
            this.log.println("Expected something - not " + r);
            p.destroy();
            return run;
        }
        if (r.startsWith("[GNUPG:] BEGIN_ENCRYPTION") && recipients != null) {
            run.addFlag(4);
        }
        if (!run.isSrcFile) {
            if (run.isSrcString) {
                p.writeLine((String)src);
            } else {
                p.writeBinary((byte[])src);
            }
            p.writeEOF();
        }
        if (signKey != null) {
            if (!this.readLine(p).startsWith("[GNUPG:] SIG_CREATED")) {
                this.log.println("Expected SIG_CREATED");
                p.destroy();
                return run;
            }
            run.addFlag(16);
            if (recipients != null) {
                if (!this.readLine(p).startsWith("[GNUPG:] BEGIN_ENCRYPTION")) {
                    this.log.println("Expected BEGIN_ENCRYPTION");
                    p.destroy();
                    return run;
                }
                run.addFlag(4);
            }
        }
        if (run.isDestString) {
            String endAt = run.status == 16 ? "-----END PGP SIGNATURE-----" : "-----END PGP MESSAGE-----";
            do {
                r = p.readWithoutLogging();
                run.addLineToOutput(r + (r.equals(endAt) ? ShellProc.newLine : ""));
            } while (!r.equals(endAt));
        } else if (run.isDestBytes) {
            run.setOutput(p.getAllDataOutput());
        }
        return run;
    }

    private Vector tokenize(String raw, String separatorChar) {
        Vector<String> tokens = new Vector<String>();
        StringTokenizer z = new StringTokenizer(raw, separatorChar, true);
        while (z.hasMoreTokens()) {
            String t = z.nextToken();
            if (t.equals(separatorChar)) {
                tokens.add("");
                continue;
            }
            tokens.add(t);
            if (!z.hasMoreTokens()) continue;
            z.nextToken();
        }
        return tokens;
    }

    public Run verifyDetachedSigFromData(byte[] theData, File theSig) {
        ShellProc p;
        this.checkInited();
        Run run = new Run();
        run.setInputAndSrc(theData);
        run.detachedSigLoc = theSig.getAbsolutePath();
        Vector<String> v = new Vector<String>();
        this.initArgs(v);
        v.add("--command-fd");
        v.add("0");
        v.add("--status-fd");
        v.add("2");
        v.add("--no-tty");
        v.add("--verify");
        v.add(theSig.getAbsolutePath());
        v.add("-");
        String[] ss = new String[v.size()];
        v.toArray(ss);
        run.p = p = new ShellProc(ss, this.log);
        p.exec();
        p.writeBinary(theData);
        p.writeEOF();
        this.interpretDecode(run, false);
        run.continueSigned();
        return run;
    }

    public Run decode(Object src, Object dest) {
        Run temp = this.decode(src, dest, true, null);
        return this.decode(src, dest, false, temp.recipients);
    }

    Run decode(Object src, Object dest, boolean listOnly, Vector recipients) {
        ShellProc p;
        this.checkInited();
        Run run = new Run();
        run.recipients = recipients;
        run.setInputAndSrc(src);
        if (dest instanceof File) {
            run.setDest((File)dest);
        } else {
            run.setDest((String)dest);
        }
        Vector<String> v = new Vector<String>();
        this.initArgs(v);
        v.add("--command-fd");
        v.add("0");
        v.add("--status-fd");
        v.add("2");
        v.add("--no-tty");
        if (listOnly) {
            v.add("--list-only");
        } else if (run.isDestFile) {
            v.add("--output");
            v.add(((File)dest).getAbsolutePath());
        }
        v.add("--decrypt");
        if (run.isSrcFile) {
            v.add(((File)src).getAbsolutePath());
        }
        String[] ss = new String[v.size()];
        v.toArray(ss);
        run.p = p = new ShellProc(ss, this.log);
        p.exec();
        if (!run.isSrcFile) {
            boolean hasStart = false;
            boolean hasEnd = false;
            boolean isSig = false;
            String s = (String)src;
            if (s.indexOf("-----BEGIN PGP MESSAGE-----") != -1) {
                hasStart = true;
            }
            if (s.indexOf("-----BEGIN PGP SIGNED MESSAGE-----") != -1) {
                isSig = true;
                hasStart = true;
            }
            if (s.indexOf("-----END PGP MESSAGE-----") != -1 || s.indexOf("-----END PGP SIGNATURE-----") != -1) {
                hasEnd = true;
            }
            p.writeLine(s);
            if (isSig) {
                p.writeEOF();
            }
            if (!(hasStart & hasEnd)) {
                run.addFlag(64);
                p.destroy();
                return run;
            }
        }
        return this.interpretDecode(run, listOnly);
    }

    private Run interpretDecode(Run run, boolean listOnly) {
        Vector tokens;
        ShellProc p = run.p;
        String l = this.readLine(p);
        Vector vector = tokens = l == null ? null : this.tokenize(l, " ");
        if (l == null) {
            run.addFlag(64);
            return run;
        }
        if (l.equals("[GNUPG:] GET_LINE detached_signature.filename")) {
            run.addFlag(2);
            return run;
        }
        if (l.startsWith("[GNUPG:] NEED_PASSPHRASE_SYM")) {
            this.readLine(p);
            run.addFlag(6144);
            if (listOnly) {
                p.destroy();
            }
            return run;
        }
        if (tokens.get(1).equals("NODATA")) {
            p.destroy();
            run.addFlag(64);
            return run;
        }
        if (tokens.get(1).equals("SIG_ID") || tokens.get(1).equals("ERRSIG") || tokens.get(1).equals("BADSIG")) {
            p.rewindLine();
            run.addFlag(16);
            return run;
        }
        if (tokens.get(1).equals("ENC_TO")) {
            run.addFlag(4);
            Vector<Key> encto = new Vector<Key>();
            while (tokens.get(1).equals("ENC_TO")) {
                Key name = this.kr.get(tokens.get(2));
                if (name != null) {
                    encto.add(name);
                } else {
                    encto.add(new Key((String)tokens.get(2)));
                }
                l = p.readLine();
                while (l != null && !l.startsWith("[GNUPG:]") && !l.equals("gpg: public key decryption failed: unknown cipher algorithm")) {
                    l = p.readLine();
                }
                if (l == null) break;
                if (l.equals("gpg: public key decryption failed: unknown cipher algorithm")) {
                    p.destroy();
                    run.addFlag(512);
                    if (listOnly) {
                        run.recipients = encto;
                    }
                    return run;
                }
                tokens = this.tokenize(l, " ");
            }
            if (listOnly) {
                run.recipients = encto;
            }
        }
        if (listOnly) {
            p.destroy();
            return run;
        }
        if (l.startsWith("[GNUPG:] USERID_HINT")) {
            run.signKey = this.kr.get(this.tokenize(this.readLine(p), " ").get(2));
            this.readLine(p);
        } else if (l.startsWith("[GNUPG:] GOOD_PASSPHRASE")) {
            run.addFlag(1024);
        } else {
            p.destroy();
            run.addFlag(128);
        }
        return run;
    }

    String readLine(ShellProc p) {
        return p.readLine("[GNUPG:]");
    }

    public int version() {
        this.checkInited();
        if (this.version != 0) {
            return this.version;
        }
        Vector<String> v = new Vector<String>();
        this.initArgs(v);
        v.add("--version");
        String[] ss = new String[v.size()];
        v.toArray(ss);
        ShellProc p = new ShellProc(ss, this.log);
        p.exec();
        Vector res = p.getAllOutput();
        String vString = (String)res.get(0);
        if (vString == null || vString.length() < 13) {
            this.version = -1;
        } else {
            try {
                this.version = 1000 * Integer.parseInt(vString.substring(12, 13));
                this.version += 100 * Integer.parseInt(vString.substring(14, 15));
                if (vString.length() > 16) {
                    if (vString.charAt(15) == 'r') {
                        this.version += Integer.parseInt(vString.substring(16, 17));
                    } else {
                        this.version += 10 * Integer.parseInt(vString.substring(16, 17));
                        if (vString.length() > 18) {
                            this.version += Integer.parseInt(vString.substring(18, 19));
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.println("GPG version could not be parsed.");
                this.version = -1;
            }
        }
        return this.version;
    }

    private void initArgs(Vector v) {
        v.add(this.gpgPath);
        if (this.gpgHome != null && !this.gpgHome.equals(this.gpgHomeDefault)) {
            v.add("--homedir");
            v.add(this.gpgHome);
        }
        if (this.gpgEncType != null) {
            v.add("--charset");
            v.add(this.gpgEncType);
        }
    }

    public Key getDefaultKey() {
        if (this.defaultKey != null) {
            return this.defaultKey;
        }
        this.checkInited();
        String d = this.getOptionsLine("default-key");
        if (d == null) {
            return null;
        }
        String t = d.substring(11).trim();
        this.defaultKey = this.kr.get(t);
        return this.defaultKey;
    }

    public Vector getEncryptTos() {
        if (this.encryptTos != null) {
            return this.encryptTos;
        }
        this.checkInited();
        Vector v = this.getOptionsLines("encrypt-to", true);
        if (v == null || v.size() == 0) {
            return null;
        }
        Vector<Key> result = new Vector<Key>();
        Iterator i = ((AbstractList)v).iterator();
        while (i.hasNext()) {
            Key k = this.kr.get(((String)i.next()).substring(10).trim());
            if (k == null) continue;
            result.add(k);
        }
        return result;
    }

    public boolean hasCommentField() {
        if (this.hasCommentField == null) {
            this.hasCommentField = this.getOptionsLine("comment") == null ? new Boolean(false) : new Boolean(true);
        }
        return this.hasCommentField;
    }

    String getOptionsLine(String l) {
        Vector v = this.getOptionsLines(l, false);
        if (v != null && v.size() > 0) {
            return (String)v.get(0);
        }
        return null;
    }

    Vector getOptionsLines(String line, boolean multiline) {
        this.checkInited();
        Vector<String> v = new Vector<String>();
        File options = new File(this.gpgHome + "/options");
        try {
            BufferedReader b = new BufferedReader(new FileReader(options));
            while (true) {
                String s;
                if ((s = b.readLine()) == null) {
                    b.close();
                    return v;
                }
                if (!(s = s.trim()).startsWith(line)) continue;
                v.add(s);
                if (!multiline) break;
            }
            b.close();
            return v;
        }
        catch (IOException e) {
            return null;
        }
    }

    public class Run {
        int status;
        public ShellProc p;
        String detachedSigLoc;
        Vector recipients;
        boolean isSrcFile;
        boolean isSrcBytes;
        boolean isSrcString;
        boolean isDestFile;
        boolean isDestBytes;
        boolean isDestString;
        private Object src;
        private Object dest;
        Key signKey;
        Date signDate;
        boolean runNeedsRestarting = false;

        void addFlag(int x) {
            this.status |= x;
        }

        void clearFlag(int x) {
            this.status &= ~x;
        }

        public boolean getFlag(int flag) {
            return (this.status & flag) > 0;
        }

        public byte[] getResultData() {
            return (byte[])this.dest;
        }

        public String getResultString() {
            return (String)this.dest;
        }

        public Vector getRecipients() {
            return this.recipients;
        }

        public Key getSignKey() {
            return this.signKey;
        }

        public Date getSignDate() {
            return this.signDate;
        }

        public void terminateRun() {
            this.p.destroy();
        }

        public void setInputAndSrc(Object src) {
            if (src instanceof File) {
                this.isSrcFile = true;
            } else if (src instanceof String) {
                this.isSrcString = true;
            } else if (src instanceof byte[]) {
                this.isSrcBytes = true;
            } else {
                throw new IllegalArgumentException("Gpg.Run can only use Files, Strings and byte arrays as its input");
            }
            this.src = src;
        }

        void setDest(File f) {
            this.dest = f;
            this.isDestFile = true;
            this.isDestBytes = false;
            this.isDestString = false;
        }

        void setDest(String s) {
            if (s.equals("String")) {
                this.isDestString = true;
                this.isDestFile = false;
                this.isDestBytes = false;
            } else if (s.equals("byte[]")) {
                this.isDestBytes = true;
                this.isDestFile = false;
                this.isDestString = false;
            } else if (!s.equals("null")) {
                throw new IllegalArgumentException("Unknown return type requested: " + s);
            }
        }

        void setOutput(byte[] bs) {
            this.dest = bs;
        }

        void setOutput(String s) {
            this.dest = s;
        }

        void addLineToOutput(String s) {
            this.dest = this.dest == null ? s : this.dest + ShellProc.newLine + s;
        }

        public void continueDetachedSig(String f) {
            this.detachedSigLoc = f;
            if ((this.status & 2) == 0) {
                throw new IllegalStateException("Can't continue here if we're not using a datached signature");
            }
            this.p.writeLine(f);
            Gpg.this.readLine(this.p);
            this.clearFlag(2);
            Gpg.this.interpretDecode(this, false);
        }

        public void continueDecrypt(String pass) {
            if (this.runNeedsRestarting) {
                this.restartRunForDecrypt();
            }
            String s = "";
            if (pass == null & (this.status & 0x400) == 0) {
                throw new IllegalArgumentException("Cannot supply a blank passphrase when gpg requested one.");
            }
            if (pass != null & (this.status & 0x400) > 0) {
                throw new IllegalArgumentException("No passphrase was required (and you called continueDecrypt with one).");
            }
            if (pass != null) {
                this.p.writeLine(pass);
                this.clearFlag(1);
                while (!this.p.readLine().equals("[GNUPG:] GOT_IT")) {
                }
                s = Gpg.this.readLine(this.p);
            }
            if (s.startsWith("[GNUPG:] BAD_PASSPHRASE")) {
                while (!Gpg.this.readLine(this.p).equals("[GNUPG:] GET_HIDDEN passphrase.enter")) {
                }
                this.addFlag(1);
                this.p.destroy();
                this.runNeedsRestarting = true;
                return;
            }
            if ((this.status & 0x400) > 0 || s.startsWith("[GNUPG:] GOOD_PASSPHRASE")) {
                while (!Gpg.this.readLine(this.p).startsWith("[GNUPG:] BEGIN_DECRYPTION")) {
                }
                if (!this.isDestFile) {
                    this.p.writeEOF();
                    byte[] bs = this.p.getAllDataOutput();
                    if (this.isDestBytes) {
                        this.setOutput(bs);
                    } else if (this.isDestString) {
                        try {
                            this.setOutput(new String(bs, "utf-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException("Since when has java not recognised utf-8?");
                        }
                    }
                }
                if ((s = Gpg.this.readLine(this.p)) != null) {
                    if (s.equals("[GNUPG:] DECRYPTION_OKAY")) {
                        this.addFlag(8);
                        this.p.destroy();
                    } else if (s.startsWith("[GNUPG:] SIG_ID") || s.startsWith("[GNUPG:] ERRSIG") || s.startsWith("[GNUPG:] BADSIG")) {
                        this.p.rewindLine();
                        this.addFlag(16);
                        this.continueSigned();
                    }
                }
            }
        }

        public void continueSigned() {
            long l;
            Vector tokens;
            String s = Gpg.this.readLine(this.p);
            if (s.startsWith("[GNUPG:] SIG_ID ")) {
                tokens = Gpg.this.tokenize(s, " ");
                l = 0L;
                try {
                    l = Long.parseLong((String)tokens.get(4));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.signDate = new Date(l * 1000L);
                s = Gpg.this.readLine(this.p);
                tokens = Gpg.this.tokenize(s, " ");
                if (s.startsWith("[GNUPG:] GOODSIG")) {
                    this.signKey = Gpg.this.kr.get(tokens.get(2));
                    s = Gpg.this.readLine(this.p);
                    if (s.startsWith("[GNUPG:] VALIDSIG")) {
                        this.addFlag(32);
                    }
                } else if (s.startsWith("[GNUPG:] BADSIG")) {
                    this.signKey = Gpg.this.kr.get(tokens.get(2));
                }
            } else if (s.startsWith("[GNUPG:] BADSIG")) {
                this.signKey = Gpg.this.kr.get(Gpg.this.tokenize(s, " ").get(2));
            } else {
                tokens = Gpg.this.tokenize(s, " ");
                l = 0L;
                try {
                    l = Long.parseLong((String)tokens.get(4));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.signDate = new Date(l * 1000L);
                this.signKey = new Key((String)tokens.get(2));
                this.addFlag(256);
            }
            while (s != null && !s.startsWith("[GNUPG:] DECRYPTION_OKAY")) {
                s = Gpg.this.readLine(this.p);
            }
            if (s != null && s.startsWith("[GNUPG:] DECRYPTION_OKAY")) {
                this.addFlag(8);
            }
            this.p.destroy();
        }

        void restartRunForDecrypt() {
            Run newRun = Gpg.this.decode(this.src, this.dest, false, this.recipients);
            if ((newRun.status & 2) > 0) {
                newRun.continueDetachedSig(this.detachedSigLoc);
            }
            this.p = newRun.p;
            this.status = newRun.status;
            this.runNeedsRestarting = false;
        }

        public void continueConventionalDecrypt(String pass) {
            if (this.runNeedsRestarting) {
                this.restartRunForDecrypt();
            }
            String s = "";
            this.p.writeLine(pass);
            this.clearFlag(4096);
            while (!this.p.readLine().equals("[GNUPG:] GOT_IT")) {
            }
            while (!Gpg.this.readLine(this.p).startsWith("[GNUPG:] BEGIN_DECRYPTION")) {
            }
            if (!this.isDestFile) {
                this.p.writeEOF();
                byte[] bs = this.p.getAllDataOutput();
                if (this.isDestBytes) {
                    this.setOutput(bs);
                } else if (this.isDestString) {
                    try {
                        this.setOutput(new String(bs, "utf-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Since when has java not recognised utf-8?");
                    }
                }
            }
            if ((s = Gpg.this.readLine(this.p)) != null) {
                if (s.equals("[GNUPG:] DECRYPTION_FAILED")) {
                    this.addFlag(4096);
                    this.p.destroy();
                    this.runNeedsRestarting = true;
                } else if (s.equals("[GNUPG:] DECRYPTION_OKAY")) {
                    this.addFlag(8);
                    this.p.destroy();
                } else if (s.startsWith("[GNUPG:] SIG_ID") || s.startsWith("[GNUPG:] ERRSIG") || s.startsWith("[GNUPG:] BADSIG")) {
                    this.p.rewindLine();
                    this.addFlag(16);
                    this.continueSigned();
                }
            }
        }
    }
}

