/*
 * Decompiled with CFR 0.152.
 */
package com.tomsci.Gpg;

import com.apple.cocoa.application.NSAlertPanel;
import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.application.NSButton;
import com.apple.cocoa.application.NSEvent;
import com.apple.cocoa.application.NSMenu;
import com.apple.cocoa.application.NSMenuItem;
import com.apple.cocoa.application.NSOpenPanel;
import com.apple.cocoa.application.NSPasteboard;
import com.apple.cocoa.application.NSPopUpButton;
import com.apple.cocoa.application.NSResponder;
import com.apple.cocoa.application.NSSecureTextField;
import com.apple.cocoa.application.NSTableColumn;
import com.apple.cocoa.application.NSTableView;
import com.apple.cocoa.application.NSTextField;
import com.apple.cocoa.application.NSTextView;
import com.apple.cocoa.application.NSView;
import com.apple.cocoa.application.NSWindow;
import com.apple.cocoa.application.NSWorkspace;
import com.apple.cocoa.application._NSObsoleteMenuItemProtocol;
import com.apple.cocoa.foundation.NSArray;
import com.apple.cocoa.foundation.NSBundle;
import com.apple.cocoa.foundation.NSDictionary;
import com.apple.cocoa.foundation.NSEnumerator;
import com.apple.cocoa.foundation.NSNotification;
import com.apple.cocoa.foundation.NSPathUtilities;
import com.apple.cocoa.foundation.NSSelector;
import com.apple.cocoa.foundation.NSUserDefaults;
import com.tomsci.Gpg.Gpg;
import com.tomsci.Gpg.Key;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class GpgController
extends NSResponder {
    NSButton recipientsOK;
    NSButton useClipboard;
    NSButton useClipboardBig;
    NSButton creationDatesButton;
    NSButton keyIDsButton;
    NSButton conventionalEncryptButton;
    NSButton mainDecryptButton;
    NSMenu fileMenu;
    NSPasteboard servicesBoard;
    NSPopUpButton signingPassPhraseKey;
    NSSecureTextField decryptPassPhrase;
    NSSecureTextField signingPassPhrase;
    NSTextField decryptPassPhraseKey;
    NSSecureTextField conventionalPass;
    NSSecureTextField conventionalConfirm;
    NSSecureTextField conventionalDecrypt;
    NSTextView serviceResult;
    NSTableColumn creationDateCol;
    NSTableColumn keyIDCol;
    NSTableView decryptT;
    NSTableView decryptFailedT;
    NSTableView usersT;
    NSTableView recipientsT;
    NSUserDefaults nsud;
    NSView openDialogExtraPanel;
    NSWindow conventionalEncW;
    NSWindow conventionalDecW;
    NSWindow decryptW;
    NSWindow decryptFailedW;
    NSWindow mainW;
    NSWindow recipientsW;
    NSWindow signingW;
    NSWindow serviceW;
    static final int ENCRYPT = 4;
    static final int SIGN = 16;
    static final int CONVENTIONAL = 2048;
    Vector users = new Vector();
    Vector recipients = new Vector();
    Gpg g;
    int what = 0;
    boolean showUntrusted = false;
    boolean showKeyID = false;
    boolean showCreationDate = false;
    String inFile;
    String outFile;
    Gpg.Run globalTempRun;
    String conventionalPassTemp;
    PrintStream log = System.out;
    boolean success = false;
    final URL homePageURL;
    final URL emailURL;
    final URL versionURL;
    static /* synthetic */ Class class$com$apple$cocoa$application$NSTableView;

    public GpgController() {
        try {
            this.homePageURL = new URL("http://www.tomsci.com/gpgtools/");
            this.emailURL = new URL("mailto:gpgtools@tomsci.com");
            this.versionURL = new URL("http://www.tomsci.com/gpgtools/version.txt");
        }
        catch (MalformedURLException e) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applicationWillFinishLaunching(NSNotification aNotification) {
        String gHomePath;
        String gPath;
        String home = System.getProperty("user.home");
        File logs = new File(home + "/Library/Logs/");
        if (!logs.exists()) {
            logs.mkdirs();
        }
        try {
            FileOutputStream out = new FileOutputStream(logs.getAbsolutePath() + "/Gpg Tools log.txt", false);
            this.log = new PrintStream(out, true);
        }
        catch (IOException e) {
            this.p("An error occurred opening the log file: " + e);
        }
        NSDictionary b = NSBundle.mainBundle().infoDictionary();
        this.log.println(b.objectForKey((Object)"CFBundleName") + " " + b.objectForKey((Object)"CFBundleShortVersionString"));
        this.nsud = NSUserDefaults.standardUserDefaults();
        this.g = new Gpg(this.log);
        NSUserDefaults nSUserDefaults = this.nsud;
        synchronized (nSUserDefaults) {
            gPath = this.g.getGPG(this.nsud.stringForKey("gpgPath"));
        }
        while (gPath == null) {
            int res = NSAlertPanel.runAlert((String)"Cannot locate GPG.", (String)"Mac GPG does not appear to be installed. This is required for Gpg Tools to function. Version 1.0.6 or greater is needed, which may be downloaded from <http://macgpg.sourceforge.net/>.\n\nIf you have installed gpg in a non-standard place click 'Find GPG...' to locate it.", (String)"Quit", (String)"Find GPG...", null);
            if (res == 1) {
                NSApplication.sharedApplication().terminate((Object)this);
                continue;
            }
            NSOpenPanel o = NSOpenPanel.openPanel();
            o.setTitle("Please locate the gpg executable");
            int r = o.runModalInDirectory("/", null, (NSArray)null);
            if (r != 1) continue;
            gPath = this.g.getGPG(o.filename());
        }
        NSUserDefaults nSUserDefaults2 = this.nsud;
        synchronized (nSUserDefaults2) {
            if (!gPath.equals(this.nsud.stringForKey("gpgPath"))) {
                this.nsud.setObjectForKey((Object)gPath, "gpgPath");
            }
            gHomePath = this.g.getGPGHome(this.nsud.stringForKey("gpgHomePath"));
        }
        while (gHomePath == null) {
            int res = NSAlertPanel.runAlert((String)"Cannot locate GPG's configuration settings.", (String)"Mac GPG may not have been set up for this user. See the Mac GPG documentation for information on how to do this.\n\nIf you have moved your settings from their default place in '~/.gnupg' click 'Find GPG settings...' to locate them.", (String)"Quit", (String)"Find GPG settings...", null);
            if (res == 1) {
                NSApplication.sharedApplication().terminate((Object)this);
                continue;
            }
            NSOpenPanel o = NSOpenPanel.openPanel();
            o.setTitle("Please locate the gpg settings folder.");
            o.setCanChooseFiles(false);
            o.setCanChooseDirectories(true);
            int r = o.runModalInDirectory("/", null, (NSArray)null);
            if (r != 1) continue;
            gHomePath = this.g.getGPGHome(o.filename());
        }
        NSUserDefaults nSUserDefaults3 = this.nsud;
        synchronized (nSUserDefaults3) {
            if (!gHomePath.equals(this.nsud.stringForKey("gpgHomePath"))) {
                this.nsud.setObjectForKey((Object)gHomePath, "gpgHomePath");
            }
            this.showKeyID = this.nsud.booleanForKey("showKeyID");
            this.showCreationDate = this.nsud.booleanForKey("showCreationDate");
        }
        this.g.version();
        this.log.println("");
        this.g.getPublicKeys();
        this.g.getPrivateKeys();
        this.fileMenu.setAutoenablesItems(true);
        NSSelector recipientsAction = new NSSelector("removeRecipient", new Class[]{class$com$apple$cocoa$application$NSTableView == null ? (class$com$apple$cocoa$application$NSTableView = GpgController.class$("com.apple.cocoa.application.NSTableView")) : class$com$apple$cocoa$application$NSTableView});
        NSSelector usersAction = new NSSelector("addRecipient", new Class[]{class$com$apple$cocoa$application$NSTableView == null ? (class$com$apple$cocoa$application$NSTableView = GpgController.class$("com.apple.cocoa.application.NSTableView")) : class$com$apple$cocoa$application$NSTableView});
        this.recipientsT.setDoubleAction(recipientsAction);
        this.usersT.setDoubleAction(usersAction);
        this.setNextResponder(this.usersT.nextResponder());
        this.usersT.setNextResponder((NSResponder)this);
    }

    public void applicationDidFinishLaunching(NSNotification aNotification) {
        NSApplication.sharedApplication().setServicesProvider((Object)this);
    }

    public int numberOfRowsInTableView(NSTableView x) {
        if (x.columnWithIdentifier((Object)"users") >= 0) {
            return this.users.size();
        }
        return this.recipients.size();
    }

    public Object tableViewObjectValueForLocation(NSTableView t, NSTableColumn c, int i) {
        String z = (String)c.identifier();
        if (z.equals("trustU")) {
            return ((Key)this.users.get(i)).isTrusted() ? "" : "\u2022";
        }
        if (z.equals("trustR")) {
            return ((Key)this.recipients.get(i)).isTrusted() ? "" : "\u2022";
        }
        if (z.equals("keyID")) {
            if (t == this.usersT) {
                return ((Key)this.users.get(i)).keyIDs().get(0).toString().substring(8);
            }
            return ((Key)this.recipients.get(i)).keyIDs().get(0).toString().substring(8);
        }
        if (z.equals("creationDate")) {
            if (t == this.usersT) {
                return Gpg.GPG_DATE.format(((Key)this.users.get(i)).creationDate());
            }
            return Gpg.GPG_DATE.format(((Key)this.recipients.get(i)).creationDate());
        }
        if (t == this.usersT) {
            Key k = (Key)this.users.get(i);
            return k.name();
        }
        Key k = (Key)this.recipients.get(i);
        return k.name();
    }

    public void startEncrypt(Object sender) {
        String t;
        this.g.updateKeyInfo();
        String w = sender instanceof NSMenuItem ? ((NSMenuItem)sender).title() : ((NSButton)sender).title();
        if (w.equals("Encrypt...") | w.equals("Encrypt")) {
            this.what = 4;
            t = "encrypt";
        } else if (w.equals("Encrypt & Sign...") | w.equals("Encrypt & Sign")) {
            this.what = 20;
            t = "encrypt and sign";
        } else {
            this.what = 16;
            t = "sign";
        }
        NSOpenPanel op = NSOpenPanel.openPanel();
        this.conventionalEncryptButton.setState(0);
        if (this.what == 16) {
            this.useClipboardBig.setEnabled(this.clipboardHasText());
            op.setAccessoryView((NSView)this.useClipboardBig);
        } else {
            this.useClipboard.setEnabled(this.clipboardHasText());
            op.setAccessoryView(this.openDialogExtraPanel);
        }
        op.setTitle("Choose a file to " + t);
        op.setTreatsFilePackagesAsDirectories(true);
        int result = op.runModalInDirectory(null, null, (NSArray)null);
        if (result != 0) {
            if (this.conventionalEncryptButton.state() == 1) {
                this.what |= 0x800;
            }
            if (result == 1) {
                this.inFile = (String)op.filenames().objectAtIndex(0);
                this.outFile = this.what == 16 ? GpgController.smartRename(this.inFile + ".sig") : GpgController.smartRename(this.inFile + ".pgp");
            } else {
                this.outFile = null;
                this.inFile = null;
            }
            if (this.what == 16) {
                this.showSigning();
            } else if ((this.what & 0x800) > 0) {
                this.showConventional();
            } else {
                this.showRecipients();
            }
        } else {
            this.outFile = null;
            this.inFile = null;
        }
    }

    public void addRecipient(NSTableView sender) {
        if (sender.clickedRow() < 0 || !sender.isRowSelected(sender.clickedRow())) {
            return;
        }
        this.addRemoveRecipient(sender, this.recipients, this.users);
    }

    public void removeRecipient(NSTableView sender) {
        if (sender.clickedRow() < 0 || !sender.isRowSelected(sender.clickedRow())) {
            return;
        }
        this.addRemoveRecipient(sender, this.users, this.recipients);
    }

    private void addRemoveRecipient(NSTableView sender, Vector addTo, Vector removeFrom) {
        int[] selectedRows = new int[sender.numberOfSelectedRows()];
        int i = 0;
        NSEnumerator e = sender.selectedRowEnumerator();
        while (e.hasMoreElements()) {
            int r = (Integer)e.nextElement();
            Key x = (Key)removeFrom.get(r);
            selectedRows[i] = r;
            addTo.add(x);
            ++i;
        }
        Arrays.sort(selectedRows);
        i = selectedRows.length - 1;
        while (i >= 0) {
            removeFrom.remove(selectedRows[i]);
            --i;
        }
        Collections.sort(addTo);
        sender.deselectAll((Object)sender);
        this.usersT.reloadData();
        this.recipientsT.reloadData();
        if (this.recipients.size() > 0) {
            this.recipientsOK.setEnabled(true);
        } else {
            this.recipientsOK.setEnabled(false);
        }
    }

    public void clipButton(Object sender) {
        NSApplication.sharedApplication().stopModal();
    }

    public void toggleTrustedKeys(NSButton sender) {
        if (sender.state() == 1) {
            this.showUntrusted = true;
            this.users = (Vector)this.g.kr.getPublicKeys().clone();
            Iterator i = ((AbstractList)this.recipients).iterator();
            while (i.hasNext()) {
                Key rec = (Key)i.next();
                if (!this.users.contains(rec)) continue;
                this.users.remove(rec);
            }
        } else {
            this.showUntrusted = false;
            Iterator i = ((AbstractList)this.recipients).iterator();
            while (i.hasNext()) {
                if (((Key)i.next()).isTrusted()) continue;
                i.remove();
            }
            Iterator i2 = ((AbstractList)this.users).iterator();
            while (i2.hasNext()) {
                if (((Key)i2.next()).isTrusted()) continue;
                i2.remove();
            }
        }
        Collections.sort(this.users);
        Collections.sort(this.recipients);
        this.usersT.reloadData();
        this.recipientsT.reloadData();
    }

    public void changeRecipientsLayout(NSButton sender) {
        if (sender.tag() == 0) {
            if (sender.state() == 1) {
                this.showKeyID = true;
                this.recipientsT.addTableColumn(this.keyIDCol);
                this.recipientsT.moveColumnToColumn(this.recipientsT.columnWithIdentifier((Object)"keyID"), 2);
                this.usersT.addTableColumn(this.keyIDCol);
                this.usersT.moveColumnToColumn(this.usersT.columnWithIdentifier((Object)"keyID"), 2);
            } else {
                this.showKeyID = false;
                this.recipientsT.removeTableColumn(this.keyIDCol);
                this.usersT.removeTableColumn(this.keyIDCol);
            }
        } else if (sender.tag() == 1) {
            if (sender.state() == 1) {
                this.showCreationDate = true;
                this.recipientsT.addTableColumn(this.creationDateCol);
                this.usersT.addTableColumn(this.creationDateCol);
            } else {
                this.showCreationDate = false;
                this.recipientsT.removeTableColumn(this.creationDateCol);
                this.usersT.removeTableColumn(this.creationDateCol);
            }
        }
        this.usersT.sizeLastColumnToFit();
        this.recipientsT.sizeLastColumnToFit();
    }

    private void closeConventional() {
        this.conventionalPass.setStringValue("");
        this.conventionalConfirm.setStringValue("");
        NSApplication.sharedApplication().stopModal();
        this.mainW.makeKeyWindow();
        this.conventionalEncW.close();
        this.conventionalPassTemp = null;
    }

    public void conventionalButton(NSView sender) {
        if (sender instanceof NSButton && ((NSButton)sender).title().equals("Cancel")) {
            this.closeConventional();
        } else if (!this.conventionalPass.stringValue().equals(this.conventionalConfirm.stringValue())) {
            NSAlertPanel.runAlert((String)"Passphrases did not match.", (String)"Reenter the passphrase, making sure to type it the same in both boxes.", (String)"OK", null, null);
            this.conventionalPass.setStringValue("");
            this.conventionalConfirm.setStringValue("");
            this.conventionalEncW.makeFirstResponder((NSResponder)this.conventionalPass);
        } else if (this.conventionalPass.stringValue().equals("")) {
            NSAlertPanel.runAlert((String)"Blank passphrase.", (String)"You cannot encrypt using a blank passphrase.", (String)"OK", null, null);
            this.conventionalEncW.makeFirstResponder((NSResponder)this.conventionalPass);
        } else {
            String s = this.conventionalPass.stringValue();
            this.closeConventional();
            this.conventionalPassTemp = s;
            if ((this.what & 0x10) > 0) {
                this.showSigning();
            } else {
                this.doEncrypt();
            }
        }
    }

    public void recipientsButton(NSButton sender) {
        NSApplication.sharedApplication().stopModal();
        this.mainW.makeKeyWindow();
        this.recipientsW.close();
        this.users.clear();
        if (sender.title().equals("OK")) {
            if (this.what == 4) {
                this.doEncrypt();
            } else {
                this.showSigning();
            }
        }
        this.recipients.clear();
        this.outFile = null;
        this.inFile = null;
    }

    private void doEncrypt() {
        String conv = this.conventionalPassTemp == null ? null : new String(this.conventionalPassTemp);
        this.conventionalPassTemp = null;
        if (this.inFile == null) {
            String clip = this.getClipboard();
            if (clip != null) {
                Gpg.Run result = (this.what & 0x800) > 0 ? this.g.encodeConventional(GpgController.parse(clip), conv, null, null) : this.g.encode(GpgController.parse(clip), this.recipients, null, null);
                if (result.getFlag(4) | result.getFlag(2048)) {
                    this.setClipboard(result.getResultString());
                } else {
                    NSAlertPanel.runAlert((String)"Encryption failed.", (String)"More information may be available in the log file.", (String)"OK", null, null);
                    this.recipientsW.orderOut((Object)this);
                }
            }
        } else {
            Gpg.Run result = (this.what & 0x800) > 0 ? this.g.encodeConventional(new File(this.inFile), new File(this.outFile), conv, null, null) : this.g.encode(new File(this.inFile), new File(this.outFile), this.recipients, null, null);
            if (result.getFlag(4) || result.getFlag(2048)) {
                GpgController.fixCreatorCode(this.outFile, false);
            } else {
                NSAlertPanel.runAlert((String)"Encryption failed.", (String)"More information may be available in the log file.", (String)"OK", null, null);
                this.recipientsW.orderOut((Object)this);
            }
        }
    }

    private void showSigning() {
        this.signingPassPhraseKey.removeAllItems();
        Iterator i = ((AbstractList)this.g.kr.getSecretKeys()).iterator();
        while (i.hasNext()) {
            this.signingPassPhraseKey.addItem(((Key)i.next()).name());
        }
        if (this.g.getDefaultKey() != null) {
            this.signingPassPhraseKey.selectItemWithTitle(this.g.getDefaultKey().name());
        }
        NSApplication.sharedApplication().runModalForWindow(this.signingW);
    }

    private void showConventional() {
        NSApplication.sharedApplication().runModalForWindow(this.conventionalEncW);
    }

    private void showRecipients() {
        this.updateRecipients();
        this.recipientsW.makeFirstResponder((NSResponder)this.usersT);
        NSApplication.sharedApplication().runModalForWindow(this.recipientsW);
    }

    private void updateRecipients() {
        this.users = this.showUntrusted ? (Vector)this.g.kr.getPublicKeys().clone() : (Vector)this.g.kr.getTrustedPublicKeys().clone();
        boolean resize = false;
        if (this.showKeyID & this.usersT.columnWithIdentifier((Object)"keyID") == -1) {
            this.usersT.addTableColumn(this.keyIDCol);
            this.recipientsT.addTableColumn(this.keyIDCol);
            resize = true;
            this.keyIDsButton.setState(1);
        }
        if (this.showCreationDate & this.usersT.columnWithIdentifier((Object)"creationDate") == -1) {
            this.usersT.addTableColumn(this.creationDateCol);
            this.recipientsT.addTableColumn(this.creationDateCol);
            resize = true;
            this.creationDatesButton.setState(1);
        }
        this.recipients.clear();
        Collections.sort(this.users);
        Vector encTos = this.g.getEncryptTos();
        if (encTos != null) {
            Iterator i = ((AbstractList)encTos).iterator();
            while (i.hasNext()) {
                Key k = (Key)i.next();
                if (!this.users.remove(k)) continue;
                this.recipients.add(k);
            }
        }
        Collections.sort(this.recipients);
        if (this.recipients.size() > 0) {
            this.recipientsOK.setEnabled(true);
        } else {
            this.recipientsOK.setEnabled(false);
        }
        this.recipientsT.reloadData();
        this.usersT.reloadData();
        if (resize) {
            this.usersT.sizeLastColumnToFit();
            this.recipientsT.sizeLastColumnToFit();
        }
    }

    public void signingButton(Object sender) {
        if (sender instanceof NSSecureTextField || ((NSButton)sender).title().equals("OK")) {
            Key key = new Key(this.signingPassPhraseKey.titleOfSelectedItem());
            String pass = this.signingPassPhrase.stringValue();
            Gpg.Run result = null;
            if ((this.what & 0x14) == 20) {
                if (this.inFile != null) {
                    result = (this.what & 0x800) > 0 ? this.g.encodeConventional(new File(this.inFile), new File(this.outFile), this.conventionalPassTemp, key, pass) : this.g.encode(new File(this.inFile), new File(this.outFile), this.recipients, key, pass);
                    GpgController.fixCreatorCode(this.outFile, false);
                } else {
                    String clip = this.getClipboard();
                    if (clip != null) {
                        result = (this.what & 0x800) > 0 ? this.g.encodeConventional(GpgController.parse(clip), this.conventionalPassTemp, key, pass) : this.g.encode(GpgController.parse(clip), this.recipients, key, pass);
                        if (result.getFlag(16) & (result.getFlag(4) | result.getFlag(2048))) {
                            this.setClipboard(result.getResultString());
                        } else if (!result.getFlag(1)) {
                            NSAlertPanel.runAlert((String)"Encryption failed.", (String)"More information may be available in the log file.", (String)"OK", null, null);
                        }
                    }
                }
            } else if (this.inFile != null) {
                result = this.g.encode(new File(this.inFile), new File(this.outFile), null, key, pass);
                GpgController.fixCreatorCode(this.outFile, true);
            } else {
                String clip = this.getClipboard();
                if (clip != null) {
                    result = this.g.encode(GpgController.parse(clip), null, key, pass);
                    if (result.getFlag(16)) {
                        this.setClipboard(result.getResultString());
                    } else if (!result.getFlag(1)) {
                        NSAlertPanel.runAlert((String)"Signing failed.", (String)"More information may be available in the log file.", (String)"OK", null, null);
                    }
                }
            }
            if (result.getFlag(1)) {
                NSAlertPanel.runAlert((String)"Incorrect Passphrase.", (String)"Please try again.", (String)"OK", null, null);
                this.signingPassPhrase.setStringValue("");
                this.signingW.makeFirstResponder((NSResponder)this.signingPassPhrase);
            } else {
                this.closeSigning();
            }
        } else {
            this.closeSigning();
        }
    }

    private void closeSigning() {
        NSApplication.sharedApplication().stopModal();
        this.mainW.makeKeyWindow();
        this.signingW.close();
        this.signingPassPhraseKey.removeAllItems();
        this.signingPassPhrase.setStringValue("");
        this.conventionalPassTemp = null;
    }

    private void closeDecrypt() {
        NSApplication.sharedApplication().stopModal();
        this.mainW.makeKeyAndOrderFront((Object)this);
        if (this.decryptW.isVisible()) {
            this.decryptW.close();
        }
        if (this.conventionalDecW.isVisible()) {
            this.conventionalDecW.close();
        }
        if (this.decryptFailedW.isVisible()) {
            this.decryptFailedW.close();
        }
        this.decryptPassPhraseKey.setStringValue("");
        this.decryptPassPhrase.setStringValue("");
        this.conventionalDecrypt.setStringValue("");
    }

    void p(String x) {
        this.log.println(x);
    }

    static String smartRename(String name) {
        String ex;
        int extn1 = name.lastIndexOf(".");
        int extn = name.lastIndexOf(".", extn1 - 1);
        if (extn == -1) {
            extn = extn1;
        }
        if (extn == -1) {
            ex = "";
        } else {
            ex = name.substring(extn);
            name = name.substring(0, extn);
        }
        int pos = name.indexOf(" ");
        if (pos < name.length() - 1) {
            char x = name.charAt(pos + 1);
            if (name.length() - pos < 3 && x >= '0' && x <= '9') {
                name = name.substring(0, pos);
            }
        }
        int i = 1;
        if (new File(name + ex).exists()) {
            while (new File(name + " " + i + ex).exists()) {
                ++i;
            }
            return name + " " + i + ex;
        }
        return name + ex;
    }

    public void startDecrypt(Object sender) {
        this.g.updateKeyInfo();
        NSOpenPanel op = NSOpenPanel.openPanel();
        op.setTitle("Choose a file to decrypt and/or verify");
        op.setTreatsFilePackagesAsDirectories(true);
        this.useClipboardBig.setEnabled(this.clipboardHasText());
        op.setAccessoryView((NSView)this.useClipboardBig);
        int res = op.runModalInDirectory(null, null, (NSArray)null);
        if (res == 1) {
            this.inFile = (String)op.filenames().objectAtIndex(0);
            this.doDecrypt();
        } else if (res != 0) {
            this.outFile = null;
            this.inFile = null;
            String clip = this.getClipboard();
            if (clip != null) {
                Gpg.Run result = this.g.decode(GpgController.parse(clip), "String");
                this.handleDecryptResult(result);
            }
        }
    }

    private void doDecrypt() {
        if (this.inFile.endsWith(".sig")) {
            this.outFile = null;
        } else if (this.inFile.endsWith(".pgp")) {
            this.outFile = this.inFile.substring(0, this.inFile.length() - 4);
            this.outFile = GpgController.smartRename(this.outFile);
        } else {
            this.outFile = GpgController.smartRename(this.inFile);
        }
        Gpg.Run result = this.outFile == null ? this.g.decode(new File(this.inFile), "null") : this.g.decode(new File(this.inFile), new File(this.outFile));
        this.handleDecryptResult(result);
    }

    private void handleDecryptResult(Gpg.Run result) {
        if (result.getFlag(2)) {
            NSOpenPanel op = NSOpenPanel.openPanel();
            op.setTitle("Please locate the file that this signature refers to");
            int res = op.runModalInDirectory(null, null, (NSArray)null);
            if (res == 1) {
                String f = (String)op.filenames().objectAtIndex(0);
                result.continueDetachedSig(f);
                this.handleDecryptResult(result);
                return;
            }
            result.terminateRun();
            this.success = false;
            return;
        }
        if (result.getFlag(64)) {
            String bit = this.inFile == null ? "The clipboard" : "File '" + new File(this.inFile).getName() + "'";
            NSAlertPanel.runAlert((String)(bit + " does not contain any valid PGP data."), (String)"Decryption cannot continue.", (String)"Cancel", null, null);
            this.success = false;
        } else if (result.getFlag(512)) {
            String bit = this.inFile == null ? "data" : "file";
            NSAlertPanel.runAlert((String)"Unknown algorithm encountered.", (String)("Decryption cannot continue because the algorithm used to encrypt this " + bit + " is not recognised. You may need to install the IDEA module; information on this can be found at\n\nhttp://macgpg.sourceforge.net/docs/howto-install-IDEA.txt.asc"), (String)"Cancel", null, null);
            this.success = false;
        } else if (result.getFlag(4096)) {
            this.globalTempRun = result;
            NSApplication.sharedApplication().runModalForWindow(this.conventionalDecW);
        } else {
            this.recipients = result.getRecipients();
            if (this.recipients == null) {
                this.recipients = new Vector();
            }
            Collections.sort(this.recipients);
            Key theKey = result.getSignKey();
            if (!result.getFlag(4)) {
                result.continueSigned();
                this.finishDecrypt(result);
            } else if (result.getFlag(128)) {
                this.decryptFailedT.reloadData();
                NSApplication.sharedApplication().runModalForWindow(this.decryptFailedW);
                this.success = false;
            } else if (result.getFlag(1024)) {
                result.continueDecrypt(null);
                this.finishDecrypt(result);
            } else {
                this.globalTempRun = result;
                this.decryptT.reloadData();
                this.decryptPassPhraseKey.setStringValue(theKey.name());
                NSApplication.sharedApplication().runModalForWindow(this.decryptW);
            }
        }
    }

    public void decryptButton(NSView sender) {
        boolean conventional;
        boolean bl = conventional = sender.window() == this.conventionalDecW;
        if (sender instanceof NSSecureTextField || ((NSButton)sender).title().equals("OK")) {
            NSWindow theWin;
            NSSecureTextField pass;
            if (conventional) {
                pass = this.conventionalDecrypt;
                theWin = this.conventionalDecW;
            } else {
                pass = this.decryptPassPhrase;
                theWin = this.decryptW;
            }
            if (pass.stringValue().equals("")) {
                NSAlertPanel.runAlert((String)"You must supply a passphrase.", (String)"Please try again.", (String)"OK", null, null);
                theWin.makeFirstResponder((NSResponder)pass);
                return;
            }
            String z = pass.stringValue();
            if (!conventional) {
                this.globalTempRun.continueDecrypt(z);
            } else {
                this.globalTempRun.continueConventionalDecrypt(z);
            }
            if (this.globalTempRun.getFlag(4097)) {
                NSAlertPanel.runAlert((String)"Incorrect Passphrase.", (String)"Please try again.", (String)"OK", null, null);
                pass.setStringValue("");
                theWin.makeFirstResponder((NSResponder)pass);
                return;
            }
            this.closeDecrypt();
            this.finishDecrypt(this.globalTempRun);
        } else {
            this.globalTempRun.p.destroy();
            this.closeDecrypt();
            this.success = false;
        }
    }

    private void finishDecrypt(Gpg.Run result) {
        String info;
        String main;
        if (this.inFile == null && result.getResultString() != null) {
            this.setClipboard(result.getResultString());
        }
        if (result.getFlag(16)) {
            if (result.getFlag(32)) {
                main = "Document verified OK.";
                info = result.getSignKey().name() + " signed this on " + result.getSignDate() + ".\n\nKey ID of signer: " + Key.format(result.getSignKey().getPrimaryKey());
                this.success = true;
            } else {
                main = "Document verification failed.";
                if (result.getSignKey() == null) {
                    info = "Unable to verify origin of document.";
                } else if (result.getFlag(256)) {
                    info = "The public key of id " + Key.format(result.getSignKey().toString()) + " is not available so this signature cannot be verified.";
                    if (result.getSignDate() != null) {
                        info = info + " (Signed on " + result.getSignDate() + ".)";
                    }
                } else {
                    info = "This document in this form does not originate from " + result.getSignKey() + ".";
                }
                this.success = false;
            }
        } else if (result.getFlag(2052) && !result.getFlag(8)) {
            main = "Decryption failed.";
            info = "An error occurred during decryption.";
            this.success = false;
        } else {
            this.success = true;
            return;
        }
        NSAlertPanel.runAlert((String)main, (String)info, (String)"OK", null, null);
        this.decryptW.orderOut((Object)this);
        this.conventionalDecW.orderOut((Object)this);
    }

    public boolean validateMenuItem(_NSObsoleteMenuItemProtocol menuItem) {
        boolean cond = this.mainW.isKeyWindow() || this.serviceW.isKeyWindow();
        return cond;
    }

    public boolean applicationShouldTerminateAfterLastWindowClosed(NSApplication a) {
        return true;
    }

    public void applicationWillTerminate(NSNotification aNotification) {
        if (this.log != System.out) {
            this.log.close();
        }
        NSUserDefaults nSUserDefaults = this.nsud;
        synchronized (nSUserDefaults) {
            this.nsud.setBooleanForKey(this.showKeyID, "showKeyID");
            this.nsud.setBooleanForKey(this.showCreationDate, "showCreationDate");
        }
    }

    boolean clipboardHasText() {
        NSArray x = this.servicesBoard == null ? NSPasteboard.generalPasteboard().types() : this.servicesBoard.types();
        return x.indexOfObject((Object)"NSStringPboardType") != Integer.MAX_VALUE;
    }

    private String getClipboard() {
        if (!this.clipboardHasText()) {
            return null;
        }
        if (this.servicesBoard == null) {
            return NSPasteboard.generalPasteboard().stringForType("NSStringPboardType");
        }
        return this.servicesBoard.stringForType("NSStringPboardType");
    }

    private void setClipboard(String s) {
        NSPasteboard clip = this.servicesBoard == null ? NSPasteboard.generalPasteboard() : this.servicesBoard;
        NSArray types = new NSArray((Object)"NSStringPboardType");
        clip.declareTypes(types, null);
        clip.setStringForType(s, "NSStringPboardType");
    }

    public String serviceE(NSPasteboard n, String userData) {
        return this.service(n, "E");
    }

    public String serviceES(NSPasteboard n, String userData) {
        return this.service(n, "ES");
    }

    public String serviceS(NSPasteboard n, String userData) {
        return this.service(n, "S");
    }

    public String serviceD(NSPasteboard n, String userData) {
        return this.service(n, "D");
    }

    public String serviceDDD(NSPasteboard n, String userData) {
        return this.service(n, "D...");
    }

    public synchronized String service(NSPasteboard n, String userData) {
        this.g.updateKeyInfo();
        this.outFile = null;
        this.inFile = null;
        this.servicesBoard = n;
        boolean isFileOnClip = this.servicesBoard.types().containsObject((Object)"NSFilenamesPboardType");
        if (isFileOnClip) {
            this.inFile = this.getClipboard();
            this.outFile = GpgController.smartRename(this.inFile + (userData.startsWith("E") ? ".pgp" : ".sig"));
            if (new File(this.inFile).isDirectory()) {
                NSApplication.sharedApplication().activateIgnoringOtherApps(true);
                NSAlertPanel.runAlert((String)"Cannot encrypt/decrypt folders.", (String)"You have tried to encrypt or decrypt a folder, which is not possible. Use a utility such as tar or DropStuff to convert the folder to a single first, then encrypt it.\n\nNote this error will also occur if you tried to use Services on a file on the Desktop. Close all open windows and try again, or see the FAQ for more information.", (String)"Cancel", null, null);
                NSApplication.sharedApplication().hide((Object)this);
                return "User tried to select a folder";
            }
        }
        NSApplication.sharedApplication().activateIgnoringOtherApps(true);
        if (userData.equals("E")) {
            this.what = 4;
            this.showRecipients();
        } else if (userData.equals("ES")) {
            this.what = 20;
            this.showRecipients();
        } else if (userData.equals("S")) {
            this.what = 16;
            this.showSigning();
        } else if (userData.equals("D") || userData.equals("D...")) {
            String clip = this.getClipboard();
            if (isFileOnClip) {
                this.doDecrypt();
            } else if (clip != null) {
                Gpg.Run result = this.g.decode(GpgController.parse(clip), "String");
                this.handleDecryptResult(result);
                if (userData.equals("D...")) {
                    this.serviceResult.setString(this.getClipboard());
                    this.showDecryptResults((Object)this);
                }
            }
        } else {
            return "Unknown command";
        }
        this.servicesBoard = null;
        if (!userData.equals("D...")) {
            NSApplication.sharedApplication().hide((Object)this);
        }
        return null;
    }

    public void windowWillClose(NSNotification n) {
        if (((NSWindow)n.object()).title().equals("Decryption results")) {
            this.serviceResult.setString("");
        }
    }

    public void keyDown(NSEvent e) {
        String s = e.characters();
        if (s.length() == 1) {
            char c = s.charAt(0);
            if (c == ' ') {
                this.addRemoveRecipient(this.usersT, this.recipients, this.users);
            } else if (!Character.isIdentifierIgnorable(c) && !Character.isISOControl(c) && Character.getType(c) != 18) {
                int pos = Collections.binarySearch(this.users, s);
                if (pos < 0) {
                    pos ^= 0xFFFFFFFF;
                }
                if (pos >= this.users.size()) {
                    pos = this.users.size() - 1;
                }
                this.usersT.selectRow(pos, false);
                this.usersT.scrollRowToVisible(pos);
            } else {
                super.keyDown(e);
            }
        } else {
            super.keyDown(e);
        }
    }

    public void serviceButton(Object sender) {
        this.servicesBoard = null;
        if (sender instanceof NSButton && ((NSButton)sender).title().startsWith("Copy all to Clipboard")) {
            this.setClipboard(this.serviceResult.string());
        } else {
            this.serviceW.orderOut(sender);
            this.serviceResult.setString("");
        }
    }

    public void showDecryptResults(Object sender) {
        this.serviceW.makeKeyAndOrderFront((Object)this);
    }

    public static String parse(String s) {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int n = s.indexOf(10, i);
            int r = s.indexOf(13, i);
            if (n == -1 && r == -1) {
                res.append(s.substring(i));
                break;
            }
            if (r != -1 && n == r + 1) {
                res.append(s.substring(i, r));
                res.append('\n');
                i = n + 1;
            } else if (r != -1 && (n > r || n == -1)) {
                res.append(s.substring(i, r));
                res.append('\n');
                i = r + 1;
            } else if (n != -1 && (r > n || r == -1)) {
                res.append(s.substring(i, n));
                res.append('\n');
                i = n + 1;
            }
            if (i != s.length()) continue;
            res.append('\n');
        }
        return res.toString();
    }

    public boolean applicationOpenFile(NSApplication theApplication, String filename) {
        if (filename.endsWith(".esig")) {
            NSAlertPanel.runAlert((String)"Cannot open Embedded Signature Files.", (String)"These can only be used from an application that has opened the document that the signature is embedded in.", (String)"Cancel", null, null);
            return false;
        }
        this.inFile = filename;
        this.doDecrypt();
        return this.success;
    }

    private static void fixCreatorCode(String file, boolean detachedSig) {
        Object[] keys = new String[]{"NSFileHFSCreatorCode", "NSFileHFSTypeCode"};
        Object[] items = new Object[]{GpgController.stringToInt("GpgT"), detachedSig ? GpgController.stringToInt("pgDS") : GpgController.stringToInt("pgEF")};
        NSDictionary attrib = new NSDictionary(items, keys);
        NSPathUtilities.setFileAttributes((String)file, (NSDictionary)attrib);
    }

    private static Integer stringToInt(String x) {
        if (x.length() != 4) {
            return null;
        }
        int res = 0;
        res |= x.charAt(0) << 24;
        res |= x.charAt(1) << 16;
        res |= x.charAt(2) << 8;
        return new Integer(res |= x.charAt(3) << 0);
    }

    public void helpMenuItem(NSMenuItem m) {
        int n = m.tag();
        switch (n) {
            case 0: {
                NSWorkspace.sharedWorkspace().openURL(this.homePageURL);
                break;
            }
            case 1: {
                NSWorkspace.sharedWorkspace().openURL(this.emailURL);
                break;
            }
            case 2: {
                this.versionCheck();
            }
        }
    }

    void versionCheck() {
        int res = NSAlertPanel.runAlert((String)"Check Gpg Tools' website for a newer version?", (String)"This requires an active internet connection.", (String)"Check", (String)"Cancel", null);
        if (res == 1) {
            try {
                InputStream o = (InputStream)this.versionURL.getContent();
                BufferedReader b = new BufferedReader(new InputStreamReader(o));
                Integer latestVersionNo = Integer.valueOf(b.readLine());
                String latestVersion = b.readLine();
                Integer myVersionNo = Integer.valueOf((String)NSBundle.mainBundle().infoDictionary().objectForKey((Object)"CFBundleVersion"));
                if (latestVersionNo.compareTo(myVersionNo) > 0) {
                    int get = NSAlertPanel.runAlert((String)"A newer version is available.", (String)("Do you want to Gpg Tools' home page for version " + latestVersion + "?"), (String)"Go", (String)"Cancel", null);
                    if (get == 1) {
                        NSWorkspace.sharedWorkspace().openURL(this.homePageURL);
                    }
                } else {
                    NSAlertPanel.runAlert((String)"No new version is available.", (String)"This version is up to date.", (String)"OK", null, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
                NSAlertPanel.runAlert((String)"An error occurred while retrieving version information.", (String)"Try again later or visit <http://www.tomsci.com/gpgtools/> manually.", (String)"Cancel", null, null);
            }
        }
    }

    public void tabToConfirm(Object o) {
        this.conventionalEncW.makeFirstResponder((NSResponder)this.conventionalConfirm);
    }

    public void devnull(Object o) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

