/*
 * Decompiled with CFR 0.152.
 */
package com.tomsci.Gpg;

import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class Key
implements Comparable,
Cloneable,
Serializable {
    private String uid;
    private Vector keyIDs;
    private Date expiryDate;
    private Date creationDate;
    private boolean isTrusted;
    private boolean isSecretKey;
    private boolean isIDOnly = false;
    boolean revoked = false;

    public Key(String uid, Vector keyIDs, Date ex, Date cr, boolean trust, boolean sec, boolean revoked) {
        if (uid == null || keyIDs == null || cr == null) {
            throw new NullPointerException("Can't create a Key with null fields");
        }
        this.uid = uid;
        this.keyIDs = keyIDs;
        this.expiryDate = ex;
        this.creationDate = cr;
        this.isTrusted = trust;
        this.isSecretKey = sec;
        this.revoked = revoked;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public Key(String ident) {
        this.isIDOnly = true;
        this.uid = ident;
        this.isTrusted = false;
        this.isSecretKey = false;
    }

    public final String toString() {
        return this.name();
    }

    public String name() {
        return this.uid;
    }

    public boolean hasExpired() {
        if (this.expiryDate == null) {
            return false;
        }
        return new Date().after(this.expiryDate);
    }

    public Vector keyIDs() {
        return this.keyIDs;
    }

    public String getPrimaryKey() {
        return (String)this.keyIDs.get(0);
    }

    public boolean isTrusted() {
        return this.isTrusted;
    }

    public boolean isSecretKey() {
        return this.isSecretKey;
    }

    public Date creationDate() {
        return this.creationDate;
    }

    public Date expiryDate() {
        return this.expiryDate;
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.name().compareToIgnoreCase((String)o);
        }
        Key k = (Key)o;
        int s = this.name().compareToIgnoreCase(k.name());
        if (s != 0) {
            return s;
        }
        int t = this.creationDate.compareTo(k.creationDate);
        if (t != 0) {
            return t;
        }
        return ((String)this.keyIDs.get(0)).compareToIgnoreCase((String)k.keyIDs.get(0));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Key)) {
            return false;
        }
        Key k = (Key)o;
        return this.uid.equals(k.uid) && this.keyIDs.equals(k.keyIDs) && this.isSecretKey == k.isSecretKey;
    }

    public static String format(String s) {
        StringBuffer sb = new StringBuffer(s);
        int insAt = 4;
        while (insAt < sb.length()) {
            sb.insert(insAt, ' ');
            insAt += 5;
        }
        return sb.toString();
    }
}

