/*
 * Decompiled with CFR 0.152.
 */
package com.tomsci.Gpg;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ShellProc {
    public static final String newLine = System.getProperty("line.separator");
    Vector lines;
    private Process p;
    ShellProc pipedFrom = null;
    String[] args;
    String stdIn;
    BufferedInputStream in;
    BufferedReader err;
    BufferedOutputStream outBinary;
    PrintStream log = System.out;
    String streamFormat = null;
    Thread backgroundTask;
    String cacheLine = null;
    boolean sameAgain = false;

    public ShellProc(String[] ps) {
        this.args = ps;
    }

    public ShellProc(List ps) {
        this.args = new String[ps.size()];
        ps.toArray(this.args);
    }

    public ShellProc(String[] ps, PrintStream p) {
        this(ps);
        this.log = p;
    }

    public ShellProc(List ps, PrintStream p) {
        this(ps);
        this.log = p;
    }

    public void setStreamFormat(String s) {
        this.streamFormat = s;
        if (this.pipedFrom != null) {
            this.pipedFrom.setStreamFormat(s);
        }
    }

    public String getStreamFormat() {
        return this.streamFormat;
    }

    public void exec() {
        this.exec(false);
    }

    void exec(boolean isInPipe) {
        try {
            if (this.pipedFrom != null) {
                this.pipedFrom.exec(true);
            }
            int i = 0;
            while (i < this.args.length) {
                this.pr(this.args[i] + " ");
                ++i;
            }
            if (isInPipe) {
                this.pr("| ");
            } else {
                this.pl();
            }
            this.p = Runtime.getRuntime().exec(this.args);
            if (!isInPipe) {
                this.in = new BufferedInputStream(this.p.getInputStream());
                this.err = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
            }
            if (this.pipedFrom == null) {
                this.outBinary = new BufferedOutputStream(this.p.getOutputStream());
            } else {
                Runnable r = new Runnable(){

                    public void run() {
                        InputStream r = ShellProc.this.pipedFrom.p.getInputStream();
                        OutputStream o = ShellProc.this.p.getOutputStream();
                        try {
                            while (true) {
                                int b;
                                if ((b = r.read()) == -1) {
                                    r.close();
                                    o.close();
                                    return;
                                }
                                o.write(b);
                            }
                        }
                        catch (IOException e) {
                            ShellProc.this.pl("Broken pipe: " + e);
                            return;
                        }
                    }
                };
                this.pipedFrom.backgroundTask = new Thread(r);
                this.pipedFrom.backgroundTask.start();
            }
        }
        catch (IOException e) {
            this.echo(e);
        }
    }

    public String readLine() {
        return this.readLine(null);
    }

    public String readLine(String start) {
        if (this.sameAgain && this.cacheLine != null) {
            this.sameAgain = false;
            return this.cacheLine;
        }
        try {
            this.cacheLine = this.err.readLine();
            this.pl(this.cacheLine);
            if (this.cacheLine == null) {
                return null;
            }
            if (start == null || start != null && this.cacheLine.startsWith(start)) {
                return this.cacheLine;
            }
            return this.readLine(start);
        }
        catch (IOException e) {
            this.cacheLine = null;
            return null;
        }
    }

    public String readWithoutLogging() {
        if (this.lines != null) {
            this.bomb("Can't call readWithoutLogging() after having called getAllOutput() - stream is already closed");
        }
        try {
            String s = this.getLineFrom(this.in);
            return s;
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getAllDataOutput() {
        Vector<byte[]> bv = new Vector<byte[]>();
        int byteCount = 0;
        try {
            byte[] b;
            int x;
            while ((x = this.in.read(b = new byte[512], 0, b.length)) != -1) {
                if (x < b.length) {
                    byte[] bb = new byte[x];
                    System.arraycopy(b, 0, bb, 0, x);
                    bv.add(bb);
                    byteCount += x;
                    continue;
                }
                if (x != b.length) continue;
                bv.add(b);
                byteCount += b.length;
            }
        }
        catch (IOException e) {
            return null;
        }
        byte[] res = new byte[byteCount];
        int destPos = 0;
        Iterator i = ((AbstractList)bv).iterator();
        while (i.hasNext()) {
            byte[] next = (byte[])i.next();
            System.arraycopy(next, 0, res, destPos, next.length);
            destPos += next.length;
        }
        return res;
    }

    public String readStdout() {
        if (this.lines != null) {
            this.bomb("Can't call readStdout() after having called getAllOutput() - stream is already closed");
        }
        try {
            String s = this.getLineFrom(this.in);
            this.pl(s);
            return s;
        }
        catch (IOException e) {
            this.echo(e);
            return null;
        }
    }

    public void writeLine(String r) {
        if (this.pipedFrom != null) {
            this.bomb("Can't write to the middle of a pipe");
        } else {
            try {
                if (!r.endsWith(newLine)) {
                    r = r + newLine;
                }
                byte[] b = this.streamFormat == null ? r.getBytes() : r.getBytes(this.streamFormat);
                this.outBinary.write(b);
                this.outBinary.flush();
            }
            catch (IOException e) {
                this.echo(e);
            }
        }
    }

    public void writeBinary(byte[] bs) {
        if (this.pipedFrom != null) {
            this.bomb("Can't write to the middle of a pipe");
        } else {
            try {
                this.outBinary.write(bs);
                this.outBinary.flush();
            }
            catch (IOException e) {
                this.echo(e);
            }
        }
    }

    public void writeEOF() {
        if (this.pipedFrom != null) {
            this.bomb("Can't close the middle of a pipe");
        } else {
            try {
                this.outBinary.flush();
                this.outBinary.close();
            }
            catch (IOException e) {
                this.echo(e);
            }
        }
    }

    public Vector getAllOutput() {
        return this.getAllOutput(false);
    }

    public Vector getAllOutput(boolean monitorStdErr) {
        if (this.lines == null) {
            this.lines = new Vector();
            if (monitorStdErr) {
                Runnable r = new Runnable(){

                    public void run() {
                        try {
                            while (true) {
                                String s;
                                if ((s = ShellProc.this.err.readLine()) == null) {
                                    return;
                                }
                                if (ShellProc.this.log != null) {
                                    ShellProc.this.pl("stdErr: " + s);
                                    continue;
                                }
                                System.err.println(s);
                            }
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                };
                this.backgroundTask = new Thread(r);
                this.backgroundTask.start();
            }
            try {
                String s;
                while ((s = this.getLineFrom(this.in)) != null) {
                    this.pl(s);
                    this.lines.add(s);
                }
            }
            catch (IOException e) {
                this.echo(e);
                return this.lines;
            }
        }
        return this.lines;
    }

    public void rewindLine() {
        this.sameAgain = true;
    }

    public void destroy() {
        this.p.destroy();
    }

    void pl() {
        if (this.log != null) {
            this.log.println();
        }
    }

    void pl(String s) {
        if (this.log != null) {
            this.log.println(s);
        }
    }

    void pr(String s) {
        if (this.log != null) {
            this.log.print(s);
        }
    }

    public void pipe(ShellProc b) {
        if (this.p != null || b.p != null) {
            this.bomb("Can't pipe after the ShellProcs have started");
        }
        b.pipedFrom = this;
    }

    void bomb(String s) {
        this.pl(s);
        throw new IllegalStateException(s);
    }

    void echo(Exception e) {
        if (this.log != null) {
            e.printStackTrace(this.log);
        }
    }

    String getLineFrom(BufferedInputStream b) throws IOException {
        int next;
        Vector<Byte> bb = new Vector<Byte>();
        int stringLen = 0;
        boolean secondByte = false;
        boolean hitEnd = false;
        while ((next = b.read()) != 10) {
            if (next == -1) {
                hitEnd = true;
                break;
            }
            bb.add(new Byte((byte)next));
            if (!secondByte) {
                ++stringLen;
                if (next <= 127 || !"utf-8".equals(this.streamFormat)) continue;
                secondByte = true;
                continue;
            }
            secondByte = false;
        }
        if (hitEnd && bb.size() == 0) {
            return null;
        }
        byte[] line = new byte[bb.size()];
        Byte[] oline = new Byte[bb.size()];
        bb.toArray(oline);
        int i = 0;
        while (i < line.length) {
            line[i] = oline[i];
            ++i;
        }
        if (this.streamFormat == null) {
            return new String(line);
        }
        String lineString = new String(line, this.streamFormat);
        if (lineString.length() != stringLen) {
            lineString = new String(line, "iso-8859-1");
        }
        return lineString;
    }
}

