/* pgp4pine menus.c
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* ------------------------------------------------------------ */
void fileVerifyDecryptMenu(char *inFile,char *outFile)
{
	FILE *fin;
	int  fertig=0,i=0;
	char c,readline[CONSOLE_IO_LINE_LENGTH];
	
	// Try do decide what file we have (signed, encrypted)
	if ((fin=fopen(inFile,"r"))==NULL)
	{
	  printf("Error opening Message !!\n");
	  documentStatus("Error in fileVerifyDecryptMenu(): Unable to open input file\n"); 
	}
	else
	do {
	  fertig=0;
	  while (!fertig)
	  {
	    if ((c=getc(fin))==EOF)
	    {
	      outFile=inFile; /* this usually is not 
	      			 executed, EOF breaks directly */
	      return;
	    } 
	    else if ((readline[i++]=c) == '\n')
	    {
	      readline[i]='\0';
	      fertig=1;
	    } 
	  }
	  fertig=0;
	  
	  if (strncmp("-----BEGIN PGP SIGNED",readline,20)==0)
	  {
	    // got signed message
	    fclose(fin);
	    fileVerify(inFile,outFile);
	    fertig=1;
	  } 
	  else if (strncmp("-----BEGIN PGP",readline,14)==0)
	  {
	    // got another type of PGP message (encrypted, keys ...)
	    fclose(fin);
	    fileDecrypt(inFile,outFile);
	    waitForReturn();
	    fertig=1;
	  }
	  else
	    i=0; // Got waste line, reset i
	} while (!fertig);
}
void fileVerifyMenu(const char *inFile,const char *outFile)
{
	// inFile and outFile are a) just passed to fileVerifyDecrypt, and
	// b) should already be copied into inFile, outFile in main.c:main()
	// so they should be (safe) pointers...
	printf("\nVerify file\n\n");
	fileVerify(inFile,outFile); 	/* pki.c */
	return;
}

void fileDecryptMenu(const char *inFile,const char *outFile)
{
	// inFile and outFile are a) just passed to fileVerifyDecrypt, and
	// b) should already be copied into inFile, outFile in main.c:main()
	// so they should be (safe) pointers...
	printf("\nDecrypt file\n\n");
	fileDecrypt(inFile,outFile);	/* pki.c */
	waitForReturn();
	return;
}

/* There are lots of combinations for do-sign and do-encrypt values, and if recipients are already present or not.
 * The Program flow works like this: (note: signFile and encryptFile values are: -1:no, 0:ask, 1:yes)
 *
 *  | sign | encrypt | 
 *  +------+---------+
 *  |  no  |   no    |     do nothing [any other case first get recipient list]
 *  |  no  | ask/yes |     get keyrings; check keys; Menu (1)
 *  |  ask |   no    |     ask sign; if no then do nothing; else send
 *  |  yes |   no    |     send
 *  |  ask |   ask   |     get keyrings; check keys; Menu (2)
 *  |  ask |   yes   |     get keyrings; check keys; Menu (3)
 *  |  yes |   ask   |     get keyrings; check keys; Menu (4)
 *  |  yes |   yes   |     get keyrings; check keys; Menu (5)
 *  +------+---------+     
 *  
 *   Menus:                   
 *  Menu (1) (no sign/do encryption)  | Menu (2) (ask sign/ask enc.)     |
 *  nonex. keys:   | all keys exist:  | nonex. keys    | all keys there: |
 *  - send unmod   |                  | - sign         | - sign+enc      |
 *  - ask keyserver|   [ no menu ]    | - send unmod.  | - sign          |
 *                 |                  | - ask keyserver| - encrypt       |
 *                 |                  |                | - unmodified    |
 * ----------------+------------------+----------------+-----------------+
 * Menu (3) (ask sign/do encrypt)     | Menu (4) (do sign/ask enc.)      |
 * nonex. keys:   | all keys there:   | nonex. keys:   | all keys there: |
 * - sign         | - sign+enc        | - sign         | - sign          |
 * - send unmod.  | - enc             | - ask keyserver| - sign+enc      |
 * - ask keyserver|                   |                |                 |
 * ---------------+-------------------+----------------+-----------------+
 * Menu (5) (do sign/do encrypt)      |
 * - sign         |                   |
 * - ask keyserver| [ no menu ]       |
 * ---------------+-------------------+
 * Every "ask keyserver" menu has a point "abort" in case keyserver didn't work
 * and you have big secrets that may not be sent unencrypted, and to give 
 * pgp2 / gpg an alternative. This will make pgp4pine fail, pine presents a 
 * big broken warning (gnn..), and your back in the editor .. 
 */
// ---------------------------------------------------------------------------------
/* Menus for various combinations of signFile / encryptFile */
int menu_noyes (int *sign, int *encrypt, int unknownkeys) /* Menu 1*/
{
  int action;
  
  documentStatus("Presenting menu for no sign/ask_or_yes encrypt ");  
  if (unknownkeys)
  {
    documentStatus("with unknown keys, ");
    if (*encrypt==1)
      printf("Your recipient list has unknown keys, you can not encrypt. You may:\n");
    else
      printf("Your recipient list has unknown keys. You may:\n");
    printf("a) Send the message unmodified\n");
    if (myUserPrefs->pgpVersion == 5 || myUserPrefs->pgpVersion == 1)
    {
      printf("b) Ask the Keyserver for unknown keys and start over\n"
             "c) Open a shell to add their key manually\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'c','q'))
      {
      	  case 'a': action= 0; *sign = -1; *encrypt = -1; documentStatus("Selection: S-E-\n"); break;
    	  case 'b': action= 2;				documentStatus("Selection: Ask\n");  break;
	  case 'c': action= 3;				documentStatus("Selectoin: Shell\n"); break;
    	  default : action=-1;				documentStatus("Selection: quit\n");
      }
    }
    else
    {
      	printf("b) Open a shell to add their key manually\nq) Abort and Quit\n\n");
	switch (askAlphaRange("Make your choice:",'b','q'))
	{
		case 'a': action= 0; *sign = -1; *encrypt = -1; documentStatus("Selection: S-E-\n"); break;
		case 'b': action= 3;				documentStatus("Selection: Shell\n"); break;
		default : action=-1;				documentStatus("Selection: quit\n");
	}
    }
  }
  else
  {
    documentStatus("with all-known keys, "); 
    if (*encrypt==1)
    {
      action = 1;
      documentStatus(" no menu (doing encryption)\n");
    }
    else
    {
      printf("You know all recipient keys. You may:\n"
             "a) Encrypt the message\nb) Send it unmodified\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'b','q'))
      {
    	case 'a': action= 1; *sign = -1; *encrypt =  1; documentStatus("Selection: S-E+\n"); break;
    	case 'b': action= 0; *sign = -1; *encrypt = -1; documentStatus("Selection: S-E-\n"); break;
        default : action=-1;				documentStatus("Selection: quit\n");      } 
    } 
  }
  return action;
}
int menu_askask(int *sign, int *encrypt, int unknownkeys) /* Menu 2 */
{
  int action;
  
  documentStatus("Presenting menu for ask sign/ask encrypt ");
  if (unknownkeys)
  {
    documentStatus("with unknown keys, ");
    printf("Your recipient list has unknown keys. You may:\n"
           "a) Sign the message\nb) Send it unmodified\n");    
    if (myUserPrefs->pgpVersion == 5 || myUserPrefs->pgpVersion == 1)
    {
      printf("c) Ask the Keyserver for unknown keys and start over\n"
             "d) Open a shell to add their key manually,\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'d','q'))
      {
    	case 'a': action= 1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
    	case 'b': action= 0; *sign = -1; *encrypt = -1; documentStatus("Selection: S-E-\n"); break;
    	case 'c': action= 2;				documentStatus("Selection: Ask\n");  break;
	case 'd': action= 3;				documentStatus("Selection: Shell\n"); break;
    	default : action=-1;				documentStatus("Selection: quit\n");
      }
    }
    else
    {
      printf("c) Open a shell to add their key manually,\nd) Abort and Quit\n\n"); 
      switch (askAlphaRange("Make your choice:",'c','q'))
      {
    	case 'a': action= 1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
    	case 'b': action= 0; *sign = -1; *encrypt = -1; documentStatus("Selection: S-E-\n"); break;
    	case 'c': action= 3;				documentStatus("Selection: Shell\n");  break;
    	default : action=-1;				documentStatus("Selection: quit\n"); 
      }
    }
  }
  else
  {
    documentStatus("with all-known keys, "); 
    printf("You know all recipient keys. You may:\n"
           "a) Sign and encrypt the message\nb) Sign the message\n"
           "c) Encrypt the message\nd) Send it unmodified\nq) Abort and Quit\n\n");
    switch (askAlphaRange("Make your choice:",'d','q'))
    {
    	case 'a': action=1; *sign =  1; *encrypt =  1; documentStatus("Selection: S+E+\n"); break;
	case 'b': action=1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
	case 'c': action=1; *sign = -1; *encrypt =  1; documentStatus("Selection: S-E+\n"); break;
	case 'd': action=0; *sign = -1; *encrypt = -1; documentStatus("Selection: S-E-\n"); break;
	default : action=-1;			       documentStatus("Selection: quit\n");
    }
  }
  return action;
}
int menu_askyes(int *sign, int *encrypt, int unknownkeys)  /* Menu 3 */
{  
  int action;

  documentStatus("Presenting menu for ask sign/do encrypt ");
  if (unknownkeys)
  {
    documentStatus("with unknown keys, ");
    printf("Your recipient list has unknown keys, you can not encrypt. You may:\n"
           "a) Only sign the message\nb) Send it unmodified\n");
    if (myUserPrefs->pgpVersion == 5 || myUserPrefs->pgpVersion == 1)
    {
      printf("c) Ask the Keyserver for unknown keys and start over\n"
             "d) Open a shell to add their key manually,\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'d','q'))
      {
    	case 'a': action= 1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
	case 'b': action= 0; *sign = -1; *encrypt = -1; documentStatus("Selection: S-E-\n"); break;
	case 'c': action= 2;				documentStatus("Selection: Ask\n");  break;
	case 'd': action= 3;				documentStatus("Selection: Shell\n"); break;
	default : action=-1;				documentStatus("Selection: quit\n");
      }
    }
    else
    {
      printf("c) Open a shell to add their key manually,\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'c','q'))
      {
    	case 'a': action= 1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
	case 'b': action= 0; *sign = -1; *encrypt = -1; documentStatus("Selection: S-E-\n"); break;
	case 'c': action= 3;				documentStatus("Selection: Shell\n");  break;
	default : action=-1;				documentStatus("Selection: quit\n");
      }
    }

  }
  else
  {
    documentStatus("with all-known keys, ");   
    printf("You know all recipient keys. You may:\n"
           "a) Sign and encrypt the message\nb) Encrypt the message\nq) Abort and Quit\n\n");
    switch (askAlphaRange("Make your choice:",'b','q'))
    {
    	case 'a': action=1; *sign =  1; *encrypt =  1; documentStatus("Selection: S+E+\n"); break;
	case 'b': action=1; *sign = -1; *encrypt =  1; documentStatus("Selection: S-E+\n"); break;
	default : action=-1;			       documentStatus("Selection: quit\n");
    }
  }
  return action;
}
int menu_yesask(int *sign, int *encrypt, int unknownkeys)  /* Menu 4 */
{
  int action;

  documentStatus("Presenting menu for do sign/ask encrypt ");
  if (unknownkeys)
  {
    documentStatus("with unknown keys, ");  
    printf("Your recipient list has unknown keys. You may:\n"
           "a) Sign the message\n");
    if (myUserPrefs->pgpVersion == 5 || myUserPrefs->pgpVersion == 1)
    {
      printf("b) Ask the Keyserver for unknown keys and start over\n"
             "c) Open a shell to add their key manually\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'c','q'))
      {
    	case 'a': action= 1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
    	case 'b': action= 2;				documentStatus("Selection: Ask\n");  break;
    	case 'c': action= 3;				documentStatus("Selection: Shell\n"); break;
	default : action=-1;				documentStatus("Selection: quit\n");
      }
    }
    else
    {
      printf("b) Open a shell to add their key manually\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'b','q'))
      {
    	case 'a': action= 1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
    	case 'b': action= 3;				documentStatus("Selection: Shell\n");  break;
    	default : action=-1;				documentStatus("Selection: quit\n");
      }
    }       
  }
  else
  {
    documentStatus("with all-known keys, ");   
    printf("You know all recipient keys. You may:\n"
           "a) Sign and encrypt the message\nb) Sign the message\nq) Abort and Quit\n\n");
    switch (askAlphaRange("Make your choice:",'b','q'))
    {
    	case 'a': action=1; *sign =  1; *encrypt =  1; documentStatus("Selection: S+E+\n"); break;
	case 'b': action=1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
    	default : action=-1;			       documentStatus("Selection: quit\n");
    }    
  }
  return action;
}
int menu_yesyes(int *sign, int *encrypt, int unknownkeys)  /* Menu 5 */
{
  int action;

  documentStatus("Presenting menu for do sign/do encrypt ");
  if (unknownkeys)
  {
    documentStatus("with unknown keys, ");  
    printf("Your recipient list has unknown keys, you can not encrypt. You may:\n"
           "a) Only sign the message\n");
    if (myUserPrefs->pgpVersion == 5 || myUserPrefs->pgpVersion == 1)
    {
      printf("b) Ask the Keyserver for unknown keys and start over\n"
             "c) Open a shell to add their key manually\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'c','q'))
      {
    	case 'a': action= 1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
    	case 'b': action= 2;				documentStatus("Selection: Ask\n");  break;
	case 'c': action= 3;				documentStatus("Selection: Shell\n");  break;
    	default : action=-1;				documentStatus("Selection: quit\n");    
      }
    }
    else
    {    
      printf("b) Open a shell to add their key manually\nq) Abort and Quit\n\n");
      switch (askAlphaRange("Make your choice:",'b','q'))
      {
    	case 'a': action= 1; *sign =  1; *encrypt = -1; documentStatus("Selection: S+E-\n"); break;
    	case 'b': action= 3;				documentStatus("Selection: Shell\n");  break;
    	default : action=-1;				documentStatus("Selection: quit\n");   
      }
    }
  }
  else
  {
    documentStatus("with all-known keys: ");
    printf("All keys are known. You may\na) Sign and encrypt the message\nq) Abort and Quit\n\n");
    if (askAlphaRange("Make your choice:",'a','q')=='a')
      { action=1; documentStatus("accepted\n");}
    else
      { action=-1;documentStatus("quit\n");}
  }
  return action;
}
// --------------------------------------------------------------------------------- 

int fileSignEncryptMenu(const char *inFile, char *outFile, char *recipients)
{
   // all of the pointer arguments above should be "safe" pointers, 
   // as they are given variables in main.c:main()
	
   int signFile,encryptFile,encryptToSelf=0,useASCIIArmor,useUniversalText,useDetachedSigs;
   char tmpList[EMAIL_ADDRESS_MAX_LENGTH];
   char keyrecipients[EMAIL_ADDRESS_MAX_LENGTH];
   char nokeyrecipients[EMAIL_ADDRESS_MAX_LENGTH];

   int  action=10; /* 10 is unused */
   int (*menu)(int *,int *,int);

   signFile = myUserPrefs->autoSign;
   encryptFile = myUserPrefs->autoEncrypt;

   printf("Your preset is: ");
   switch (signFile*3 + encryptFile)
   {
     case -4: printf("do nothing\n");		break;   // S-E-
     case -3: printf("don't sign\n");		break;   // S-E?
     case -2: printf("encrypt and no sign\n");	break;   // S-E+
     case -1: printf("don't encrypt\n");	break;   // S?E-
     case  0: printf("none\n");			break;   // S?E?
     case  1: printf("try to encrypt\n");	break;   // S?E+
     case  2: printf("sign and never encrypt\n"); break; // S+E-
     case  3: printf("always sign\n");		break;   // S+E?
     case  4: printf("sign + encrypt\n");	break;   // S+E+
   }

   do {	
        if ((signFile == -1) && (encryptFile == -1)) // Do nothing at all
   	/* Return 0 as a sign to send unmodified (message is still in infile, not tmpfile) */
	  return 0;

	// initialize recipients lists

	if (strlen(recipients) < 3 || prefsOverrideRecipients == 1) 
	{
		strcpy(recipients,"");
		printf("Please enter the recipients below. Type . by itself on it's own line to end.\n");
		do {
			scanf("%s",tmpList);
			// Using fgets seems to break the strcmp() below...
//			fgets(tmpList, EMAIL_ADDRESS_MAX_LENGTH, stdin);
			strcat(recipients,tmpList);
			strcat(recipients," ");
		} while (strcmp(tmpList,"."));
	}

	strcpy(keyrecipients,recipients); 
/* Leave recipients untouched, so we can rollover (after asking a keyserver) */

	strcpy(nokeyrecipients,"");

	if (signFile == -1)
	{
		gettheKeys();
		parseList(keyrecipients, nokeyrecipients);
	 	action=menu_noyes(&signFile,&encryptFile,(strlen(nokeyrecipients)>3)); 
		/* Menu 1 */
		menu_noyes(&signFile,&encryptFile,(strlen(nokeyrecipients)>3));
	}
	else
	{
		if (encryptFile == -1)
		{
	 		if (signFile == 0)  signFile = askInteger("Do you want to sign this file/message? ",1);
			if (signFile == -1) action=0; else action = 1; /* send or send and sign */
		}
		else
		{	/* Now get the keys and then select a menu to present */
			gettheKeys();
			parseList(keyrecipients, nokeyrecipients);
			if (signFile == 0)
			{
			  if (encryptFile == 0)
			    menu = menu_askask;
			  else
			    menu = menu_askyes;
			}
			else
			{
			  if (encryptFile == 0)
			    menu = menu_yesask;
			  else
			    menu = menu_yesyes;
			}
			action = menu(&signFile,&encryptFile,(strlen(nokeyrecipients)>3)); 
			/* Let the menu decide what action to take. It does also manipulate 
			   the s/e-choice from 0 to +/-1 */  
		}	
	}
	/* Now we have decided what to do: send with some flags, ask server and rollover, or abort */
	switch (action) 
	{
	  case 1: /* Send with flags */
		/* Get the rest of the parameters */
		useASCIIArmor = myUserPrefs->asciiArmor;
		if (useASCIIArmor == 0) useASCIIArmor = askInteger("Do you want to use ASCII (RADIX-64) armoring? ", 1);

		useUniversalText = myUserPrefs->universalText;	
		if (useUniversalText == 0) useUniversalText = askInteger("Do you want to use canonical (universal) text formatting? ",1);

		if (encryptFile > 0) 
		{
			myUserPrefs->detachedSig = -1; // can't detach signature when encrypting...
			encryptToSelf = myUserPrefs->encryptToSelf;
			if (encryptToSelf == 0) encryptToSelf = askInteger("Do you want to encrypt to yourself, too? ",1);
		}
		useDetachedSigs = myUserPrefs->detachedSig;
		if (useDetachedSigs == 0) useDetachedSigs = askInteger("Do you want to use a detached signature?",-1);

		if (fileSignEncrypt(inFile,outFile,signFile,encryptFile,keyrecipients,useASCIIArmor,useUniversalText,encryptToSelf,useDetachedSigs))
		{
		  printf("Error while encrypting ! Aborting now.\n");
		  action=-1;
		}
		waitForReturn();
		break;
	  case 2: /* Ask server */
		fileAskKey(nokeyrecipients);
		/* Get the public keys again, as they have (hopefully) changed */
		regetPublicKeyring();
		break;
	  case 3: /* Give me a shell */
	  	runProcessFG("/bin/sh");
		regetPublicKeyring();
		break;
	  case 0:  /* send unmodofied */
//	  	return 0;
		break;
	  case -1: /* Abort message */
//	  	return -1;
		break;
	  default: printf("Error: action=%d, menu selection went wrong !!\n",action);
	}
   } while ((action==2) || (action == 3)); /* repeat while we are adding keys */
   return action;	/* action is returnflag: -1,0,1 for abort, unmodified, modified */
}

