/* pgp4pine structs.h
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

/* ******************************************************* */

#ifndef STRUCTS_H
#define STRUCTS_H

#include "defines.h"

struct pkiKey {
	char emailAddress[EMAIL_ADDRESS_MAX_LENGTH];
	char displayName[EMAIL_ADDRESS_MAX_LENGTH];
	char keyID[KEY_ID_LENGTH];
	char keySize[KEY_SIZE_LENGTH];
	char keyType[KEY_TYPE_LENGTH];
	struct pkiKey *nextKey;
} pkiKeyStruct;

struct myProfile {
	char profileName[254];
	int pgpVersion; /* see pki.c for values */
	char extraOptions[MAX_COMMAND_LINE_LENGTH]; 
	int autoSign;	
	int autoEncrypt;
	int encryptToSelf;
	char myAddress[EMAIL_ADDRESS_MAX_LENGTH];
	int asciiArmor;
	int universalText;
	char myTmpFile[MAX_COMMAND_LINE_LENGTH];
		/* set to anything less than strlen(3) to turn off. */
	struct myProfile *nextProfile;
	int detachedSig;
	int cache_decrypted;
	char pgp5pgpk[MAX_COMMAND_LINE_LENGTH];
	char pgp5pgpe[MAX_COMMAND_LINE_LENGTH];
	char pgp5pgps[MAX_COMMAND_LINE_LENGTH];
	char pgp5pgpv[MAX_COMMAND_LINE_LENGTH];
	char pgp2pgp[MAX_COMMAND_LINE_LENGTH];
	char pgp1gpg[MAX_COMMAND_LINE_LENGTH];
} myProfileStruct;

/* struct cache_Entry {
	u_int16_t  magic;   0,1     = 0x1234 for structure integrity
	u_int32_t  size;    2,3,4,5 size header plus message
	u_int16_t  version; 6       header version
	u_int8_t   md5[16]; 7..22
	u_int32_t  date;    23,24,25,26 date (hours since 1970)
}; */
#endif

