/* pgp4pine debug.c - generate a debug file if needed
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* ------------------------------------------------------------ */

void openDebugFile()
{
	if (saveDebugFile) {
		char homeDir[MAX_COMMAND_LINE_LENGTH], debugFileName[MAX_COMMAND_LINE_LENGTH];
	
		/* Okay, first, let's get the rc file name ($HOME/.pgp4pinerc)	 */
		strncpy(homeDir,getenv("HOME"),MAX_COMMAND_LINE_LENGTH);
		if (!homeDir || !*homeDir) strcpy(homeDir,"/tmp"); /* STRCPY SAFE */
		sprintf(debugFileName,"%s/pgp4pine.debug",homeDir);
	
		if ((debugFile = fopen(debugFileName,"a")) == NULL) {
			if ((debugFile = fopen(debugFileName,"w")) == NULL) {
				printf("Debug file (%s) couldn't be opened... using stdrtt.\n",debugFileName);
				debugFile = stderr;
			}
		}
		if (debugFile != stderr)
			fprintf(debugFile,
			"\n---------------------------------------------------------------\n"
			"================= NEW SESSION version " VERSION " ===================\n"
			"---------------------------------------------------------------\n\n");
	}
}

void documentStatus(const char *status)
{
	if (!saveDebugFile) return;
	/* status is already either initialized/malloced, or is pure text...
	 * so, it's a (safe) pointer... */
	fputs(status,debugFile);
	fflush(debugFile);
}

void closeDebugFile()
{
 if (saveDebugFile) {
	  fflush(debugFile);
	  fclose(debugFile);
	}
}
