%define version 0.16.0

Summary: filters for pine for PGP 2.6.x, 5.x and 6.5.x and GnuPG
Name: pinepgp
Version: %{version}
Release: 1
Copyright: GPL
BuildArchitectures: noarch
Group: Applications/Internet
Url: http://www.megaloman.com/~hany/software/pinepgp/
Vendor: Peter Hanecak <hanecak@megaloman.sk>
Source0: http://www.megaloman.com/~hany/_data/pinepgp/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Prefix: {_prefix}

%description
PGP and GnuPG filters for pine. PGP versions 2.6.x, 5.x and 6.5.x are supported.

To use them you have to install one or more of the following packages:

	pinegpg-%{version}
	pinepgp26x-%{version}
	pinepgp5x-%{version}
	pinepgp65x-%{version}


%package -n pinepgp26x
Summary: filters for pine for PGP 2.6.x
Group: Applications/Internet
Requires: pgp < 2.7, mktemp, pinepgp = %{version}

%description -n pinepgp26x
PGP 2.6.x filters for pine.

To use it run 'pinepgp26x-install' installation script in %{_prefix}/bin directory.

%package -n pinepgp5x
Summary: filters for pine for PGP 5.x
Group: Applications/Internet
Requires: pgp < 6.0.0, mktemp, pinepgp = %{version}
Conflicts: pgp < 5

%description -n pinepgp5x
PGP 5.x filters for pine.

To use it run 'pinepgp5x-install' installation script in %{_prefix}/bin directory.

%package -n pinepgp65x
Summary: filters for pine for PGP 6.5.x
Group: Applications/Internet
Requires: pgp6 >= 6.5.0, mktemp, pinepgp = %{version}

%description -n pinepgp65x
PGP 6.5.x filters for pine.

To use it run 'pinepgp65x-install' installation script in %{_prefix}/bin directory.

%package -n pinegpg
Summary: filters for pine for GnuPG
Group: Applications/Internet
Requires: gnupg, mktemp, /bin/awk, pinepgp = %{version}

%description -n pinegpg
GnuPG filters for pine.

To use it run 'pinegpg-install' installation script in %{_prefix}/bin directory.

%prep
%setup

%build
%configure \
	--with-gpg=%{_bindir}/gpg \
	--with-pgp=%{_bindir}/pgp \
	--with-pgp5=%{_bindir}/pgp \
	--with-pgp6=%{_bindir}/pgp6
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(0644, root, root, 0755)
%doc COPYING ChangeLog README
%attr(0755, root, root) %{_prefix}/bin/pinepgpgpg-install

%files -n pinepgp26x
%defattr(0644, root, root, 0755)
%attr(0755, root, root) %{_prefix}/bin/pinepgp26x-install
%attr(0755, root, root) %{_prefix}/bin/pinepgp26x
%attr(0755, root, root) %{_prefix}/bin/pgp26x-sign
%attr(0755, root, root) %{_prefix}/bin/pgp26x-sign+encrypt
%attr(0755, root, root) %{_prefix}/bin/pgp26x-encrypt
%attr(0755, root, root) %{_prefix}/bin/pgp26x-check

%files -n pinepgp5x
%defattr(0644, root, root, 0755)
%attr(0755, root, root) %{_prefix}/bin/pinepgp5x-install
%attr(0755, root, root) %{_prefix}/bin/pinepgp5x
%attr(0755, root, root) %{_prefix}/bin/pgp5x-sign
%attr(0755, root, root) %{_prefix}/bin/pgp5x-sign+encrypt
%attr(0755, root, root) %{_prefix}/bin/pgp5x-encrypt
%attr(0755, root, root) %{_prefix}/bin/pgp5x-check

%files -n pinepgp65x
%defattr(0644, root, root, 0755)
%attr(0755, root, root) %{_prefix}/bin/pinepgp65x-install
%attr(0755, root, root) %{_prefix}/bin/pinepgp65x
%attr(0755, root, root) %{_prefix}/bin/pgp65x-sign
%attr(0755, root, root) %{_prefix}/bin/pgp65x-sign+encrypt
%attr(0755, root, root) %{_prefix}/bin/pgp65x-encrypt
%attr(0755, root, root) %{_prefix}/bin/pgp65x-check

%files -n pinegpg
%defattr(0644, root, root, 0755)
%attr(0755, root, root) %{_prefix}/bin/pinegpg-install
%attr(0755, root, root) %{_prefix}/bin/pinegpg
%attr(0755, root, root) %{_prefix}/bin/gpg-sign
%attr(0755, root, root) %{_prefix}/bin/gpg-sign+encrypt
%attr(0755, root, root) %{_prefix}/bin/gpg-encrypt
%attr(0755, root, root) %{_prefix}/bin/gpg-check

%changelog
* Tue Jul 10 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.16.0-1]
- README:
  - added info about my public key
  - added section "Other Resources"
  - TODO items for next devel version added
  - minor fixes and updates

* Fri Jun  8 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.15.4-1]
- Makefile.in:
  - reworked install process so only required items are installed; thus
    no errors will be produced when installing filters which were not required
  - fixed missing exec_prefix
- pinegpgp.in: removed "recode" sed command - looks like it is not necessery
  anymore
- README: additions to 'TODO' section regarding S/MIME x.509

* Fri Jan 12 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.15.3-1]
- pinegpgp.in: fixed "recode" sed command - it was dropping "r"s from
  decrypted and/or checked messages when using GnuPG support (try to drop it   
  in the future - looks like it is not necessery anymore);
  thanks to phuzzie <phuzzie@phuzzielogik.cx> for reporting it
- documentation: updates and fixes

* Thu Jan 11 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.15.2-1]
- added support for encrypting to multiple recipients
  (Jon Wilson <jon@netsw.co.uk>)
- added encrypting to yourself to previous
  (Scott C. Wood <woody@netsw.co.uk>)
- filter configuration in .pinerc changed so users which are upgrading
  HAVE TO run particular install script again
- pinegpg: use sed instead of awk
- changed temp directory: ~/.pinepgp; it is created by install scripts
  if it does not exists
- README: updated and slightl;y restructured (Install and Usage part)

* Thu Jan 11 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.15.1-1]
- filters are build from one source

* Thu Jan 11 2001 Peter Hanecak <hanecak@megaloman.sk>
[0.15.0-1]
- autoconf used

* Tue Oct  3 2000 Peter Hanecak <hanecak@megaloman.sk>
[0.14.0-1]
- stable release
- spec: %%{_prefix} and Prefix: used

* Thu Sep 14 2000 Peter Hanecak <hanecak@megaloman.sk>
[0.13.2-1]
- do not produce footer when there is no output from pgp/gpg to stderr when
  checking incoming message (i.e. decrypting and/or checking signature)
- spec improvements

* Mon Mar 27 2000 Peter Hanecak <hanecak@megaloman.sk>
- README: mktem RPM package URL added
- README: information about change of bin directory rewritten (prefix or
  bindir used)
- Makefile: default prefix changed back to '/usr/local'
- scripts: /bin/bash -> /bin/sh
- README: info about pine's compose-send-offers-first-filter

* Thu Mar 23 2000 Peter Hanecak <hanecak@megaloman.sk>
- documentation extended
- vendor tag added to spec

* Wed Mar 22 2000 Martin Edas Edlman <edlman@dzungle.ms.mff.cuni.cz>
- change back _BEGINNING to _LEADING in Pine display filters. I have realized
  that the -----BEGIN PGP [SIGNED] MESSAGE-- must be very first line in the
  signed and/or encrypted message, otherwise Pine call PGP/GnuPG to verify all
  messages containing this line, which is bad e.g. for replies containing
  this line somewhere in the middle of the message body. PGP/GnuPG
  displays only verified/decrypted part of the message, not whole, and it
  complains that the signature is bad. Surely.
- requirements slightly corrected
- pinepgpgpg-install attributes fixed

* Tue Mar 21 2000 Peter Hanecak <hanecak@megaloman.sk>
- added PGP 6.5.x filter
  (Martin Edas Edlman <edlman@dzungle.ms.mff.cuni.cz>)
- requirement od pinegpg changed: openpgp -> gnupg

* Tue Mar 21 2000 Peter Hanecak <hanecak@megaloman.sk>
- added Url to spec
- split package into more parts based on crypto tool used; also
  dependencies added to new packages
  (Martin Edas Edlman <edlman@dzungle.ms.mff.cuni.cz>)
- added documentation
- 'make tarball', 'make rebuild' and 'make clean'
- pinepgp50 renamed to pinepgp5x so it is more "obvious" that even PGP 5.5
  works (Martin Edas Edlman <edlman@dzungle.ms.mff.cuni.cz>)
- 'make install-pgp26x', 'make install-pgp5x' and 'make install-gpg'

* Fri Mar 17 2000 Peter Hanecak <hanecak@megaloman.sk>
- package summary info corrections
- spec: %make -> %build

* Fri Mar 17 2000 Martin Edas Edlman <edlman@dzungle.ms.mff.cuni.cz>
- everything - scripts and links to them - is packed in tar.gz archive
  so it's transportable to other systems, not only for those with RPM.
- change of this spec file to reflect new format.

* Thu Mar 16 2000 Martin Edas Edlman <edlman@dzungle.ms.mff.cuni.cz>
- release 0.11-3
- change of _LEADING to _BEGINNING in the Pine display filter definitions,
  it should work with mails where -----BEGIN PGP ... is not the first
  whitespace line (see Pine help for details)
- fix of pinepgp{26x,50}-install script - sed expression was enclosed in
  quotes (') and thus shell variabled were not evaluated. Not it is enclosed
  in double qoutes (") and it's ok; $PGPVER variable was not set sometime,
  there was problem with 'case' evaluation, '*' at the beginning of program
  names was missing and the line was matched only when $0 was exactly the
  same as the program name.

* Thu Mar 16 2000 Martin Edas Edlman <edlman@dzungle.ms.mff.cuni.cz>
- release 0.11-2
- fix of this spec file - after adding GPG, pgp50-sign+encrypt was badly
  linked
- fix of pinepgp50 and pinepgp26x scripts. In 'case' structures there were
  wrong filenames to determine how the script was called.
- links are done after install on final filesystem (hardlinks instead of
  symlinks)

* Sat Sep 11 1999 Peter Hanecak <hanecak@megaloman.sk>
- added support for GPG
- install scripts use full path to scripts
  (pine, according to tech-notes.txt, requires it)

* Sun Jul 4 1999 Peter Soos <sp@osb.hu>
- Added pgp 5.0 support

* Wed May 12 1999 Peter Soos <sp@osb.hu>
- Corrected the file and directory attributes to rebuild the package
  under RedHat Linux 6.0

* Fri Dec 25 1998 Peter Soos <sp@osb.hu>
- Corrected the file and directory attributes

* Wed Jun 24 1998 Peter Soos <sp@osb.hu>
- Using %attr to build the package as an ordinary user

* Tue Dec 9 1997 Peter Soos <sp@osb.hu>
- Recompiled under RedHat Linux 5.0
- Now we use BuildRoot

