# OpenCA RPM File
# (c) 2006 by Massimiliano Pala and OpenCA Team
# OpenCA Licensed Software

%define __find_requires %{nil}
%define debug_package %{nil}

# %define _unpackaged_files_terminate_build 0
# %define _missing_doc_files_terminate_build 0

# Basic Definitions
%define httpd_usr apache
%define httpd_grp apache
%define nobody    nobody
%define nogroup   nobody
%define openca_usr root
%define openca_grp nobody

%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora %(test -e /etc/fedora-release && echo 1 || echo 0)

%define dist redhat
%define disttag rh

%if %is_mandrake
%define dist mandrake
%define disttag mdk
%endif
%if %is_suse
%define dist suse
%define disttag suse
%define nogroup nogroup
%define httpd_usr wwwwrun
%define httpd_grp nogroup
%endif
%if %is_fedora
%define dist fedora
%define disttag rhfc
%endif

%define distver %(release="`rpm -q --queryformat='%{VERSION}' %{dist}-release 2> /dev/null | tr . : | sed s/://g`" ; if test $? != 0 ; then release="" ; fi ; echo "$release")
%define packer %(finger -lp `echo "$USER"` | head -n 1 | cut -d ' ' -f 2)

%define ver      	0.9.3
%define RELEASE 	rc1
%define rel     	%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix   	/var/openca
%define mand		/var/openca/man
%define sslprefix	/usr
%define openssl_req 	0.9.7
%define openldap_req 	2.2
%define openca_tools_req 1.0.0
%define openca_common_req 0.9.3

Summary: OpenCA
Name: openca
Version: %ver
Release: %rel.%{disttag}%{distver}
License: OpenCA License (BSD Style)
Group: Security/PKI
Source: openca-%{ver}.tar.gz
Packager:  %packer
Vendor: OpenCA Labs
BuildRoot: /var/tmp/openca-%{ver}-root
URL: http://www.openca.org/
Docdir: %{prefix}/doc
Prefix: %prefix

%description
The OpenCA package implements a full featured Certification Authority
to issue and managed digital certificates.

%define openca_prefix	%{prefix}
%define httpd_fs_prefix %{prefix}/www
%define openssl_prefix /usr

%package common
Summary: Basic Components for OpenCA
Group: Security/PKI
AutoReq: no
Requires: openssl >= %openssl_req openca-tools >= %openca_tools_req

%description common

%package ca
Summary: CA Components for OpenCA
Group: Security/PKI
Requires: openca-common >= %openca_common_req

%description ca

%package bp
Summary: Batch Components for OpenCA
Group: Security/PKI
Requires: openca-common >= %openca_common_req

%description bp

%package ldap
Summary: LDAP Components for OpenCA
Group: Security/PKI
Requires: openca-common >= %openca_common_req

%description ldap

%package pub
Summary: Pub Components for OpenCA
Group: Security/PKI
Requires: openca-common >= %openca_common_req

%description pub

%package ra
Summary: RA Components for OpenCA
Group: Security/PKI
Requires: openca-common >= %openca_common_req

%description ra

%package scep
Summary: SCEP Components for OpenCA
Group: Security/PKI
Requires: openca-common >= %openca_common_req

%description scep

%prep
#echo %_target
#echo %_target_alias
#echo %_target_cpu
#echo %_target_os
#echo %_target_vendor

echo Building %{name}-%{version}-%{release}

%setup -q -n %{name}-%{version}

if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh
fi

./configure \
  --with-engine=no \
  --prefix=%{prefix} \
  --with-build-dir=${RPM_BUILD_ROOT} / \
  --with-openca-prefix=%{openca_prefix} \
  --with-httpd-user=%{httpd_usr} \
  --with-httpd-group=%{httpd_grp} \
  --with-openca-user=%{openca_usr} \
  --with-openca-group=%{openca_grp} \
  --with-httpd-fs-prefix=%{httpd_fs_prefix} \
  --with-cgi-url-prefix=/cgi-bin \
  --with-web-host=localhost \
  --with-ca-organization="OpenCA PKI Services" \
  --with-ca-country=IT \
  --with-ldap-port=389 \
  --with-ldap-root="cn=Manager,o=OpenCA,c=IT" \
  --with-ldap-root-pwd="openca" \
  --with-module-prefix=%{openca_prefix}/perl-modules \
  --with-openssl-prefix=%{openssl_prefix} \
  --disable-db \
  --enable-dbi \
  --enable-rbac \
  --enable-openscep \
  --with-db-type=mysql \
  --with-db-name=openca \
  --with-db-host=localhost \
  --with-db-port=3306 \
  --with-db-user=openca \
  --with-db-passwd="openca" \
  --with-service-mail-account="pki@openca.org" \
  --enable-package-build \
  --with-language=en_EN

##  --with-openssl-engine=LunaCA3 \
##  --with-hsm-utility=/usr/luna/bin/ca3util \
##  --with-hsm-slot=1 \
##  --with-hsm-appid=10:11 \
# CFLAGS="$RPM_OPT_FLAGS" sh configs/configure.pkg.ca_@SEXT@ "$RPM_BUILD_ROOT"

%build

make

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make install-common install-modules install-ca install-batch install-ldap install-pub install-ra install-scep install-node

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files common
%defattr(-, -, -)

%{prefix}/bin/*
%{openca_prefix}/etc/loa.xml
%{openca_prefix}/etc/log.xml
%{openca_prefix}/etc/token.xml
%{openca_prefix}/etc/config.xml
%{openca_prefix}/etc/ldap.xml.template
%{openca_prefix}/etc/menu.xml.template
%{openca_prefix}/etc/backup.xml.template
%{openca_prefix}/etc/configure_etc.sh
%{openca_prefix}/etc/openca_rc
%{openca_prefix}/etc/openca_start.template
%{openca_prefix}/etc/openca_stop.template
%{openca_prefix}/etc/utf8_latin1_selector.sh.template
%{openca_prefix}/etc/bp/*
%{openca_prefix}/etc/database/*
%{openca_prefix}/etc/openssl/*
%{openca_prefix}/etc/rbac/*
%{openca_prefix}/lib/*
%{openca_prefix}/var/bp/*
%{openca_prefix}/var/mail/*
%{openca_prefix}/perl-modules/*
%{openca_prefix}/etc/access_control/node.xml.template
%{openca_prefix}/etc/servers/node.conf.template
%{openca_prefix}/etc/servers/common.conf
%{httpd_fs_prefix}/htdocs/node/*
%{httpd_fs_prefix}/cgi-bin/node/*

%defattr( -, %{httpd_usr}, %{httpd_grp})

%dir %{openca_prefix}/var/log
%dir %{openca_prefix}/var/crypto
%dir %{openca_prefix}/var/crypto/cacerts
%dir %{openca_prefix}/var/crypto/chain
%dir %{openca_prefix}/var/crypto/certs
%dir %{openca_prefix}/var/crypto/keys
%dir %{openca_prefix}/var/crypto/reqs
%dir %{openca_prefix}/var/tmp
%dir %{openca_prefix}/var/db

%{openca_prefix}/var/crypto/cacerts/*
%{openca_prefix}/var/crypto/chain/*
%{openca_prefix}/var/crypto/crlnumber
%{openca_prefix}/var/crypto/index.txt
%{openca_prefix}/var/crypto/keys/bp_key.pem
%{openca_prefix}/var/crypto/keys/keybackup_key.pem
%{openca_prefix}/var/crypto/keys/log_key.pem
%{openca_prefix}/var/crypto/serial
%{openca_prefix}/var/log/*

%files ca
%defattr(-, -, -)

%{httpd_fs_prefix}/htdocs/ca/*
%{httpd_fs_prefix}/cgi-bin/ca/*
%{openca_prefix}/var/session/cookie/ca
%{openca_prefix}/etc/access_control/ca.xml.template
%{openca_prefix}/etc/servers/ca.conf.template

%files bp
%defattr(-, -, -)

%{httpd_fs_prefix}/htdocs/batch/*
%{httpd_fs_prefix}/cgi-bin/batch/*
%{openca_prefix}/var/session/cookie/batch
%{openca_prefix}/etc/access_control/batch.xml.template
%{openca_prefix}/etc/servers/batch.conf.template

%files ldap
%defattr(-, -, -)

%{httpd_fs_prefix}/htdocs/ldap/*
%{httpd_fs_prefix}/cgi-bin/ldap/*
%dir %{openca_prefix}/var/session/cookie/ldap
%{openca_prefix}/etc/access_control/ldap.xml.template
%{openca_prefix}/etc/servers/ldap.conf.template

%files pub
%defattr(-, -, -)

%{httpd_fs_prefix}/htdocs/pub/*
%{httpd_fs_prefix}/cgi-bin/pub/*
%{openca_prefix}/var/session/cookie/pub
%{openca_prefix}/etc/access_control/pub.xml.template
%{openca_prefix}/etc/servers/pub.conf.template


%files ra
%defattr(-, -, -)

%{httpd_fs_prefix}/htdocs/ra/*
%{httpd_fs_prefix}/cgi-bin/ra/*
%{openca_prefix}/var/session/cookie/ra
%{openca_prefix}/etc/access_control/ra.xml.template
%{openca_prefix}/etc/servers/ra.conf.template


%files scep
%defattr(-, -, -)

%{httpd_fs_prefix}/cgi-bin/scep/*
%{openca_prefix}/var/session/cookie/scep
%{openca_prefix}/etc/access_control/scep.xml.template
%{openca_prefix}/etc/servers/scep.conf.template

%post

%post ca

echo
echo "Entering POST Install Configuration of OpenCA..."
cd %{openca_prefix}/etc && sh configure_etc.sh CA
echo "Done."

%post ra

echo
echo "Entering POST Install Configuration of OpenCA..."
cd %{openca_prefix}/etc && sh configure_etc.sh RA
echo "Done."

%post pub

echo
echo "Entering POST Install Configuration of OpenCA..."
cd %{openca_prefix}/etc && sh configure_etc.sh Pub
echo "Done."

%post ldap

echo
echo "Entering POST Install Configuration of OpenCA..."
cd %{openca_prefix}/etc && sh configure_etc.sh LDAP
echo "Done."

%post scep

echo
echo "Entering POST Install Configuration of OpenCA..."
cd %{openca_prefix}/etc && sh configure_etc.sh SCEP
echo "Done."

%post bp

echo
echo "Entering POST Install Configuration of OpenCA..."
cd %{openca_prefix}/etc && sh configure_etc.sh BP
echo "Done."

%post common

echo
echo -n "Linking startup script (openca) in init.d/ dir ... "
ln -s %{openca_prefix}/etc/openca_rc /etc/init.d/openca
echo "Done."

%postun common

echo "Removing init.d/openca link ... "
rm -f /etc/init.d/openca
echo "Done."

echo -n "Removing empty directories ... "
rmdir %{prefix}/bin 2>/dev/null
rmdir %{openca_prefix}/perl-modules 2>/dev/null
rm -rf %{openca_prefix}/lib/mails/* 2>/dev/null
rmdir %{openca_prefix}/lib/mails 2>/dev/null
rmdir %{openca_prefix}/lib 2>/dev/null
echo "Done."

echo
echo "Please check the %{prefix} directory for remaining files."
echo


%changelog
* Mon Sep 18 2006 Massimiliano Pala <madwolf@openca.org>
-First Packaging for OpenCA-Base

