#!/bin/sh
## this is a bash script
## perhaps it works with other shells too but no warranty

## Written by Michael Bell for the OpenCA project 2004
## (c) Copyright 2004 The OpenCA Project. All rights reserved.

set -e

prefix=/var/openca
exec_prefix=/var/openca
cf_mod=`stat -c %Y /var/openca/etc/config.xml`

for DIRECTORY in /var/openca/etc /var/openca/lib /var/openca/www/htdocs/ca /var/openca/www/htdocs/ra /var/openca/www/htdocs/node /var/openca/www/htdocs/ldap /var/openca/www/htdocs/pub /var/openca/www/htdocs/batch
do
    if test -d $DIRECTORY; then
        echo =================================================================
        echo fixing directory: $DIRECTORY
        echo =================================================================

        cd $DIRECTORY
        TEMPLATES=`find . -name "*.template" -print`
        for H in $TEMPLATES
        do
            echo -------------begin file-----------------
            echo template: $H
            H_RESULT=`echo $H | sed 's/\.template//'`
            echo target:   $H_RESULT
	    if ! [ -f "$H_RESULT" ] ; then 
		temp_mod=0
	    else
	    	temp_mod=`stat -c %Y $H_RESULT`
	    fi
            if [ "$cf_mod" -gt "$temp_mod" ] ; then
                echo status:   To be updated
            	${exec_prefix}/bin/openca-configure /var/openca/etc/config.xml $H $H_RESULT
            else
                echo status:   Updated
            fi
            echo --------------end file------------------
        done
    fi
done

# By this moment configure_etc.sh has successfully inserted the value of
# option cert_chars from config.xml into utf8_latin1_selector.sh 
# and we can call the latter from here, performing an effective reqursion:

/var/openca/etc/utf8_latin1_selector.sh

