
use Test;
BEGIN { plan tests => 22 };

use OpenCA::OpenSSL;
use OpenCA::X509;
use OpenCA::CRL;
use OpenCA::REQ;
use OpenCA::DB;

ok(1);

if (not chdir "test")
{
    ok(0);
} else {
    ok(1);
}

my $shell = ( $ENV{OPENSSL} or "/usr/bin/openssl" );
my $cnf   = ( $ENV{OPENSSL_CONFIG} or "/usr/ssl/openssl.cnf");

my $openssl = new OpenCA::OpenSSL( SHELL=>$shell, CONFIG=> $cnf, GETTEXT => \&gettext );
if (not $openssl)
{
    print STDERR "Error $OpenCA::OpenSSL::errno: $OpenCA::OpenSSL::errval\n";
    ok(0);
} else {
    ok(1);
}
my $db = new OpenCA::DB( SHELL=>$openssl, GETTEXT => \&gettext, DB_DIR=>"db" );
if( not $db )
{
    print STDERR "Error $OpenCA::DB::errno: $OpenCA::DB::errval\n";
    ok(0);
} else {
    ok(1);
}

my @certs = ( "data/03.pem" , "data/04.pem", "data/01.pem" );
my @status = ( "VALID","EXPIRED","REVOKED" );

my ( $x509, $st );

foreach $st (@status) {
	foreach $file (@certs) {
		$x509 = new OpenCA::X509( SHELL=>$openssl, GETTEXT => \&gettext, INFILE=>"$file" );
		if ( not $x509 ) {
                        print STDERR "Error $OpenCA::X509::errno: $OpenCA::X509::errval\n";
			ok(0);
		} else {
                        ok (1);
                }
		if ( not $db->storeItem( OBJECT=>$x509, 
					DATATYPE=>"${st}_CERTIFICATE" )) {
                        print STDERR "Error ".$db->errno.": ".$db->errval."\n";
			ok(0);
		} else {
                        ok (1);
                }
	}
}

sub gettext
{
    return $_[0];
}

1;
