
use Test;
BEGIN { plan tests => 7, todo => [5,6,7] };

use OpenCA::OpenSSL;
use OpenCA::X509;
use OpenCA::CRL;
use OpenCA::REQ;
use OpenCA::DB;

ok(1);

if (not chdir "test")
{
    ok(0);
} else {
    ok(1);
}

my $shell = ( $ENV{OPENSSL} or "/usr/bin/openssl" );
my $cnf   = ( $ENV{OPENSSL_CONFIG} or "/usr/ssl/openssl.cnf");

my $openssl = new OpenCA::OpenSSL( SHELL=>$shell, CONFIG=> $cnf, GETTEXT => \&gettext );
if (not $openssl)
{
    print STDERR "Error $OpenCA::OpenSSL::errno: $OpenCA::OpenSSL::errval\n";
    ok(0);
} else {
    ok(1);
}
my $db = new OpenCA::DB( SHELL=>$openssl, GETTEXT => \&gettext, DB_DIR=>"db" );
if( not $db )
{
    print STDERR "Error $OpenCA::DB::errno: $OpenCA::DB::errval\n";
    ok(0);
} else {
    ok(1);
}

ok (scalar @{$db->searchItems( DATATYPE=>"VALID_CERTIFICATE",
			       "EMAIL" => "madwolf\@openca.org")}, 1);
ok (scalar @{$db->searchItems( DATATYPE=>"VALID_CERTIFICATE",
			       "CN" => "Massimiliano Pala")}, 1);
ok (scalar @{$db->searchItems( DATATYPE=>"VALID_CERTIFICATE",
			       "O" => "OpenCA")}, 1);

sub gettext
{
    return $_[0];
}

1;
