
use Test;
BEGIN { plan tests => 13, todo => [5,6,7] };

use OpenCA::OpenSSL;
use OpenCA::X509;
use OpenCA::CRL;
use OpenCA::REQ;
use OpenCA::DB;

ok(1);

if (not chdir "test")
{
    ok(0);
} else {
    ok(1);
}

my $shell = ( $ENV{OPENSSL} or "/usr/bin/openssl" );
my $cnf   = ( $ENV{OPENSSL_CONFIG} or "/usr/ssl/openssl.cnf");

my $openssl = new OpenCA::OpenSSL( SHELL=>$shell, CONFIG=> $cnf, GETTEXT => \&gettext );
if (not $openssl)
{
    print STDERR "Error $OpenCA::OpenSSL::errno: $OpenCA::OpenSSL::errval\n";
    ok(0);
} else {
    ok(1);
}
my $db = new OpenCA::DB( SHELL=>$openssl, GETTEXT => \&gettext, DB_DIR=>"db" );
if( not $db )
{
    print STDERR "Error $OpenCA::DB::errno: $OpenCA::DB::errval\n";
    ok(0);
} else {
    ok(1);
}

my $req;

## tests 4-7
$req = new OpenCA::REQ( SHELL   => $openssl,
                        GETTEXT => \&gettext,
                        INFILE  => "data/req.pem" );
ok ($req);
ok ($db->storeItem( OBJECT=>$req, DATATYPE=>"PENDING_REQUEST" ));
ok ($db->storeItem( OBJECT=>$req, DATATYPE=>"APPROVED_REQUEST" ));
ok ($db->storeItem( OBJECT=>$req, DATATYPE=>"DELETED_REQUEST" ));

## tests 8-12
$req = new OpenCA::REQ( SHELL   => $openssl,
                        GETTEXT => \&gettext,
                        INFILE  => "data/req_32212.spkac" );
ok ($req);
ok ($req->getSerial(), 32212);
ok ($db->storeItem( OBJECT=>$req, DATATYPE=>"PENDING_REQUEST" ));
ok ($db->storeItem( OBJECT=>$req, DATATYPE=>"APPROVED_REQUEST" ));
ok ($db->storeItem( OBJECT=>$req, DATATYPE=>"DELETED_REQUEST" ));

sub gettext
{
    return $_[0];
}

1;
