
use Test;
BEGIN { plan tests => 16, todo => [5, 9] };

use OpenCA::OpenSSL;
use OpenCA::X509;
use OpenCA::CRL;
use OpenCA::REQ;
use OpenCA::DB;

ok(1);

if (not chdir "test")
{
    ok(0);
} else {
    ok(1);
}

my $shell = ( $ENV{OPENSSL} or "/usr/bin/openssl" );
my $cnf   = ( $ENV{OPENSSL_CONFIG} or "/usr/ssl/openssl.cnf");

my $openssl = new OpenCA::OpenSSL( SHELL=>$shell, CONFIG=> $cnf, GETTEXT => \&gettext );
if (not $openssl)
{
    print STDERR "Error $OpenCA::OpenSSL::errno: $OpenCA::OpenSSL::errval\n";
    ok(0);
} else {
    ok(1);
}
my $db = new OpenCA::DB( SHELL=>$openssl, GETTEXT => \&gettext, DB_DIR=>"db" );
if( not $db )
{
    print STDERR "Error $OpenCA::DB::errno: $OpenCA::DB::errval\n";
    ok(0);
} else {
    ok(1);
}

## test 5-8
ok ($db->elements( DATATYPE=>"PENDING_REQUEST" ), 0);
ok (scalar @{$db->listItems( DATATYPE=>"PENDING_REQUEST", FROM=>4)}, 0);
ok (scalar @{$db->listItems( DATATYPE=>"PENDING_REQUEST", ITEMS=>2)}, 0);
ok (scalar @{$db->listItems( DATATYPE=>"PENDING_REQUEST", ITEMS=>1, FROM=>3)}, 0);

## test 9-12
ok ($db->elements( DATATYPE=>"APPROVED_REQUEST" ), 0);
ok (scalar @{$db->listItems( DATATYPE=>"APPROVED_REQUEST", FROM=>4)}, 0);
ok (scalar @{$db->listItems( DATATYPE=>"APPROVED_REQUEST", ITEMS=>2)}, 0);
ok (scalar @{$db->listItems( DATATYPE=>"APPROVED_REQUEST", ITEMS=>1, FROM=>3)}, 0);

## 13-16
ok ($db->elements( DATATYPE=>"DELETED_REQUEST" ), 2);
ok (scalar @{$db->listItems( DATATYPE=>"DELETED_REQUEST", FROM=>4)}, 0);
ok (scalar @{$db->listItems( DATATYPE=>"DELETED_REQUEST", ITEMS=>2)}, 0);
ok (scalar @{$db->listItems( DATATYPE=>"DELETED_REQUEST", ITEMS=>1, FROM=>3)}, 0);

sub gettext
{
    return $_[0];
}

1;
