
use Test;
BEGIN { plan tests => 15, todo => [5,8,11] };

use OpenCA::OpenSSL;
use OpenCA::X509;
use OpenCA::CRL;
use OpenCA::REQ;
use OpenCA::DB;

ok(1);

if (not chdir "test")
{
    ok(0);
} else {
    ok(1);
}

my $shell = ( $ENV{OPENSSL} or "/usr/bin/openssl" );
my $cnf   = ( $ENV{OPENSSL_CONFIG} or "/usr/ssl/openssl.cnf");

my $openssl = new OpenCA::OpenSSL( SHELL=>$shell, CONFIG=> $cnf, GETTEXT => \&gettext );
if (not $openssl)
{
    print STDERR "Error $OpenCA::OpenSSL::errno: $OpenCA::OpenSSL::errval\n";
    ok(0);
} else {
    ok(1);
}
my $db = new OpenCA::DB( SHELL=>$openssl, GETTEXT => \&gettext, DB_DIR=>"db" );
if( not $db )
{
    print STDERR "Error $OpenCA::DB::errno: $OpenCA::DB::errval\n";
    ok(0);
} else {
    ok(1);
}

my $req;

## tests 5-7
ok ($db->elements( DATATYPE=>"PENDING_REQUEST" ), 0);
ok (not $db->getItem( DATATYPE=>"PENDING_REQUEST", KEY=>32212 ));
ok (not $db->deleteItem( DATATYPE=>"PENDING_REQUEST", KEY=>212 ));

## tests 8-11
ok ($db->elements( DATATYPE=>"APPROVED_REQUEST" ), 0);
ok (not $db->getItem( DATATYPE=>"APPROVED_REQUEST", KEY=>32212 ));
ok (not $db->deleteItem( DATATYPE=>"APPROVED_REQUEST", KEY=>212 ));
ok ($db->elements( DATATYPE=>"APPROVED_REQUEST" ), 0);

## tests 12-15
ok ($db->elements( DATATYPE=>"DELETED_REQUEST" ), 2);
ok ($db->deleteItem( DATATYPE=>"DELETED_REQUEST", KEY=>32212 ));
ok (not $db->deleteItem( DATATYPE=>"DELETED_REQUEST", KEY=>212 ));
ok ($db->elements( DATATYPE=>"DELETED_REQUEST" ), 1);

sub gettext
{
    return $_[0];
}

1;
