
use Test;
BEGIN { plan tests => 10, todo => [5,10] };

use OpenCA::OpenSSL;
use OpenCA::X509;
use OpenCA::CRL;
use OpenCA::REQ;
use OpenCA::DB;

ok(1);

if (not chdir "test")
{
    ok(0);
} else {
    ok(1);
}

my $shell = ( $ENV{OPENSSL} or "/usr/bin/openssl" );
my $cnf   = ( $ENV{OPENSSL_CONFIG} or "/usr/ssl/openssl.cnf");

my $openssl = new OpenCA::OpenSSL( SHELL=>$shell, CONFIG=> $cnf, GETTEXT => \&gettext );
if (not $openssl)
{
    print STDERR "Error $OpenCA::OpenSSL::errno: $OpenCA::OpenSSL::errval\n";
    ok(0);
} else {
    ok(1);
}
my $db = new OpenCA::DB( SHELL=>$openssl, GETTEXT => \&gettext, DB_DIR=>"db" );
if( not $db )
{
    print STDERR "Error $OpenCA::DB::errno: $OpenCA::DB::errval\n";
    ok(0);
} else {
    ok(1);
}

my $req;

## all must be empty because all valid certificates changed their state

## tests 5-10
ok ($db->elements( DATATYPE=>"VALID_CERTIFICATE" ), 0);
ok (not $db->deleteItem( DATATYPE=>"VALID_CERTIFICATE", KEY=>3 ));
ok (not $db->deleteItem( DATATYPE=>"VALID_CERTIFICATE", KEY=>04 ));
ok (not $db->deleteItem( DATATYPE=>"VALID_CERTIFICATE", KEY=>1 ));
ok (not $db->deleteItem( DATATYPE=>"VALID_CERTIFICATE", KEY=>3 ));
ok ($db->elements( DATATYPE=>"VALID_CERTIFICATE" ), 0);

sub gettext
{
    return $_[0];
}

1;
