
use Test;
BEGIN { plan tests => 3 };

use OpenCA::OpenSSL;
use OpenCA::DBI;

ok(1);

my $shell = ( $ENV{OPENSSL} or "/usr/bin/openssl" );
my $cnf   = ( $ENV{OPENSSL_CONFIG} or "/usr/ssl/openssl.cnf");

my $openssl = new OpenCA::OpenSSL( SHELL=>$shell, CONFIG=> $cnf, GETTEXT => \&gettext );
if (not $openssl)
{
    print STDERR "Error $OpenCA::OpenSSL::errno: $OpenCA::OpenSSL::errval\n";
    ok(0);
} else {
    ok(1);
}


1;

my $db = new OpenCA::DBI( SHELL=>$openssl, 
                         GETTEXT    => \&gettext,
                         DEBUG   => 0,
                         DB_Type => "Pg",
                         DB_Host => "localhost",
                         DB_Port => "5432",
                         DB_Name => "opencasu",
                         DB_User => "opencasu",
                         DB_Passwd => "opencasu");

if( not $db ) {
    print STDERR "Error $OpenCA::DBI::errno: $OpenCA::DBI::errval\n";
    ok(0);
} else {
    ok(1);
}

sub gettext
{
    return $_[0];
}

1;
