// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// DisplayPropertiesDlg.cpp : implementation file
//

#include "stdafx.h"
#include "winssh.h"
#include "DisplayPropertiesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDisplayPropertiesDlg dialog


CDisplayPropertiesDlg::CDisplayPropertiesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDisplayPropertiesDlg::IDD, pParent)
{
	memset(&m_lf, NULL, sizeof(m_lf));
	m_crText	= RGB(100,255,100);
	m_crBack	= RGB(0,0,0);

	memset(m_crCustomArray, NULL, sizeof(m_crCustomArray));
	m_iFontPoint = 100;			//represent 10.0 point font

	//{{AFX_DATA_INIT(CDisplayPropertiesDlg)
	m_szTextRGB = _T("");
	m_szBackRGB = _T("");
	m_szFontStatic = _T("");
	//}}AFX_DATA_INIT
}


void CDisplayPropertiesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDisplayPropertiesDlg)
	DDX_Text(pDX, IDC_TEXTCLR_STATIC, m_szTextRGB);
	DDX_Text(pDX, IDC_BACKCLR_STATIC, m_szBackRGB);
	DDX_Text(pDX, IDC_FONT_STATIC, m_szFontStatic);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDisplayPropertiesDlg, CDialog)
	//{{AFX_MSG_MAP(CDisplayPropertiesDlg)
	ON_BN_CLICKED(IDC_TEXTCLR_BUTTON, OnTextClrButton)
	ON_BN_CLICKED(IDC_BACKCLR_BUTTON, OnBackClrButton)
	ON_BN_CLICKED(IDC_FONT_BUTTON, OnFontButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


int CDisplayPropertiesDlg::DoModal() 
{
	ResetStaticBoxes();	
	return CDialog::DoModal();
}

void CDisplayPropertiesDlg::ResetStaticBoxes(BOOL bRedraw)
{
	m_szTextRGB.Format("RGB(%3.3d,%3.3d,%3.3d)",
		(int) ( 0x00FF0000 & (DWORD)m_crText ) / (256*256),
		(int) ( 0x0000FF00 & (DWORD)m_crText ) / 256,
		(int) ( 0x000000FF & (DWORD)m_crText ) );

	m_szBackRGB.Format("RGB(%3.3d,%3.3d,%3.3d)",
		(int) ( 0x00FF0000 & (DWORD)m_crBack ) / (256*256),
		(int) ( 0x0000FF00 & (DWORD)m_crBack ) / 256,
		(int) ( 0x000000FF & (DWORD)m_crBack ) );

	m_szFontStatic.Format(" %s %1.1f pt", m_lf.lfFaceName, m_iFontPoint / 10.0);

	if (bRedraw)
		UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// CDisplayPropertiesDlg message handlers

void CDisplayPropertiesDlg::OnTextClrButton() 
{
	CColorDialog	colorDlg;
	
	// pre-popup initialization
	colorDlg.m_cc.lpCustColors	= m_crCustomArray;
	colorDlg.m_cc.rgbResult		= m_crText;
	colorDlg.m_cc.Flags			= CC_FULLOPEN | CC_RGBINIT | CC_ENABLEHOOK;
	colorDlg.m_cc.lStructSize	= sizeof(colorDlg.m_cc);
	
	if( colorDlg.DoModal() == IDOK )
		m_crText = colorDlg.m_cc.rgbResult; // post-popup assignment
	
	ResetStaticBoxes(TRUE);
}

void CDisplayPropertiesDlg::OnBackClrButton() 
{
	CColorDialog	colorDlg;
	
	// pre-popup initialization
	colorDlg.m_cc.lpCustColors	= m_crCustomArray;
	colorDlg.m_cc.rgbResult		= m_crBack;
	colorDlg.m_cc.Flags			= CC_FULLOPEN | CC_RGBINIT | CC_ENABLEHOOK;
	colorDlg.m_cc.lStructSize	= sizeof(colorDlg.m_cc);
	
	if( colorDlg.DoModal() == IDOK )
		m_crBack = colorDlg.m_cc.rgbResult; // post-popup assignment
	
	ResetStaticBoxes(TRUE);
}

void CDisplayPropertiesDlg::OnFontButton() 
{
	CFontDialog		fontDlg;
	
	// pre-popup initialization
	fontDlg.m_cf.lpLogFont	= &m_lf;
	fontDlg.m_cf.Flags	= CF_ENABLEHOOK | CF_FIXEDPITCHONLY | CF_NOSCRIPTSEL | CF_SCREENFONTS;
	fontDlg.m_cf.iPointSize		= m_iFontPoint;
	fontDlg.m_cf.lStructSize	= sizeof(fontDlg.m_cf);

	if ( fontDlg.DoModal() == IDOK)
		m_iFontPoint = fontDlg.m_cf.iPointSize;

	ResetStaticBoxes(TRUE);
}
