// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

#include "stdafx.h"
#include "winssh.h"
#include "DlgDebugBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// DlgDebugBox dialog


DlgDebugBox::DlgDebugBox(CWnd* pParent /*=NULL*/)
	: CDialog(DlgDebugBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(DlgDebugBox)
	m_strFilter = _T("[DEBUG] ");
	//}}AFX_DATA_INIT
}


void DlgDebugBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(DlgDebugBox)
	DDX_Control(pDX, IDC_DEBUG_BUTTON_CLEAR, m_ButttonClear);
	DDX_Control(pDX, IDD_EDIT_DEBUG, m_EditDebug);
	DDX_Text(pDX, IDC_DEBUG_FILTER, m_strFilter);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(DlgDebugBox, CDialog)
	//{{AFX_MSG_MAP(DlgDebugBox)
	ON_BN_CLICKED(IDC_DEBUG_BUTTON_CLEAR, OnDebugButtonClear)
	ON_BN_CLICKED(IDC_DEBUG_FILTER_SET, OnDebugFilterSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// DlgDebugBox message handlers

void DlgDebugBox::OnDebugButtonClear() 
{
	// Clear the Window of text.
	m_EditDebug.SetWindowText("");
}

void DlgDebugBox::OnDebugFilterSet() 
{
	UpdateData(TRUE);
}
