// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// errors.cpp
//
// Error Handler - Displays message box from an error code.

//#include <stdio.h>
#include "Errors.h"

// Some Global Error handling externs

char *	g_pszErrorMessage;
CWinsshDoc *g_theDoc;

#ifdef DEBUG_SSH

DlgDebugBox		dialogDebug;
CWinsshHexBox	dialogHexBox;
FILE * fileDebug;
FILE * fileHexDebug;

void InitSshDebug() {

	// Startup the Debug Box
	dialogDebug.Create(IDD_DEBUGBOX);
	dialogDebug.m_EditDebug.FmtLines(FALSE);
	dialogDebug.m_EditDebug.SetSel(-1,-1);
	dialogDebug.m_EditDebug.ReplaceSel("Starting Debug Output - dump in file: debug.winssh.log\r\n");

	// Startup the Hex Debug Box
	dialogHexBox.Create(IDD_HEXBOX);
	dialogHexBox.m_datactrl.FmtLines(FALSE);
	dialogHexBox.m_datactrl.SetSel(-1,-1);
	dialogHexBox.m_datactrl.ReplaceSel("Starting Hex Debug Output - dump in file: debug.hex.log\r\n");

	// Output debug statements to file also
	fileDebug = fopen("debug.winssh.log", "w");
	fileHexDebug = fopen("debug.hex.log", "w");

} // end InitSshDebug()

void EndSshDebug() {

	fclose (fileDebug);
	fclose (fileHexDebug);

} // end EndSshDebug()

void Debug(const char * pszDebugText, ...) {

	va_list vaArgList;

	char szAddText[250];
	CString szWindowText;

	// Handle mutiple mutiple arguments and print resulting string to szAddText
	va_start(vaArgList, pszDebugText);
	vsprintf(szAddText, pszDebugText, vaArgList);
	va_end(vaArgList);

	// Update the Window
	CString NewText;
	NewText = "[DEBUG] ";
	NewText += szAddText;
	NewText += "\r\n";

	fprintf (fileDebug, "%s", (char *)(LPCSTR)NewText);
	fflush(fileDebug);
	dialogDebug.m_EditDebug.SetSel(-1,-1);

	// Setting Filters
	if (dialogDebug.m_strFilter.GetLength() > 0)
	{
		if (NewText.Left( dialogDebug.m_strFilter.GetLength() ) == dialogDebug.m_strFilter)
			dialogDebug.m_EditDebug.ReplaceSel((LPCTSTR)NewText);
	}
	else
		dialogDebug.m_EditDebug.ReplaceSel((LPCTSTR)NewText);

	// Clear window if we're nearing the object limits.
	if (dialogDebug.m_EditDebug.GetLineCount() > 450)
		 dialogDebug.m_EditDebug.SetWindowText("");
} // end Debug()

// ASCII Plain Message to Hex Box
void DebugPlain (const char * pszDebugText) {

	// Update the Window
	CString NewText;
	NewText = "\r\n";
	NewText += "---------------------------------------------------\r\n";
	NewText += "[DBG_PACKET] ";
	NewText += pszDebugText;
	NewText += "\r\n";

	fprintf (fileHexDebug, "%s", (char *)(LPCSTR)NewText);
	fflush(fileHexDebug);
	dialogHexBox.m_datactrl.SetSel(-1,-1);
	dialogHexBox.m_datactrl.ReplaceSel((LPCTSTR)NewText);

	// Clear window if we're nearing the object limits.
	if (dialogHexBox.m_datactrl.GetLineCount() > 450)
		 dialogHexBox.m_datactrl.SetWindowText("");


} // end DebugPlain()

//Prints Hex dump up to iLength into Hex box
void DebugPacket(unsigned char * pucDebugPacket, int iLength) {

	CString	szHex;
	CHAR	uszHexDump[10];
	
	dialogHexBox.UpdateData(TRUE);

	for (int iIndex=0; iIndex< iLength; iIndex++) {
		sprintf(uszHexDump, "%2.2X ", (BYTE)pucDebugPacket[iIndex]);
		fprintf (fileHexDebug, "%2.2X ", (BYTE)pucDebugPacket[iIndex]);
		if ((iIndex > 0) && (iIndex % 25 == 0))
			fprintf(fileHexDebug, "\r\n");
		fflush(fileHexDebug);
		szHex += uszHexDump;
	}

	dialogHexBox.m_datactrl.SetSel(-1,-1);
	dialogHexBox.m_datactrl.ReplaceSel((LPCTSTR)szHex);
	if (dialogHexBox.m_datactrl.LineIndex() > 30)
		dialogHexBox.m_data += "\r\n";

} // end DebugPacket()

//Prints Hex dump up with Printable ASCII chars to iLength into Hex box
void DebugPacketWithASCII(unsigned char * pucDebugPacket, int iLength) {

	CString	szHex, szASCII;
	CHAR	uszHexDump[10];
	
	dialogHexBox.UpdateData(TRUE);

	for (int iIndex=0; iIndex< iLength; iIndex++) 
	{
		sprintf(uszHexDump, "%2.2X ", (BYTE)pucDebugPacket[iIndex]);
		if ( ((BYTE)pucDebugPacket[iIndex] >= '\x020') && ((BYTE)pucDebugPacket[iIndex] <= '\x07e') )
			szASCII += pucDebugPacket[iIndex];
		else // not printable
			szASCII += '.';
		fprintf (fileHexDebug, "%2.2X ", (BYTE)pucDebugPacket[iIndex]);
		if ((iIndex > 0) && (iIndex % 25 == 0))
			fprintf(fileHexDebug, "\r\n");
		fflush(fileHexDebug);
		szHex += uszHexDump;

		if ((iIndex > 0) && ((iIndex+1) % 10 == 0))
		{
			szHex += "| ";
			szHex += szASCII;
			szHex += "\r\n";
			dialogHexBox.m_datactrl.SetSel(-1,-1);
			dialogHexBox.m_datactrl.ReplaceSel((LPCTSTR)szHex);
			szHex.Empty();
			szASCII.Empty();
		}
	}

	if (!szHex.IsEmpty())
	{
		for (iIndex=szHex.GetLength() ; iIndex < 30; iIndex++)
			szHex += ' ';
		szHex += "| ";
		szHex += szASCII;
		szHex += "\r\n";
	}
	dialogHexBox.m_datactrl.SetSel(-1,-1);
	dialogHexBox.m_datactrl.ReplaceSel((LPCTSTR)szHex);
	if (dialogHexBox.m_datactrl.LineIndex() > 30)
		dialogHexBox.m_data += "\r\n";

} // end DebugPacket()

#endif // DEBUG_SSH

void ErrorApplication(int iErrorCode) {

	int iMessage;

	if (iErrorCode > ERROR_SSH_GET_MESSAGE) {
		theApp.m_pActiveWnd->
			MessageBox(g_pszErrorMessage, "SSH Server Error Message", MB_ICONWARNING | MB_OK);
		if (iErrorCode == ERROR_SSH_MSG_DEBUG)
			// Do Nothing.
			return;
	}
	else if (iErrorCode > ERROR_WINSSH_START) {
		iMessage = iErrorCode % ERROR_WINSSH_START;
		theApp.m_pActiveWnd->
			MessageBox(ppErrorMessagesWinssh[iMessage], pErrorCaption, MB_ICONWARNING | MB_OK);
	}
	else if (iErrorCode > ERROR_SSH_START) {
		iMessage = iErrorCode % ERROR_SSH_START;
		theApp.m_pActiveWnd->
			MessageBox(ppErrorMessagesSsh[iMessage], pErrorCaption, MB_ICONWARNING | MB_OK);
	}
	else {
		theApp.m_pActiveWnd->
			MessageBox("Application Error!  Should not have gotten here", "Major Doh!", MB_ICONWARNING | MB_OK);
	}
#ifdef DEBUG_SSH
	Debug("ErrorApplication() - Closing Connection. iErrorCode = %d", iErrorCode);
#endif
	g_theDoc->CloseConnection();

} // end ErrorApplication()

int iAlert (int iErrorCode) {


	return 0;
}

// Non Fatal Error
int iError (int iErrorCode) {

	return 0;
}

// Catastrophic Error
void FatalError (int iErrorCode) {


}
