// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// Errors.h 
// All the error codes lies here

#ifndef ERRORS_H
#define ERRORS_H

//#include <stdio.h>
#include "stdafx.h"
#include "DlgDebugBox.h"
#include "WinsshHexBox.h"
#include "WinsshDoc.h"
#include "winssh.h"

#define	EXEC_SUCCESSFUL		0

// Errors from CSshSocket functions
#define ERROR_CREATE_SOCKET		9901
#define ERROR_CONNECT_HOST		9902
#define ERROR_SET_TIMEOUT		9903
#define ERROR_KILL_TIMEOUT		9904
#define ERROR_CONNECT_TIMEOUT	9905
#define ERROR_SEND_TIMEOUT		9906
#define ERROR_RECV_TIMEOUT		9907
#define ERROR_UNEXPECTED_CONNECTION_CLOSE	9908
#define ERROR_CONNECTION_CLOSED_ONSEND		9909
#define ERROR_CONNECTION_CLOSED_ONRECV		9910
#define ERROR_SOCKET_NOT_OPEN				9911

#define IDS_CREATEFAILED	"Network Socket Creation Failed"
#define IDS_RETRYCONNECT	"Failed to Connect to Host\n Try Again?"
#define IDS_CONNECT			"Connected to Host"
#define IDS_SERVERRESET		"Server has reset connection"
#define IDS_CONNECTIONCLOSED "Connection Closed"
#define IDS_CHANGEADDRESS	"Change Address?"
#define IDS_DISCONNECT		"Disconnecteed"


//---------------------//
// Debugging Constants //
//---------------------//

// Debugging Constants should also go here.


#ifdef DEBUG_SSH
void InitSshDebug();
void Debug(const char * pszDebugText, ...);
void DebugPlain (const char * pszDebugText);
void DebugPacket(unsigned char * pucDebugPacket, int iLength);
void DebugPacketWithASCII(unsigned char * pucDebugPacket, int iLength);
void EndSshDebug();
#endif // end DebuggingConstants

//---------------------------------//
// Global Error Handling Functions //
//---------------------------------//

extern CWinsshApp theApp;
extern CWinsshDoc *g_theDoc;

extern char *g_pszErrorMessage;

void ErrorApplication(int iErrorCode);

int iAlert (int iErrorCode);
int iError (int iErrorCode);
void FatalError (int iErrorCode);

//---------------------//
// Error Messages Here //
//---------------------//

// SSH Class errors
#define ERROR_SSH_START											5000
#define ERROR_SSH_CHECKSUM_MISMATCH							5001
#define ERROR_SSH_UNKNOWN_PACKET_TYPE						5002

// Winssh App Errors
#define ERROR_WINSSH_START										5100
#define ERROR_WINSSH_USERNAME_PASSWORD_NOT_RECOGNIZED	5101
#define ERROR_WINSSH_LOST_CONNECTION						5102
#define ERROR_WINSSH_UNABLE_CREATE_STATUS_BAR			5103

// Error messages generated from the SSH Server
#define ERROR_SSH_GET_MESSAGE									6000
#define ERROR_SSH_MSG_DEBUG									6001
#define ERROR_SSH_MSG_DISCONNECT								6002


static char pErrorCaption[] = "Doh! Windows SSH Client Error";

static char *ppErrorMessagesSsh[] = {
"Start of SSH Specific Error Messages at const 5000, This is a bogus error message.",
"Received packet checksum mistmatch. Aborting Connection.",
"Received an unknown or totally unexpected packet type. Aborting Connection."

}; // end *ppErrorMessagesSsh[]

static char *ppErrorMessagesWinssh[] = {
"Start of Winssh Application Error messages at const 5100",
"Username or Password not recognized by server.  Aborting connection.",
"Network connection lost.  Sorry! Unable to send data.",
"Failed to create status bar"
}; // end *ppErrorMessagesWinssh[]


#endif
