// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "winssh.h"
#include "Errors.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_QUERYENDSESSION()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



static UINT indicators[] =
{
	ID_SEPARATOR,								// status line indicator
	ID_INDICATOR_CIPHER,						// Cipher mode 
	ID_INDICATOR_TERM_AND_SIZE,			// Terminal Rows | Cols
	ID_INDICATOR_CAPS,		
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	CString szSection = "Window";
	
	CString szEntry   = "X";
	m_iXPos = AfxGetApp()->GetProfileInt(szSection, szEntry, 0);
	
	szEntry = "Y";
	m_iYPos = AfxGetApp()->GetProfileInt(szSection, szEntry, 100);

	szEntry = "Width";
	m_iWindowWidth = AfxGetApp()->GetProfileInt(szSection, szEntry, 750);

	szEntry = "Height";
	m_iWindowHeight = AfxGetApp()->GetProfileInt(szSection, szEntry, 420);

}

CMainFrame::~CMainFrame()
{


}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// No current need for a toolbar.
	//if (!m_wndToolBar.Create(this) ||
	//	!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	//{
	//	TRACE0("Failed to create toolbar\n");
	//	return -1;      // fail to create
	//}

	// Create Status Bar
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		ErrorApplication(ERROR_WINSSH_UNABLE_CREATE_STATUS_BAR);
		return -1;      // fail to create
	}
	// Remove this if you don't want tool tips or a resizeable toolbar
	//m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
	//	CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	//m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	//EnableDocking(CBRS_ALIGN_ANY);
	//DockControlBar(&m_wndToolBar);

	MoveWindow(m_iXPos, m_iYPos, m_iWindowWidth, m_iWindowHeight);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	
	//Disables resizing of the terminal window. 
	//resizing bites in this version. 981018
//	cs.style &= ~(WS_THICKFRAME);
	cs.style &= ~(WS_MAXIMIZEBOX);

	return CFrameWnd::PreCreateWindow(cs);
}

void CMainFrame::SetStatusBarText(LPCTSTR szText)
{
	m_wndStatusBar.SetPaneText(0, szText);
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

BOOL CMainFrame::OnQueryEndSession() 
{
	if (!CFrameWnd::OnQueryEndSession())
		return FALSE;
	
	// TODO: Add your specialized query end session code here
	
	return TRUE;
}

BOOL CMainFrame::DestroyWindow() 
{
	CRect rectObj;
	GetWindowRect((LPRECT)rectObj);

	CString szSection = "Window";
	
	CString szEntry   = "X";
	AfxGetApp()->WriteProfileInt(szSection, szEntry, rectObj.left);
	
	szEntry = "Y";
	AfxGetApp()->WriteProfileInt(szSection, szEntry, rectObj.top);

	szEntry = "Width";
	AfxGetApp()->WriteProfileInt(szSection, szEntry, rectObj.Width());

	szEntry = "Height";
	AfxGetApp()->WriteProfileInt(szSection, szEntry, rectObj.Height());


	return CFrameWnd::DestroyWindow();
}
