// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// NewConnect.cpp : implementation file
//

#include "stdafx.h"
#include "winssh.h"
#include "NewConnect.h"
#include "Errors.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// NewConnect dialog


NewConnect::NewConnect(CWnd* pParent /*=NULL*/)
	: CDialog(NewConnect::IDD, pParent)
{
	//{{AFX_DATA_INIT(NewConnect)
	//}}AFX_DATA_INIT
}


void NewConnect::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(NewConnect)
	DDX_Control(pDX, IDC_EDIT_HOSTNAME, m_EditHostname);
	DDX_Control(pDX, IDC_EDIT_PORT, m_EditPort);
	DDX_Control(pDX, IDC_EDIT_PASSWORD, m_EditPassword);
	DDX_Control(pDX, IDC_EDIT_USERNAME, m_EditUsername);
	DDX_Control(pDX, IDC_COMBO_CIPHER, m_ComboCipher);
	DDX_Control(pDX, IDC_SLIDER_COMPRESSION, m_SliderCompression);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_ComboProtocol);
	DDX_Control(pDX, IDC_LIST_HOSTLIST, m_LBoxHostlist);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(NewConnect, CDialog)
	//{{AFX_MSG_MAP(NewConnect)
	ON_CBN_SELCHANGE(IDC_COMBO_PROTOCOL, OnSelchangeComboProtocol)
	ON_LBN_DBLCLK(IDC_LIST_HOSTLIST, OnDblclkListHostlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// NewConnect message handlers

BOOL NewConnect::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// initialize all the data that can be hardcoded...
	


	// Add protocols
	m_ComboProtocol.AddString("ssh");
	m_ComboProtocol.AddString("telnet");
	m_ComboProtocol.SetCurSel(0);				// Set to default to SSH
	
	m_EditPort.SetWindowText("22");

	// Add Encryption Modes
	m_ComboCipher.AddString("No Encryption");
	m_ComboCipher.AddString("IDEA");
	m_ComboCipher.AddString("DES");
	m_ComboCipher.AddString("Triple-DES");
	m_ComboCipher.AddString("TSS - Experimental");
	m_ComboCipher.AddString("RC4");
	m_ComboCipher.AddString("BLOWFISH");
	m_ComboCipher.SetCurSel(1);				// Set to default to IDEA

	// Set the Compression Slider to gzip range and set to no compression.
	// Disable window till we implement.
	// TODO: Implement packet compression
	m_SliderCompression.SetRange(0, 9, TRUE);
	m_SliderCompression.SetTicFreq(1);
	m_SliderCompression.SetTic(0);
	m_SliderCompression.EnableWindow(FALSE);

	// TODO: 
	// Old host names should be read from the registry and put into the
	// hostname listbox.

#ifdef DEBUG_SSH
#ifdef DEBUG_TIM
	// Personal testing hosts.
	m_LBoxHostlist.AddString("sdcc10.ucsd.edu");
	m_LBoxHostlist.AddString("ieng9.ucsd.edu");

	m_EditHostname.SetWindowText("ieng9.ucsd.edu");

	// Add user data / password when debugging
	m_EditUsername.SetWindowText("xxx");
	m_EditPassword.SetWindowText("xxxx");
	m_EditHostname.SetWindowText("ieng9.ucsd.edu");
	m_EditPort.SetWindowText("22");
#endif 
#endif

	// Set Focus to Hostname
	m_EditHostname.SetFocus();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void NewConnect::OnSelchangeComboProtocol() 
{

	CString szTemp;
	int iTemp = m_ComboProtocol.GetCurSel();

	m_ComboProtocol.GetLBText(iTemp, szTemp);

	// if selection is telnet, disable SSH Specific options.
	if (szTemp.CompareNoCase("telnet") == 0) {
		m_ComboCipher.EnableWindow(false);
		m_SliderCompression.EnableWindow(false);
		m_EditUsername.EnableWindow(false);
		m_EditPassword.EnableWindow(false);
		m_EditPort.SetWindowText("23");
	}
	else if (szTemp.CompareNoCase("ssh") == 0 ) {
		m_ComboCipher.EnableWindow(true);
		m_SliderCompression.EnableWindow(true);
		m_EditUsername.EnableWindow(true);
		m_EditPassword.EnableWindow(true);
		m_EditPort.SetWindowText("22");
	}

}

void NewConnect::OnDblclkListHostlist() 
{
	
	// Old hostname double clicked, Put in the EditHostname box.

	CString szTemp;
	int iTemp = m_LBoxHostlist.GetCurSel();
	
	m_LBoxHostlist.GetText(iTemp, szTemp);
	m_EditHostname.SetWindowText(szTemp);

#ifdef DEBUG_SSH
#ifdef DEBUG_TIM
	// TODO: Needs to be deleted.
	// If medisg change to port 3000 and user babyduck
	if (!strcmp(szTemp, "medisg.stanford.edu")) {
		m_EditUsername.SetWindowText("babyduck");
		m_EditPort.SetWindowText("3000");
	}
	if (!strcmp(szTemp, "acm.ucsd.edu")) {
		m_EditUsername.SetWindowText("tim");
		m_EditPort.SetWindowText("1000");
	}
#endif 
#endif
} // NewConnect::OnDblclkListHostlist()


void NewConnect::OnOK() 
{
	CString szTemp;
	int iTemp;

	//-------------------------------------------------------------------------
	// Check for Invalid data.  Print error message and return to dialog box.
	if (m_EditHostname.GetWindowTextLength() == 0) { 
		AfxMessageBox("Please input a hostname to connect to.", MB_ICONEXCLAMATION | MB_OK);
		return;
	}
	if ((iTemp = m_EditPort.GetWindowTextLength()) == 0) { 
		AfxMessageBox("Please input a port number to connect to.", MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	m_EditPort.GetWindowText(szTemp);
	iTemp--;

	while (iTemp >= 0) { 
		if (!isdigit(szTemp[iTemp--])) {
			MessageBox("A port number must be numeric.  Please select another port number.", 
				"Ooops!", MB_ICONEXCLAMATION | MB_OK);
		} // end if
	} // end while

	// SSH Specific Checking
	iTemp = m_ComboProtocol.GetCurSel();
	m_ComboProtocol.GetLBText(iTemp, szTemp);

	if (szTemp.CompareNoCase("ssh") == 0) {

		if (m_EditUsername.GetWindowTextLength() == 0) {
			MessageBox("Please input a username.", "SSH Required", MB_ICONEXCLAMATION | MB_OK);
			return;
		}
		if (m_EditPassword.GetWindowTextLength() == 0) {
			MessageBox("Please input a password.", "SSH Required", MB_ICONEXCLAMATION | MB_OK);
			return;
		}
	}

	// End Idiot Proofing.
	//-------------------------------------------------------------------------

	// Exiting the Dialog Window, put all the data into the class as the 
	// other objects will be destroyed

	// Protocol
	iTemp = m_ComboProtocol.GetCurSel();
	m_ComboProtocol.GetLBText(iTemp, szProtocol);

	// iCipher
	iCipher = m_ComboCipher.GetCurSel();

	// Compression Level
	iCompression = m_SliderCompression.GetPos();
	
	// Port
	m_EditPort.GetWindowText(szTemp);
	iPort = atoi(szTemp);

	// Hostname, Username, Password
	m_EditHostname.GetWindowText(szHostname);
	m_EditUsername.GetWindowText(szUsername);
	m_EditPassword.GetWindowText(szPassword);

	CDialog::OnOK();
}

