// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// TermCap.h: interface for the CTermCap class.
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TERMCAP_H__55D5B341_AC32_11D1_8A1A_00201870197C__INCLUDED_)
#define AFX_TERMCAP_H__55D5B341_AC32_11D1_8A1A_00201870197C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


//////////////////////////////////////////////////////////////////////
// Constants and #Defines
//////////////////////////////////////////////////////////////////////

// Possible parameters
#define	TC_VT100			100
#define	TC_VT102			102
#define	TC_CMDSIGNAL	0xff
#define	TC_CMDFILLER	0xfe

// the size of the buffer for unprocessed vt-100 prints 
#define TC_MAXBUFLEN	65536
#define TC_MAXCQUEUE	8192

// Keyboard interpretations of keys below 0x20
//	Alias		Decimal Value
#define	TK_NUL		0
#define	TK_ENQ		5
#define	TK_BEL		7
#define	TK_BS			8
#define	TK_HT			9
#define	TK_LF			10
#define	TK_NL			10
#define	TK_VT			11
#define	TK_FF			12
#define	TK_CR			13
#define	TK_SO			14
#define	TK_SI			15
#define	TK_CAN		24
#define	TK_ESC		27  // 0x1B
#define	TK_DEL		127 // 0x7F

// Command Interpretations return by DequeueCommand()
//	Alias			Hex (dont care as long as unique)
#define	TC_NULL					0x00000000L	
#define	TC_ANSWERBACK			0x00000005L  // ENQ
#define	TC_BELL					0x00000007L
#define	TC_BACKSPACE			0x00000008L
#define	TC_TAB					0x00000009L
#define	TC_LINEFEED				0x0000000AL
#define	TC_NEWLINE				0x0000000AL  /*same as LF*/
#define	TC_VERTTAB				0x0000000BL
#define	TC_FORMFEED				0x0000000CL
#define	TC_RETURN				0x0000000DL
#define	TC_INVOKEG1				0x0000000EL
#define	TC_INVOKEG0				0x0000000FL
#define	TC_CANCELESC			0x00000018L  // CAN
#define	TC_END					0x00000020L  /* @7 : End key*/

#define	TC_ATTR_BOLD			0x00000021L  // -- switchables
#define	TC_ATTR_UNDERLINE		0x00000022L
#define	TC_ATTR_BLINK			0x00000023L
#define	TC_ATTR_REVERSE		0x00000024L
#define	TC_ATTR_OFF				0x00000025L
#define	TC_KEYPAD_ON			0x00000026L
#define	TC_KEYPAD_OFF			0x00000027L  
#define	TC_ALTCHARSET_ON		0x00000028L
#define	TC_ALTCHARSET_OFF		0x00000029L
#define	TC_SETTAB				0x0000002AL
#define	TC_CLEAR_TAB			0x0000002BL  // -- end of switchables

#define	TC_CURSOR_UP			0x00000031L
#define	TC_CURSOR_DOWN			0x00000032L
#define	TC_CURSOR_RIGHT		0x00000033L
#define	TC_CURSOR_HOME			0x00000035L
#define	TC_CURSOR_UP_ARG		0x00001031L
#define	TC_CURSOR_DOWN_ARG	0x00001032L
#define	TC_CURSOR_RIGHT_ARG	0x00001033L
#define	TC_CURSOR_LEFT_ARG	0x00001034L
#define	TC_CURSORTO_ARG_ARG	0x00002030L
#define	TC_SAVECURSOR			0x0000003AL
#define	TC_RESTORECURSOR		0x0000003BL

#define	TC_SCROLLFWD			0x00000041L
#define	TC_SCROLLREV			0x00000042L
#define	TC_SCROLLTO_ARG_ARG	0x00002040L

#define	TC_CLR_AFTERCURSOR	0x00000051L /* cd */
#define	TC_CLR_TO_EOLN			0x00000052L

#define	TC_SENTBY_HOME			0x00000101L
#define	TC_SENTBY_INSERT		0x00000102L
#define	TC_SENTBY_DELETE		0x00000103L
#define	TC_SENTBY_PAGEUP		0x00000104L
#define	TC_SENTBY_PAGEDOWN	0x00000105L
#define	TC_SENTBY_UP			0x00000131L
#define	TC_SENTBY_DOWN			0x00000132L
#define	TC_SENTBY_RIGHT		0x00000133L
#define	TC_SENTBY_LEFT			0x00000134L
#define	TC_SENTBY_F0			0x00000110L
#define	TC_SENTBY_F1			0x00000111L
#define	TC_SENTBY_F2			0x00000112L
#define	TC_SENTBY_F3			0x00000113L
#define	TC_SENTBY_F4			0x00000114L
#define	TC_SENTBY_F5			0x00000115L
#define	TC_SENTBY_F6			0x00000116L
#define	TC_SENTBY_F7			0x00000117L
#define	TC_SENTBY_F8			0x00000118L
#define	TC_SENTBY_F9			0x00000119L
#define	TC_SENTBY_F10			0x0000011AL
#define	TC_SENTBY_F11			0x0000011BL
#define	TC_SENTBY_F12			0x0000011CL

//Device Status Report commands (added 03/11/98)
#define	TC_DEVICE_STATUS		0x00010001L
#define	TC_DEVICE_CURSOR		0x00010002L

#define	TC_INIT_STR				0x00000091L
#define	TC_RESET_STR			0x00000092L

#define TC_ANSICHAR				0xFFFFFFFEL	//ansi char signal, not put in queue
#define	TC_UNKNOWN				0xFFFFFFFFL


//////////////////////////////////////////////////////////////////////
// class CTermCap header
//////////////////////////////////////////////////////////////////////

class CTermCap  
{
public:
	CTermCap();
	virtual ~CTermCap();

//Operations, all return values are Error Codes, 0 is Exec Successful
public:	
	int	Initialize(UINT TermType);	
	int	VtSendProcess(const UINT nChar, UCHAR* out);
	int	VtRecvProcess(UCHAR* pszProcessBuffer,const UINT BufLen); //modified 990131
	int	GetRemainderLength() { return m_usIncompleteCommandLen;}
	UCHAR* GetRemainderString() {return m_uszIncompleteCommand;}

	// Vt command storage center (for Receive use)
	int	GetCommandCount() {return m_iCommandCount;}
	int	DequeueCommand(ULONG& Command, int& Arg1, int& Arg2);

	ULONG	PeekCommand(int Index = 0);
	ULONG	ulLastCommand;
	UCHAR	m_uszIncompleteCommand[10];

// Private stuff, where nobody sees
private:
	int ProcessC0Command	(UCHAR* pszProcessBuffer);
	int ProcessEscCommand	(UCHAR* pszProcessBuffer);
	int ProcessEscBracketCommand(UCHAR* pszProcessBuffer);
	int ProcessNonCommand	(UCHAR* pszProcessBuffer);

	int QueueCommand(UCHAR* pszProcessBuffer, ULONG Cmd, int Arg1=-1, int Arg2=-1);
	void QueueCommandFiller(UCHAR* pszProcessBuffer, int iHowMany=1);
	int SaveIncompleteCommand(UCHAR* pszProcessBuffer);

//Attributes
private:
	unsigned short	m_usIncompleteCommandLen;
	
	int		m_iRProcessIndex;
	int		m_iRProcessEnd;

	int		m_iCommandCount;

	struct
	{
		ULONG	ulCommand;
		int	iArg1;
		int	iArg2;
	}	m_QUEUE[TC_MAXCQUEUE];

	char		m_szVtName[10];

};

#endif // !defined(AFX_TERMCAP_H__55D5B341_AC32_11D1_8A1A_00201870197C__INCLUDED_)
