# Copyright (C) 2000
#          by the Massachusetts Institute of Technology
#
#    Export of this software from the United States of America may
#    require a specific license from the United States Government.  It
#    is the responsibility of any person or organization contemplating
#    export to obtain such a license before exporting.
#
# WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
# distribute this software and its documentation for any purpose and
# without fee is hereby granted, provided that the above copyright
# notice appear in all copies and that both that copyright notice and
# this permission notice appear in supporting documentation, and that
# the name of M.I.T. not be used in advertising or publicity pertaining
# to distribution of the software without specific, written prior
# permission.  M.I.T. makes no representations about the suitability of
# this software for any purpose.  It is provided "as is" without express
# or implied warranty.

use strict;

# Destination
my ($szBaseDir) = '\dev\share\fissh';
my ($szBinaryDir) = 'bin';
my ($szSourceDir) = 'source';

print "Creating winssh Distribution Package in $szBaseDir\n";

#-----------------------------#
# Start Building Distribution #
#-----------------------------#

# Clean out the old distribution if it exists
#---------------------------------------------
`rm -rf $szBaseDir`;

# Create Directories
#--------------------
`mkdir $szBaseDir`;
`mkdir $szBaseDir\\$szBinaryDir`;
`mkdir $szBaseDir\\$szSourceDir\\cryptlib`;
`mkdir $szBaseDir\\$szSourceDir\\ssleay`;
`mkdir $szBaseDir\\$szSourceDir\\res`;

# Copy the Binaries over.
#-------------------------
`cp Release\\winssh.exe $szBaseDir\\$szBinaryDir\\winssh_debug.exe`;
`cp ReleaseFull\\winssh.exe $szBaseDir\\$szBinaryDir`;
`cp Release\\cl32.dll $szBaseDir\\$szBinaryDir`;
`cp Release\\libeay32.dll $szBaseDir\\$szBinaryDir`;
`cp C:\\winnt\\system32\\mfc42.dll $szBaseDir\\$szBinaryDir`;
`cp C:\\winnt\\system32\\msvcrt.dll $szBaseDir\\$szBinaryDir`;

# Copy the source files over.
#-----------------------------
`cp *.dsp $szBaseDir\\$szSourceDir`;

`cp *.cpp $szBaseDir\\$szSourceDir`;
`cp *.h $szBaseDir\\$szSourceDir`;
`cp *.rc $szBaseDir\\$szSourceDir`;

# Copy cryptlib headers, .lib, .dll over.
`cp cryptlib\\cl32.* $szBaseDir\\$szSourceDir\\cryptlib`;
`cp cryptlib\\*.h $szBaseDir\\$szSourceDir\\cryptlib`;

# Copy Ssleay headers, .lib, .dll over.
`cp ssleay\\libeay32.* $szBaseDir\\$szSourceDir\\ssleay`;
`cp ssleay\\*.h $szBaseDir\\$szSourceDir\\ssleay`;

# Copy Resource dir.
`cp res\\* $szBaseDir\\$szSourceDir\\res`;

# Copy README files over, create log file
#-----------------------------------------
`cp readme.txt $szBaseDir`;
`cp readme.license.txt $szBaseDir`;
`cp readme.source.txt $szBaseDir`;
`cp ssh_sample.html $szBaseDir`;
`cvs log > $szBaseDir\\readme.log.txt`;

print "\n\nDone!\n";
