// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// SshSocket.cpp: implementation of the CSshSocket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "winssh.h"
#include "SshSocket.h"
#include "winsshDoc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

IMPLEMENT_DYNAMIC(CSshSocket, CSocket)

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSshSocket::CSshSocket(CWinsshDoc* pDoc) {
	CSocket::CSocket();
	m_pDoc = pDoc;
}

//////////////////////////////////////////////////////////////////////
//  function: OnReceive
//
// Overloaded from CSocket
void CSshSocket::OnReceive(int nErrorCode) {

	CSocket::OnReceive(nErrorCode);
	
	m_pDoc->ProcessPendingRead();
}

void CSshSocket::OnClose(int nErrorCode) {

	CSocket::OnClose(nErrorCode);
	
	m_pDoc->ProcessPendingClose(nErrorCode);
}
