// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// winssh.cpp : Defines the class behaviors for the application.
//
#include "winssh.h"

#include "Errors.h"
#ifdef DEBUG_SSH
#include "DlgDebugBox.h"
#endif
#include "MainFrm.h"
#include "winsshDoc.h"
#include "winsshView.h"
#include "NewConnect.h"
#include "SessionMain.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinsshApp

BEGIN_MESSAGE_MAP(CWinsshApp, CWinApp)
	//{{AFX_MSG_MAP(CWinsshApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinsshApp construction

CWinsshApp::CWinsshApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWinsshApp object

CWinsshApp NEAR theApp;


/////////////////////////////////////////////////////////////////////////////
// CWinsshApp initialization

BOOL CWinsshApp::InitInstance()
{
//	AfxMessageBox("Welcome to FiSSH!", MB_ICONINFORMATION);

	memset(&m_lf, NULL, sizeof(m_lf));
	// font initialization work
	m_lf.lfHeight	= -13;
	m_lf.lfWeight	= 100;
	m_lf.lfPitchAndFamily = FIXED_PITCH | FF_MODERN;
	strcpy(m_lf.lfFaceName,"Courier");

	m_crText		= RGB(100,255,100); //traditional green
	m_crBack		= RGB(0,0,0);		//black
	m_usTabStop		= 8;


	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

#ifdef DEBUG_SSH 
	// Create Debug Output boxes if we're debugging.
	::InitSshDebug();
#endif

	//	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.

	//CString szReg;
	//szReg.LoadString(AFX_IDS_COMPANY_NAME);
	//SetRegistryKey(szReg);

	//LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CWinsshDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CWinsshView));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	GetMainWnd()->ShowWindow(SW_SHOWNORMAL);
	GetMainWnd()->UpdateWindow();

	return TRUE;
}

//------------------//
// CAboutDlg Dialog //
//------------------//

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	CEdit	m_EditInfo;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	CString m_szSpiel;

	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT

}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_EDIT_ABOUT, m_EditInfo);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CWinsshApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CString szTemp;

	// Build the Whole About Spiel
	m_szSpiel.Empty();

	szTemp.LoadString(AFX_IDS_APP_TITLE);
	SetWindowText("About " + szTemp);

	m_szSpiel = szTemp + " ";

	szTemp.LoadString(AFX_IDS_APP_VERSION);
#ifdef DEBUG_SSH
	m_szSpiel += "[DEBUG BUILD] ";
#endif 

	m_szSpiel += szTemp + "\r\nA free secure shell (ssh) and telnet client.\r\n\r\n";

	szTemp.LoadString(AFX_IDS_COPYRIGHT_INFO);
	m_szSpiel += szTemp + " by ";

	szTemp.LoadString(AFX_IDS_AUTHORS);
	m_szSpiel += szTemp + "\r\n\r\n";
	
	szTemp.LoadString(AFX_IDS_APP_URL);
	m_szSpiel += szTemp + "\r\n\r\n";

	m_szSpiel += "Build Date: " + (CString)__DATE__ + " " + (CString)__TIME__;
	m_szSpiel += "\r\n\r\n";
	m_szSpiel += "SSH Ciphers Enabled: DES, IDEA\r\n";
	m_szSpiel += "SSH Authentication Methods: Password\r\n\r\n";

	m_szSpiel += "Read readme.license.txt for full licensing information.";
	m_EditInfo.SetWindowText(m_szSpiel);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

} // end CAboutDlg::OnInitDialog()
