// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// winsshDoc.h : interface of the CWinsshDoc class
//
// Doug: most of the socket usage are here
//       along with the framework/menu wiring 
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WINSSHDOC_H__D784A66C_9875_11D1_89FB_00201870197C__INCLUDED_)
#define AFX_WINSSHDOC_H__D784A66C_9875_11D1_89FB_00201870197C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "stdafx.h"
#include "winssh.h"
#include "sshsocket.h"
#include "TermCap.h"
#include "ssh.h"
#include "WinsshHexBox.h"		// Hex Dump Box
#include "NewConnect.h"			// Connect Dump Box
#include "DlgEncryptSelect.h" // Select Server Encrypt Mode Box
#include "winsshView.h"
#include "SessionMain.h"
#include "MainFrm.h"

// Socket Specific
#define MAX_PACKET_LENGTH	65536   //of 4 byte chars

// SSH Connection States
#define SSH_STATE_INIT								100
#define SSH_STATE_GET_PUBLIC_KEY					110
#define SSH_STATE_SEND_USERNAME					120
#define SSH_STATE_AUTHENTICATE					130
#define SSH_STATE_AUTHENTICATE_PASSWORD		131	
#define SSH_STATE_PREPATORY						140
#define SSH_STATE_PREPATORY_SHELL_REQUESTED	141
#define SSH_STATE_INTERACTIVE						150

// SSH Application States
#define APP_STATE_START								200
#define APP_STATE_CONNECTING						220
#define APP_STATE_CONNECTED						240
#define APP_STATE_DISCONNECTED					260
#define APP_STATE_END								280

// Connection Status
#define PROTOCOL_SSH			22
#define PROTOCOL_TELNET		23

// Error Codes Specific to CWinsshDoc


class CWinsshDoc : public CDocument
{
	
	public:
		DECLARE_DYNCREATE(CWinsshDoc)
		CWinsshDoc();
		virtual ~CWinsshDoc();
#ifdef _DEBUG
		virtual void AssertValid() const;
		virtual void Dump(CDumpContext& dc) const;
#endif

		void CloseConnection();					// Closes connection on packet error
		BOOL ConnectSocket(LPCTSTR lpszHandle, LPCTSTR lpszAddress, UINT iPort);
		void ProcessPendingRead();			// will be called by m_pSocket
		void ProcessPendingClose(int);		// will be called by m_pSocket when socket is closed
		void SocketEncryptSend(CString& strText);	// public funtion for CWinsshView to call
		void SocketEncryptSend(unsigned char* pucSend, int iCount);
		void SocketSend(unsigned char * pucSend, int iLength); // Overload it baby.
		void SetApplicationState(int iState);

		// Public Data Members
		CTermCap*		m_pTC;					// TermCap

		// Socket and SSH Objects
		CSshSocket*		m_pSocket;				// Our Socket
		CSsh				cSshHandler;			// SSH Object to handle SSH packets
		int				m_iAppState;			// Current Application State (UI Handling)
		BOOL				m_bTermModify;
		CString			m_szTermType;			//Termtype.. VT100.. etc.


	protected:

		void SocketReceive();				// Receive data from socket.
		void NegotiateTerminal();			// Telnet Negotiation
		void NegotiateOthers();				// Telnet Negotiation

		// calls CWinsshView for output
		void DisplayMsg(CString&	Text);
		void DisplayMsg(int Length,	void*	Text);
	
		// Overrides
		afx_msg void OnUpdateCipher(CCmdUI* pCmdItem);
		afx_msg void OnUpdateTermAndSize(CCmdUI* pCmdItem);


		CString			m_szHostname;			// Hostname (keep last connection data)
		UINT				m_iPort;					// Port
		CString			m_szSockHandle;		// Handle for our Socket
		CString			m_szRecvBuffer;		// Socket Receive Buffer
		int				m_iRecvBufBusy;		// mutex to halt receiving


		// Receive Buffer Stuff 
		UCHAR *		m_pucNetworkReceiveBuffer;
		int			m_iNetBufLength;
		UCHAR	*		m_pucReceivePacketBuffer;
		CString		m_szTempBuf;					// For Telnet
	
		// Send buffer Packet Space
		UCHAR * 		m_pucSendPacketBuffer;	// Send Packet Buffer
		int			m_iSendBufferLength;		// Send Packet Buffer Length
		int			m_iSshState;				// Current State of SSH Connection
		int			m_iProtocolState;			// Using this Protocol to connect.


		// ClassWizard generated virtual function overrides
		//{{AFX_VIRTUAL(CWinsshDoc)
		public:
		virtual BOOL OnNewDocument();
		virtual void DeleteContents();
		virtual void SetTitle(LPCTSTR lpszTitle);
		protected:
		virtual BOOL SaveModified();
		//}}AFX_VIRTUAL

		//{{AFX_MSG(CWinsshDoc)
		afx_msg void OnNewConnection();
		afx_msg void OnFileConnect();
		afx_msg void OnFileDisconnect();
	afx_msg void OnUpdateFileNewconnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileConnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileDisconnect(CCmdUI* pCmdUI);
	afx_msg void OnOverrideCut();
	//}}AFX_MSG
		DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINSSHDOC_H__D784A66C_9875_11D1_89FB_00201870197C__INCLUDED_)
