// Copyright (C) 2000
//          by the Massachusetts Institute of Technology
//
//    Export of this software from the United States of America may
//    require a specific license from the United States Government.  It
//    is the responsibility of any person or organization contemplating
//    export to obtain such a license before exporting.
//
// WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
// distribute this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both that copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of M.I.T. not be used in advertising or publicity pertaining
// to distribution of the software without specific, written prior
// permission.  M.I.T. makes no representations about the suitability of
// this software for any purpose.  It is provided "as is" without express
// or implied warranty.

// winsshView.h : interface of the CWinsshView class
// The code is still a bit messy on this one.. 
/////////////////////////////////////////////////////////////////////////////


#if !defined(AFX_WINSSHVIEW_H__D784A66E_9875_11D1_89FB_00201870197C__INCLUDED_)
#define AFX_WINSSHVIEW_H__D784A66E_9875_11D1_89FB_00201870197C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#define SSH_KEYBOARD_SEND_LENGTH	10
#define SSH_MAX_TERM_ROWS			128
#define SSH_MAX_TERM_COLS			256

class CWinsshView : public CView
{
protected: // create from serialization only
	CWinsshView();
	DECLARE_DYNCREATE(CWinsshView)

public:
	CWinsshDoc* GetDocument();
	virtual ~CWinsshView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

/////////////////////////////////////////////////////////////
// Public function made for CWinsshDoc to call

	void DisplayVtText(CString& VTString);

private:
////////////////////////////////////////////////////////////
// Private functions only called by self
	void			HandleTermCap();
	unsigned short	GetCursorCoordinateX(); //right side of the current cursor
	unsigned short	GetCursorCoordinateY();	//y-coord of top of cursor
	void			ChangeDisplayFont();
	void			privateOutputToScreen();

	void			CursorTo(int Row, int Col);	// 1-based top left is 1,1
	void			CursorDown(int Rows=1);
	void			CursorUp(int Rows=1);
	void			CursorLeft(int Cols=1);
	void			CursorRight(int Cols=1);
	void			CursorTab();
	void			ClearAfterCursor();
	void			ClearToEOLN();
	void			ScrollReverse();
	void			SetScrollRegion(int Top, int Bottom);

	void			ChangeAttrib();		//function to switch to bold, reverse, normal, etc
	void			SetTab();
	void			UpdateTermXY();		//looking at WndX,WndY,FontX,FontY, update TermX,TermY
	void			ReplyDeviceStatus();
	void			ReplyDeviceCursor();//necessary for 'resize'
	void			DisplayCaret();

	void			RepaintMissingArea(	unsigned short TopRow,
										unsigned short BottomRow,
										unsigned short LeftCol,
										unsigned short RightCol);
////////////////////////////////////////////////////////////
//				Attributes / Data variables
public:
	// TermX,TermY : only changed by OnSize()
	unsigned short	m_usTermY;			//max number or rows font-wise (eg 24)
	unsigned short	m_usTermX;			//max number of columns (eg 80)

	// CursorX,CursorY can be changed by HandleTermCap() and CursorUp/Down/functions
	unsigned short	m_usCursorY;		//cursor's current row position, top = 1;
	unsigned short	m_usCursorX;		//cursor's column position, left = 1;

protected:
	CWinsshDoc* pDoc;

private:

	// WndX,WndY : only changed by OnSize()
	unsigned short	m_usWndY;			//height of terminal area in pixels
	unsigned short	m_usWndX;			//width of terminal area in pixels
	
	// FontX,FontY : only changed by UpdateFont() called by main application
	unsigned short	m_usFontY;			//font height in pixels
	unsigned short	m_usFontX;			//font width in pixels

	unsigned short	m_usCursorSaveY;	//saves cursor pos for restore command
	unsigned short	m_usCursorSaveX;

	unsigned short	m_usScrollRegionTop;	//top of scrolling region
	unsigned short	m_usScrollRegionBottom;	//bottom of scrolling region

	POINT			m_CursorPoint;

	CBrush			m_brush;			// Solid brush for background filling
	CFont			m_font;				// Internal font struct, handy when calling SetFont()
	BOOL			m_bScreenInit;		// make sure OnInitialUpdate() has been called before trying to paint
	BOOL			m_bFreshReconnection;	//indicates if connection is renewed

	BOOL			m_isAttribBold;		//specify if Bold is active
	BOOL			m_isAttribUndl;		//specify if Underline is active
	BOOL			m_isAttribRevs;		//specify if Reverse is active
	BOOL			m_isSystemKey;
	BOOL			m_isCtrlKey;
	ULONG			m_ulLastCommand;		//traces the last VT command
	ULONG			m_ulSecLastCommand;		//traces the second last VT command

	UCHAR			m_uszDisplayASCIILine[SSH_MAX_TERM_COLS];	//display string buffer
	int				m_iSpacingArray[SSH_MAX_TERM_COLS];			//padding between each character

	UCHAR			m_uszDisplayBuffer[SSH_MAX_TERM_ROWS][SSH_MAX_TERM_COLS];	//Screen buffer (circular)
	unsigned short	m_usDisplayBufferTop;	//marks where the head of the circular array is Row 1

private:
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinsshView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation

// Generated message map functions
protected:
	//{{AFX_MSG(CWinsshView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDisplayProperties();
	afx_msg void OnPaint();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in winsshView.cpp
inline CWinsshDoc* CWinsshView::GetDocument()
   { return (CWinsshDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINSSHVIEW_H__D784A66E_9875_11D1_89FB_00201870197C__INCLUDED_)
