/* $Id: ssh_logging.c,v 1.10.2.1 2000/08/25 09:32:10 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#include <syslog.h>
#include <stdarg.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>

#include "options.h"

#include "ssh_logging.h"

int debugpid;
int debuglevel;
int debug_to_stderr;
static int loginitdone = 0;

/*
 * progname:	Prefix to use, if not sshd.
 * usestderr:	if 1, also log to stderr
 *		if 2, only log to stderr
 */
int loginit(char *progname, int usestderr) {

    if (loginitdone == 1)
	closelog();

    if (usestderr)
	debug_to_stderr = usestderr;
    else
	debug_to_stderr = 0;

    if (debug_to_stderr < 2) {
	if (progname == NULL)
	    openlog("sshd", LOG_PID, LOG_DAEMON);
	else
	    openlog(progname, LOG_PID, LOG_DAEMON);
    }
    debugpid = getpid();
    loginitdone = 1;
    return(0);
}

int logclose() {

    closelog();
    loginitdone = 0;
    return(0);
}

int logit(char *fmt, ...)
{
    va_list args;
    int retval = 0;

    va_start(args, fmt);
    if (debug_to_stderr < 2)
	vsyslog(LOG_DEBUG, fmt, args);
    if (debug_to_stderr) {
	fprintf(stderr, "sshd[%d]: ", debugpid);
	vfprintf(stderr, fmt, args);
    }
    va_end(args);
    return(retval);
}

void debug_nostderr() {
    debug_to_stderr = 0;
}

/*
 * debug_inc: increase the debug level.
 */
void debug_inc(int sig) {
    debuglevel++;
    if (debuglevel > 10)
	debuglevel = 10;
    SSH_DLOG(0, ("Debug level increased to %d.\n", debuglevel));
    return;
}

/*
 * debug_dec: decrease the debug level.
 */
void debug_dec(int sig) {
    debuglevel--;
    if (debuglevel < 0)
	debuglevel = 0;
    SSH_DLOG(0, ("Debug level decreased to %d.\n", debuglevel));
    return;
}

int is_debug_level(int l) {
    return(l <= debuglevel);
}
