/* $Id: sshd_server.c,v 1.21.2.1 2000/08/25 09:32:24 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

/* This file contains routines that drive the flow of */
/* an sshd server which has just received an incoming */
/* connection. */

#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include "options.h"

#include "sshd.h"
#include "ssh_sys.h"
#include "ssh_util.h"

/*
 * doServer: start conversation with client.
 *
 * Note: This function should NOT return!
 */
int doServer(struct sshd_context *context) {
  int retval;
  struct itimerval itval;

    /* Check for compatible versions. */
    if ((retval = get_version(context)) != 0) {
	close(context->s);
	ssh_sys_exit(0);
    }

    /* ------------------------ */

    /* ok, looks like a ssh client.  Negociate encryption of the connection. */
    if ((retval = start_encryption(context)) != 0) {
	SSH_DLOG(3, ("doServer: start_encryption failed: %d\n", retval));
	close(context->s);
	ssh_sys_exit(0);
    }

    /* ------------------------ */

    /* Get user name from client. */
    if ((retval = get_user(context)) < 0) {
	close(context->s);
	ssh_sys_exit(0);
    }

    /* See if the user is authorized. */
    if ((retval = auth_user(context)) != 0) {
	close(context->s);
	ssh_sys_exit(0);
    }

    /* User has authenticated himself, disable the timer to disconnect him. */
    signal(SIGALRM, SIG_IGN);
    timerclear(&itval.it_value);
    setitimer(ITIMER_REAL, &itval, NULL);

    /* Switch to the user. */
    if ((retval = ssh_sys_setuser(context, context->username)) != 0) {
	close(context->s);
	ssh_sys_exit(0);
    }

    /* ------------------------ */

    /* Do preliminary setup, before executing a shell. */
    if ((retval = doPrepOps(context)) != 0) {
	close(context->s);
	ssh_sys_exit(0);
    }

    /* If we're here the client requested an EXEC and it was done. */
    /* Move into interactive mode. */
    if ((retval = doInteractive(context)) != 0) {
	close(context->s);
	ssh_sys_exit(1);
    }

    /* ------------------------ */

    /* All done. */
    ssh_sys_exit(0);
    /* NOTREACHED */
    exit(0);
}

