/* $Id: ssh_auth.c,v 1.7 2001/02/11 03:35:25 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

/*
 * Copyright (c) 2001 Jason R. Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#include <strings.h>

#include "options.h"

#include "sshd.h"
#include "ssh_auth.h"
#include "ssh_global.h"

#if !defined(WITH_AUTH_RHOSTS) && !defined(WITH_AUTH_RSA)
#if !defined(WITH_AUTH_PASSWORD) && !defined(WITH_AUTH_RHOSTS_RSA)
#error You must define at least one authentication type.
#endif
#endif

void 
set_supported_auths(int *arg)
{

	*arg = 0;
#ifdef WITH_AUTH_RHOSTS
	*arg |= (1 << SSH_AUTH_RHOSTS);
#endif
#ifdef WITH_AUTH_RSA
	*arg |= (1 << SSH_AUTH_RSA);
#endif
#ifdef WITH_AUTH_PASSWORD
	*arg |= (1 << SSH_AUTH_PASSWORD);
#endif
#ifdef WITH_AUTH_RHOSTS_RSA
	*arg |= (1 << SSH_AUTH_RHOSTS_RSA);
#endif
}

int
auths_supported(ssh_context_t *context)
{

	return (context->supported_auths);
}

int 
auth_is_supported(ssh_context_t *context, int auth)
{

	return ((context->supported_auths & (1 << auth)) ? 1 : 0);
}

const char *
auth_name(int anum)
{

	switch (anum) {
	case SSH_AUTH_RHOSTS:
		return ("Rhosts");
	case SSH_AUTH_RSA:
		return ("RSA");
	case SSH_AUTH_PASSWORD:
		return ("Password");
	case SSH_AUTH_RHOSTS_RSA:
		return ("Rhosts-RSA");
	default:
		return ("unknown");
	}
}

int 
auth_number(char *aname)
{

	if (strcasecmp(aname, "rhosts") == 0)
		return (SSH_AUTH_RHOSTS);
	if (strcasecmp(aname, "rsa") == 0)
		return (SSH_AUTH_RSA);
	if (strcasecmp(aname, "password") == 0)
		return (SSH_AUTH_PASSWORD);
	if (strcasecmp(aname, "rhosts-rsa") == 0)
		return (SSH_AUTH_RHOSTS_RSA);
	if (strcasecmp(aname, "rhostsrsa") == 0)
		return (SSH_AUTH_RHOSTS_RSA);
	return (-1);
}
