/* $Id: ssh_none.c,v 1.4 2001/02/05 23:06:31 thorpej Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "options.h"

#include "sshd.h"
#include "ssh_cipher.h"
#include "ssh_none.h"

void 
ssh_none_attach(ssh_cipher_t *c)
{

	c->type = SSH_CIPHER_NONE;
	c->initialize = (void *) ssh_none_initialize;
	c->block_size = 8;
	c->encrypt = ssh_none_encrypt;
	c->decrypt = ssh_none_decrypt;
	c->destroy = ssh_none_destroy;
	c->key_data = NULL;
}

void *
ssh_none_initialize(void *session_key, int klen, int role)
{
	return malloc(64 * sizeof(char));
}

void 
ssh_none_destroy(void *key_data)
{

	free(key_data);
}

void 
ssh_none_encrypt(u_int8_t *clear, u_int8_t *enc, int length,
		 void *key_data)
{
	(void) memcpy(enc, clear, length);
}

void 
ssh_none_decrypt(u_int8_t *enc, u_int8_t *clear, int length,
		 void *key_data)
{
	(void) memcpy(clear, enc, length);
}
