/*	$Id: pathnames.h,v 1.6 2001/02/11 03:35:08 tls Exp $	*/

/*
 * Copyright (c) 2000 Jason R. Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _FRESSH_PATHNAMES_H_
#define	_FRESSH_PATHNAMES_H_

#include <paths.h>

/*
 * System utility and file paths.
 */

#define	_PATH_URANDOM			"/dev/urandom"

/*
 * Name of the directory in each user's home directory containing private
 * configuration and data files.  May need to change this if FreSSH
 * becomes incompatible with other Secure Shell implementations.
 */
#define	_PATH_SSH_USER_DIR		".ssh"

/*
 * Name of the default file containing the client-side authentication key.
 * This file should be readable only by the user.
 *
 * Note that older versions of FreSSH use a different convention for
 * the key file names than new versions (which simply use the F-Secure
 * naming conventions and file formats).  Otherwise, the public key
 * file name is generated by appending ".pub" to the end of the private
 * key file name.
 */
#define	_PATH_SSH_CLIENT_PRIVKEY	_PATH_SSH_USER_DIR "/identity"
#define	_PATH_SSH_CLIENT_PRIVKEY_FRESSH	_PATH_SSH_USER_DIR "/key.priv"
#define	_PATH_SSH_CLIENT_PUBKEY_FRESSH	_PATH_SSH_USER_DIR "/key.pub"

/*
 * Name of the default file containing the server-side authentication key.
 * This should be readable only by the super-user.
 *
 * Note that older versions of FreSSH use a different convention for
 * the key file names than new version (which simply use the F-Secure
 * naming conventions and file formats).
 *
 * The public key name is created by appending ".pub" to the private
 * key name.
 *
 * When attempting to read the host key, if we don't find the F-Secure
 * format file, then we attempt to open a FreSSH format file.
 */
#define	_PATH_SSHD_SERVER_PRIVKEY	 "/etc/ssh_host_key"
#define	_PATH_SSHD_SERVER_PRIVKEY_FRESSH "/etc/sshd.key"

/*
 * Default PID file for the server.
 */
#define	_PATH_SSHD_PIDFILE		_PATH_VARRUN "sshd.pid"

/*
 * Default passphrase asking program for fressh-add.
 */
#define	_PATH_ASKPASS_PROG		"/usr/X11R6/bin/ssh-askpass"

#endif /* _FRESSH_PATHNAMES_H_ */
