/* $Id: ssh_logging.h,v 1.12 2001/02/09 02:43:54 andrew Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#ifndef _SSH_LOGGING_H
#define _SSH_LOGGING_H

#ifdef __GNUC__
#define FUNC_DECL(x)	int __attribute__((__unused__)) __unused_variable
#define FUNC	__FUNCTION__
#else
#define FUNC_DECL(x) const char *s_funct_name = STRING(x)
#define FUNC	s_funct_name
#endif

#include <syslog.h>
#include <stdarg.h>
#ifndef DEBUG
#define DEBUG 2
#endif

extern int debuglevel;
extern const char *g_func;
extern struct timeval tv_start;

#define SSH_DLOG(l, args) do {	\
	if (debuglevel >= l)		\
	{ g_func = FUNC ; logit args ;}	\
} while(0)

#define SSH_ERROR	g_func = FUNC, logit

int loginit(const char *, int);
int logclose(void);
int logit(const char *, ...);

void debug_nostderr(void);

void debug_inc(int);
void debug_dec(int);
int is_debug_level(int);

#endif /* _SSH_LOGGING_H */
