/* 	$Id: ssh_sys_svr4.h,v 1.1 2001/02/10 23:16:34 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */


#ifndef _SSH_SYS_SVR4_H
#define _SSH_SYS_SVR4_H

#include <sys/param.h>
#include <sys/types.h>
#include <sys/mman.h>

/* XXX Do the posix dance and retrieve these appropriately */
#define MAXINTERP	64	/* max interpreter file name length */
#define MAXLOGNAME	16	/* max login name length */

/* This may well come out of the compiler and run just as fast, and it avoids
   casts which may not pass EGCS's pedantic "strict alias" checking... */
#define FLIP_BYTES(bytes, howmany) \
{ \
  long where = 0; \
  u_int8_t holder[4]; \
\
    while(where < howmany) { \
	holder[0] = bytes[where + 3]; \
	holder[3] = bytes[where]; \
	holder[1] = bytes[where + 2]; \
	holder[2] = bytes[where + 1]; \
        bytes[where++] = holder[0]; \
	bytes[where++] = holder[1]; \
	bytes[where++] = holder[2]; \
	bytes[where++] = holder[3]; \
    } \
}

typedef int ssh_sys_eventq[2];

#define ssh_sys_unreadin(buf,len)	munmap((buf),(len))

#endif /* _SSH_SYS_LINUX_H */
