/* $Id: ssh_types.h,v 1.10 2001/02/11 03:35:15 tls Exp $ */

/*
 * Copyright (c) 2000 Andrew Brown.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _SSH_TYPES_H
#define _SSH_TYPES_H

struct ssh_client_options {
	int   ForwardAgent;
	int   ForwardX11;
	int   RhostsAuthentication;
	int   RhostsRSAAuthentication;
	int   RSAAuthentication;
	int   TISAuthentication;
	int   PasswordAuthentication;
	int   FallBackToRsh;
	int   UseRsh;
	int   BatchMode;
	int   StrictHostKeyChecking;
	char *IdentityFile;
	const char *Port;
	const char *DefaultPort;
	int   Cipher;
	int   EscapeChar;

#define NO_ESCAPE_CHAR -2

	/* char *User; -- stuff this into context->username */
	char *HostName;					/* this is the name we look up in dns */
	
	int   StdinDevNull;
	int   UseRemoteTTY;
	int   Verbosity;
	int   QuietMode;
	int   InBackground;
	int   NonPrivLocalPort;
	int   UseCompression;

	char *UserHostName;				/* what the user calls the remote host */
	char *RemoteCommand;

	int   CompressionLevel;
	const char *GlobalKnownHostsFile;
	const char *UserKnownHostsFile;
	int   NumberOfPasswordPrompts;
	int   PasswordPromptLogin;
	int   PasswordPromptHost;

	char *PublicIdentityFile;      /* identity file with .pub at the end */
	char *localhost;          /* i want this for f-secure style messages */
	char *password;
	struct termios tcap;

	int   StdinIsTty;
	int   ttyfd;
	void (*signal_handler)(int);
	int   sigcont;
	int   sigwinch;
	int   exitwith;
};

/*

 * adapted from readconf.c (ssh-1.2.30) so that i know what people
 * might expect
 
 ForwardAgent
 ForwardX11
 RhostsAuthentication
 TISAuthentication
 PasswordAuthentication
 RSAAuthentication
 FallBackToRsh
 UseRsh
 IdentityFile
 HostName
 Port
 Cipher
 RemoteForward
 LocalForward
 User
 Host
 EscapeChar
 RhostsRSAAuthentication
 ProxyCommand
 GlobalKnownHostsFile
 UserKnownHostsFile
 ConnectionAttempts
 BatchMode
 StrictHostKeyChecking
 Compression
 CompressionLevel
 KeepAlives
 UsePrivilegedPort
 KerberosAuthentication
 KerberosTgtPassing
 ClearAllForwardings
 NumberOfPasswordPrompts
 XauthPath
 GatewayPorts
 PasswordPromptLogin
 PasswordPromptHost
*/

#endif /* _SSH_TYPES_H */
