/* $Id: ssh_util.h,v 1.46 2001/02/11 03:35:16 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed 
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

/*
 * Copyright (c) 2000, 2001 Andrew Brown, Eric Haszlakiewicz,
 * 	Thor Lancelot Simon, and Jason Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The names of the authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
 
#ifndef _SSH_UTIL_H
#define _SSH_UTIL_H

#include <termios.h>

#include "sshd.h"

#define RET_OK         0
#define RET_FATAL     -1
#define RET_FAIL       1
#define RET_NEXT_STATE 2
#define RET_SKIP_STATE 3	/* XXX Skip the next state */

#define EXIT_NOW    0
#define EXIT_FLUSH  1

void set_tos(int, int);
int close_files_for_exec(ssh_context_t *);
void reset_signals(void);

#define INITIAL_CRC 0

#define ssh_crc32(buf, len)            ssh_crc32_final(buf, len, INITIAL_CRC)
#define ssh_crc32_initial(buf, len)    ssh_crc32_partial(buf, len, INITIAL_CRC)
#define ssh_crc32_final(buf, len, crc) ssh_crc32_partial(buf, len, crc)

#ifdef NO_CRC_AT_ALL

#define ssh_crc32_partial(buf, len, crc) (0)

#else /* NO_CRC_AT_ALL */

extern const u_int32_t table[];

static inline u_int32_t ssh_crc32_partial(u_int8_t *, size_t, u_int32_t);

static inline u_int32_t
ssh_crc32_partial(u_int8_t *buf, size_t len, u_int32_t crc) {
	u_int8_t *where;
	for (where = buf ; where < buf + len; where++) {
#ifdef SMALL_CRC_TABLE
		crc ^= *where;
		crc = (crc >> 4) ^ table[crc & 0xf];
		crc = (crc >> 4) ^ table[crc & 0xf];
#else /* SMALL_CRC_TABLE */
		crc = table[(crc ^ *where) & 0xFF] ^ (crc >> 8);
#endif /* SMALL_CRC_TABLE */
	}
	return (crc);
}

#endif /* NO_CRC_AT_ALL */

void free_mpint(struct ssh_mpint *);

char *authorized_keys_file(ssh_context_t *context);

void ssh_exit(ssh_context_t *, int, int)
#ifdef __GNUC__
	__attribute__((__noreturn__))
#endif
	;

int is_yes(const char *);
int is_no(const char *);
int is_ask(const char *);
int is_yes_or_no(const char *);
int is_yes_or_no_or_ask(const char *);

char *ssh_sockaddr_ntop(struct sockaddr *, char *, size_t);

#define setbinstr_len(plen, len) do { \
 	u_int32_t tmp = htonl(len); \
	memcpy(plen, &tmp, sizeof(u_int32_t)); \
} while (0)

#endif /* _SSH_UTIL_H */
