/* $Id: ssh_v1_auth_passwd_server.c,v 1.2 2001/02/11 03:35:17 tls Exp $ */

/*
 * Copyright 1999 RedBack Networks, Incorporated.
 * All rights reserved.
 *
 * This software is not in the public domain.  It is distributed
 * under the terms of the license in the file LICENSE in the
 * same directory as this file.  If you have received a copy of this
 * software without the LICENSE file (which means that whoever gave
 * you this software violated its license) you may obtain a copy from
 * http://www.panix.com/~tls/LICENSE.txt
 */

/*
 * Copyright (c) 2000, 2001 Andrew Brown, Eric Haszlakiewicz,
 *      and Jason Thorpe.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The names of the authors may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * SSHv1 password authentication: server-side routines.
 */

#include "options.h"

#ifdef WITH_AUTH_PASSWORD
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "sshd.h"
#include "ssh_buffer.h"
#include "ssh_sys.h"
#include "ssh_util.h"

#include "ssh_v1_auth_passwd.h"

/*
 * v1_auth_user_password
 *
 * Returns:
 *   RET_NEXT_STATE  Authenticated ok.
 *   RET_FAIL        Password authentication failed
 *   RET_FATAL       Fatal error, context->disconnect_msg set.
 */
int 
v1_auth_user_password(ssh_context_t *context, struct ssh_buf *buf,
    size_t size)
{
	FUNC_DECL(auth_user_password);
	u_int32_t pwlen;
	u_int8_t *password;

	password = NULL;

	if (buf_get_binstr(buf, &password, &pwlen) != 0) {
		SSH_DLOG(1, ("Unable to get password: %s\n", strerror(errno)));
		context->disconnect_msg = "Unable to get password.";
		return (RET_FATAL);
	}
	password[pwlen] = '\0';	/* Make sure it's NULL-terminated */

	if (ssh_sys_checkpw(context->username, password) != 0)
		return (RET_FAIL);

	return (RET_NEXT_STATE);
}
#endif /* WITH_AUTH_PASSWORD */
